/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.ApprovalMode;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.ApprovalStage;
import java.io.IOException;
import java.util.List;

public final class ApprovalSettings
implements JsonSerializable<ApprovalSettings> {
    private Boolean isApprovalRequired;
    private Boolean isApprovalRequiredForExtension;
    private Boolean isRequestorJustificationRequired;
    private ApprovalMode approvalMode;
    private List<ApprovalStage> approvalStages;

    public Boolean isApprovalRequired() {
        return this.isApprovalRequired;
    }

    public ApprovalSettings withIsApprovalRequired(Boolean isApprovalRequired) {
        this.isApprovalRequired = isApprovalRequired;
        return this;
    }

    public Boolean isApprovalRequiredForExtension() {
        return this.isApprovalRequiredForExtension;
    }

    public ApprovalSettings withIsApprovalRequiredForExtension(Boolean isApprovalRequiredForExtension) {
        this.isApprovalRequiredForExtension = isApprovalRequiredForExtension;
        return this;
    }

    public Boolean isRequestorJustificationRequired() {
        return this.isRequestorJustificationRequired;
    }

    public ApprovalSettings withIsRequestorJustificationRequired(Boolean isRequestorJustificationRequired) {
        this.isRequestorJustificationRequired = isRequestorJustificationRequired;
        return this;
    }

    public ApprovalMode approvalMode() {
        return this.approvalMode;
    }

    public ApprovalSettings withApprovalMode(ApprovalMode approvalMode) {
        this.approvalMode = approvalMode;
        return this;
    }

    public List<ApprovalStage> approvalStages() {
        return this.approvalStages;
    }

    public ApprovalSettings withApprovalStages(List<ApprovalStage> approvalStages) {
        this.approvalStages = approvalStages;
        return this;
    }

    public void validate() {
        if (this.approvalStages() != null) {
            this.approvalStages().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("isApprovalRequired", this.isApprovalRequired);
        jsonWriter.writeBooleanField("isApprovalRequiredForExtension", this.isApprovalRequiredForExtension);
        jsonWriter.writeBooleanField("isRequestorJustificationRequired", this.isRequestorJustificationRequired);
        jsonWriter.writeStringField("approvalMode", this.approvalMode == null ? null : this.approvalMode.toString());
        jsonWriter.writeArrayField("approvalStages", this.approvalStages, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static ApprovalSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApprovalSettings deserializedApprovalSettings = new ApprovalSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("isApprovalRequired".equals(fieldName)) {
                    deserializedApprovalSettings.isApprovalRequired = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isApprovalRequiredForExtension".equals(fieldName)) {
                    deserializedApprovalSettings.isApprovalRequiredForExtension = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isRequestorJustificationRequired".equals(fieldName)) {
                    deserializedApprovalSettings.isRequestorJustificationRequired = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("approvalMode".equals(fieldName)) {
                    deserializedApprovalSettings.approvalMode = ApprovalMode.fromString(reader.getString());
                    continue;
                }
                if ("approvalStages".equals(fieldName)) {
                    List<ApprovalStage> approvalStages = reader.readArray(reader1 -> ApprovalStage.fromJson(reader1));
                    deserializedApprovalSettings.approvalStages = approvalStages;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApprovalSettings;
        });
    }
}

