/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models.PrivateEndpointConnectionInner;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class DiskAccessProperties
implements JsonSerializable<DiskAccessProperties> {
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    private String provisioningState;
    private OffsetDateTime timeCreated;

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public OffsetDateTime timeCreated() {
        return this.timeCreated;
    }

    public void validate() {
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static DiskAccessProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DiskAccessProperties deserializedDiskAccessProperties = new DiskAccessProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("privateEndpointConnections".equals(fieldName)) {
                    List<PrivateEndpointConnectionInner> privateEndpointConnections = reader.readArray(reader1 -> PrivateEndpointConnectionInner.fromJson(reader1));
                    deserializedDiskAccessProperties.privateEndpointConnections = privateEndpointConnections;
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedDiskAccessProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("timeCreated".equals(fieldName)) {
                    deserializedDiskAccessProperties.timeCreated = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiskAccessProperties;
        });
    }
}

