/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.SharedGalleryImageVersionStorageProfile;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public final class SharedGalleryImageVersionProperties
implements JsonSerializable<SharedGalleryImageVersionProperties> {
    private OffsetDateTime publishedDate;
    private OffsetDateTime endOfLifeDate;
    private Boolean excludeFromLatest;
    private SharedGalleryImageVersionStorageProfile storageProfile;
    private Map<String, String> artifactTags;

    public OffsetDateTime publishedDate() {
        return this.publishedDate;
    }

    public SharedGalleryImageVersionProperties withPublishedDate(OffsetDateTime publishedDate) {
        this.publishedDate = publishedDate;
        return this;
    }

    public OffsetDateTime endOfLifeDate() {
        return this.endOfLifeDate;
    }

    public SharedGalleryImageVersionProperties withEndOfLifeDate(OffsetDateTime endOfLifeDate) {
        this.endOfLifeDate = endOfLifeDate;
        return this;
    }

    public Boolean excludeFromLatest() {
        return this.excludeFromLatest;
    }

    public SharedGalleryImageVersionProperties withExcludeFromLatest(Boolean excludeFromLatest) {
        this.excludeFromLatest = excludeFromLatest;
        return this;
    }

    public SharedGalleryImageVersionStorageProfile storageProfile() {
        return this.storageProfile;
    }

    public SharedGalleryImageVersionProperties withStorageProfile(SharedGalleryImageVersionStorageProfile storageProfile) {
        this.storageProfile = storageProfile;
        return this;
    }

    public Map<String, String> artifactTags() {
        return this.artifactTags;
    }

    public SharedGalleryImageVersionProperties withArtifactTags(Map<String, String> artifactTags) {
        this.artifactTags = artifactTags;
        return this;
    }

    public void validate() {
        if (this.storageProfile() != null) {
            this.storageProfile().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("publishedDate", this.publishedDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.publishedDate));
        jsonWriter.writeStringField("endOfLifeDate", this.endOfLifeDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endOfLifeDate));
        jsonWriter.writeBooleanField("excludeFromLatest", this.excludeFromLatest);
        jsonWriter.writeJsonField("storageProfile", this.storageProfile);
        jsonWriter.writeMapField("artifactTags", this.artifactTags, (writer, element) -> writer.writeString((String)element));
        return jsonWriter.writeEndObject();
    }

    public static SharedGalleryImageVersionProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SharedGalleryImageVersionProperties deserializedSharedGalleryImageVersionProperties = new SharedGalleryImageVersionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("publishedDate".equals(fieldName)) {
                    deserializedSharedGalleryImageVersionProperties.publishedDate = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("endOfLifeDate".equals(fieldName)) {
                    deserializedSharedGalleryImageVersionProperties.endOfLifeDate = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("excludeFromLatest".equals(fieldName)) {
                    deserializedSharedGalleryImageVersionProperties.excludeFromLatest = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("storageProfile".equals(fieldName)) {
                    deserializedSharedGalleryImageVersionProperties.storageProfile = SharedGalleryImageVersionStorageProfile.fromJson(reader);
                    continue;
                }
                if ("artifactTags".equals(fieldName)) {
                    Map<String, String> artifactTags = reader.readMap(reader1 -> reader1.getString());
                    deserializedSharedGalleryImageVersionProperties.artifactTags = artifactTags;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSharedGalleryImageVersionProperties;
        });
    }
}

