/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.ContainerInstanceManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.fluent.ContainerGroupsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.fluent.ContainerInstanceManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.fluent.models.ContainerGroupInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.fluent.models.LogsInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.implementation.ContainerAttachResultImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.implementation.ContainerGroupImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.CachedImages;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.Capabilities;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.ContainerAttachResult;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.ContainerGroup;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.ContainerGroups;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerinstance.models.Operation;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.TopLevelModifiableResourcesImpl;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public class ContainerGroupsImpl
extends TopLevelModifiableResourcesImpl<ContainerGroup, ContainerGroupImpl, ContainerGroupInner, ContainerGroupsClient, ContainerInstanceManager>
implements ContainerGroups {
    public ContainerGroupsImpl(ContainerInstanceManager manager) {
        super(((ContainerInstanceManagementClient)manager.serviceClient()).getContainerGroups(), manager);
    }

    @Override
    protected ContainerGroupImpl wrapModel(String name) {
        return new ContainerGroupImpl(name, new ContainerGroupInner(), (ContainerInstanceManager)this.manager());
    }

    @Override
    protected ContainerGroupImpl wrapModel(ContainerGroupInner inner) {
        if (inner == null) {
            return null;
        }
        return new ContainerGroupImpl(inner.name(), inner, (ContainerInstanceManager)this.manager());
    }

    @Override
    protected Mono<Void> deleteInnerAsync(String resourceGroupName, String name) {
        return ((ContainerInstanceManagementClient)((ContainerInstanceManager)this.manager()).serviceClient()).getContainerGroups().deleteAsync(resourceGroupName, name).then();
    }

    @Override
    public ContainerGroup.DefinitionStages.Blank define(String name) {
        return this.wrapModel(name);
    }

    @Override
    public String getLogContent(String resourceGroupName, String containerGroupName, String containerName) {
        LogsInner logsInner = ((ContainerInstanceManagementClient)((ContainerInstanceManager)this.manager()).serviceClient()).getContainers().listLogs(resourceGroupName, containerGroupName, containerName);
        return logsInner != null ? logsInner.content() : null;
    }

    @Override
    public String getLogContent(String resourceGroupName, String containerGroupName, String containerName, int tailLineCount) {
        LogsInner logsInner = ((ContainerInstanceManagementClient)((ContainerInstanceManager)this.manager()).serviceClient()).getContainers().listLogsWithResponse(resourceGroupName, containerGroupName, containerName, tailLineCount, null, Context.NONE).getValue();
        return logsInner != null ? logsInner.content() : null;
    }

    @Override
    public Mono<String> getLogContentAsync(String resourceGroupName, String containerGroupName, String containerName) {
        return ((ContainerInstanceManagementClient)((ContainerInstanceManager)this.manager()).serviceClient()).getContainers().listLogsAsync(resourceGroupName, containerGroupName, containerName).map(LogsInner::content);
    }

    @Override
    public Mono<String> getLogContentAsync(String resourceGroupName, String containerGroupName, String containerName, int tailLineCount) {
        return ((ContainerInstanceManagementClient)((ContainerInstanceManager)this.manager()).serviceClient()).getContainers().listLogsWithResponseAsync(resourceGroupName, containerGroupName, containerName, tailLineCount, null).map(Response::getValue).map(LogsInner::content);
    }

    @Override
    public PagedIterable<Operation> listOperations() {
        return new PagedIterable<Operation>(this.listOperationsAsync());
    }

    @Override
    public PagedFlux<Operation> listOperationsAsync() {
        return ((ContainerInstanceManagementClient)((ContainerInstanceManager)this.manager()).serviceClient()).getOperations().listAsync();
    }

    @Override
    public PagedIterable<CachedImages> listCachedImages(String location) {
        return new PagedIterable<CachedImages>(this.listCachedImagesAsync(location));
    }

    @Override
    public PagedFlux<CachedImages> listCachedImagesAsync(String location) {
        return ((ContainerInstanceManagementClient)((ContainerInstanceManager)this.manager()).serviceClient()).getLocations().listCachedImagesAsync(location);
    }

    @Override
    public PagedIterable<Capabilities> listCapabilities(String location) {
        return new PagedIterable<Capabilities>(this.listCapabilitiesAsync(location));
    }

    @Override
    public PagedFlux<Capabilities> listCapabilitiesAsync(String location) {
        return ((ContainerInstanceManagementClient)((ContainerInstanceManager)this.manager()).serviceClient()).getLocations().listCapabilitiesAsync(location);
    }

    @Override
    public void start(String resourceGroupName, String containerGroupName) {
        ((ContainerInstanceManagementClient)((ContainerInstanceManager)this.manager()).serviceClient()).getContainerGroups().start(resourceGroupName, containerGroupName);
    }

    @Override
    public Mono<Void> startAsync(String resourceGroupName, String containerGroupName) {
        return ((ContainerInstanceManagementClient)((ContainerInstanceManager)this.manager()).serviceClient()).getContainerGroups().startAsync(resourceGroupName, containerGroupName);
    }

    @Override
    public ContainerAttachResult attachOutputStream(String resourceGroupName, String containerGroupName, String containerName) {
        return this.attachOutputStreamAsync(resourceGroupName, containerGroupName, containerName).block();
    }

    @Override
    public Mono<ContainerAttachResult> attachOutputStreamAsync(String resourceGroupName, String containerGroupName, String containerName) {
        return ((ContainerInstanceManagementClient)((ContainerInstanceManager)this.manager()).serviceClient()).getContainers().attachAsync(resourceGroupName, containerGroupName, containerName).map(ContainerAttachResultImpl::new);
    }

    @Override
    public PagedFlux<ContainerGroup> listAsync() {
        return this.wrapPageAsync(((ContainerGroupsClient)this.inner()).listAsync());
    }

    @Override
    public PagedFlux<ContainerGroup> listByResourceGroupAsync(String resourceGroupName) {
        if (CoreUtils.isNullOrEmpty(resourceGroupName)) {
            return new PagedFlux<ContainerGroup>(() -> Mono.error(new IllegalArgumentException("Parameter 'resourceGroupName' is required and cannot be null.")));
        }
        return this.wrapPageAsync(((ContainerGroupsClient)this.inner()).listByResourceGroupAsync(resourceGroupName));
    }

    @Override
    public final PagedIterable<ContainerGroup> list() {
        return new PagedIterable<ContainerGroup>(this.listAsync());
    }

    @Override
    public PagedIterable<ContainerGroup> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable<ContainerGroup>(this.listByResourceGroupAsync(resourceGroupName));
    }
}

