/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.CustomRegistryCredentials;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerregistry.models.SourceRegistryCredentials;
import java.io.IOException;
import java.util.Map;

public final class Credentials
implements JsonSerializable<Credentials> {
    private SourceRegistryCredentials sourceRegistry;
    private Map<String, CustomRegistryCredentials> customRegistries;

    public SourceRegistryCredentials sourceRegistry() {
        return this.sourceRegistry;
    }

    public Credentials withSourceRegistry(SourceRegistryCredentials sourceRegistry) {
        this.sourceRegistry = sourceRegistry;
        return this;
    }

    public Map<String, CustomRegistryCredentials> customRegistries() {
        return this.customRegistries;
    }

    public Credentials withCustomRegistries(Map<String, CustomRegistryCredentials> customRegistries) {
        this.customRegistries = customRegistries;
        return this;
    }

    public void validate() {
        if (this.sourceRegistry() != null) {
            this.sourceRegistry().validate();
        }
        if (this.customRegistries() != null) {
            this.customRegistries().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sourceRegistry", this.sourceRegistry);
        jsonWriter.writeMapField("customRegistries", this.customRegistries, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static Credentials fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Credentials deserializedCredentials = new Credentials();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRegistry".equals(fieldName)) {
                    deserializedCredentials.sourceRegistry = SourceRegistryCredentials.fromJson(reader);
                    continue;
                }
                if ("customRegistries".equals(fieldName)) {
                    Map<String, CustomRegistryCredentials> customRegistries = reader.readMap(reader1 -> CustomRegistryCredentials.fromJson(reader1));
                    deserializedCredentials.customRegistries = customRegistries;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCredentials;
        });
    }
}

