/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.ManagedClusterPoolUpgradeProfile;
import java.io.IOException;
import java.util.List;

public final class ManagedClusterUpgradeProfileProperties
implements JsonSerializable<ManagedClusterUpgradeProfileProperties> {
    private ManagedClusterPoolUpgradeProfile controlPlaneProfile;
    private List<ManagedClusterPoolUpgradeProfile> agentPoolProfiles;
    private static final ClientLogger LOGGER = new ClientLogger(ManagedClusterUpgradeProfileProperties.class);

    public ManagedClusterPoolUpgradeProfile controlPlaneProfile() {
        return this.controlPlaneProfile;
    }

    public ManagedClusterUpgradeProfileProperties withControlPlaneProfile(ManagedClusterPoolUpgradeProfile controlPlaneProfile) {
        this.controlPlaneProfile = controlPlaneProfile;
        return this;
    }

    public List<ManagedClusterPoolUpgradeProfile> agentPoolProfiles() {
        return this.agentPoolProfiles;
    }

    public ManagedClusterUpgradeProfileProperties withAgentPoolProfiles(List<ManagedClusterPoolUpgradeProfile> agentPoolProfiles) {
        this.agentPoolProfiles = agentPoolProfiles;
        return this;
    }

    public void validate() {
        if (this.controlPlaneProfile() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property controlPlaneProfile in model ManagedClusterUpgradeProfileProperties"));
        }
        this.controlPlaneProfile().validate();
        if (this.agentPoolProfiles() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property agentPoolProfiles in model ManagedClusterUpgradeProfileProperties"));
        }
        this.agentPoolProfiles().forEach(e -> e.validate());
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("controlPlaneProfile", this.controlPlaneProfile);
        jsonWriter.writeArrayField("agentPoolProfiles", this.agentPoolProfiles, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static ManagedClusterUpgradeProfileProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedClusterUpgradeProfileProperties deserializedManagedClusterUpgradeProfileProperties = new ManagedClusterUpgradeProfileProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("controlPlaneProfile".equals(fieldName)) {
                    deserializedManagedClusterUpgradeProfileProperties.controlPlaneProfile = ManagedClusterPoolUpgradeProfile.fromJson(reader);
                    continue;
                }
                if ("agentPoolProfiles".equals(fieldName)) {
                    List<ManagedClusterPoolUpgradeProfile> agentPoolProfiles = reader.readArray(reader1 -> ManagedClusterPoolUpgradeProfile.fromJson(reader1));
                    deserializedManagedClusterUpgradeProfileProperties.agentPoolProfiles = agentPoolProfiles;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedClusterUpgradeProfileProperties;
        });
    }
}

