/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.KubernetesPatchVersion;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.containerservice.models.KubernetesVersionCapabilities;
import java.io.IOException;
import java.util.Map;

public final class KubernetesVersion
implements JsonSerializable<KubernetesVersion> {
    private String version;
    private KubernetesVersionCapabilities capabilities;
    private Boolean isDefault;
    private Boolean isPreview;
    private Map<String, KubernetesPatchVersion> patchVersions;

    public String version() {
        return this.version;
    }

    public KubernetesVersion withVersion(String version) {
        this.version = version;
        return this;
    }

    public KubernetesVersionCapabilities capabilities() {
        return this.capabilities;
    }

    public KubernetesVersion withCapabilities(KubernetesVersionCapabilities capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public Boolean isDefault() {
        return this.isDefault;
    }

    public KubernetesVersion withIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    public Boolean isPreview() {
        return this.isPreview;
    }

    public KubernetesVersion withIsPreview(Boolean isPreview) {
        this.isPreview = isPreview;
        return this;
    }

    public Map<String, KubernetesPatchVersion> patchVersions() {
        return this.patchVersions;
    }

    public KubernetesVersion withPatchVersions(Map<String, KubernetesPatchVersion> patchVersions) {
        this.patchVersions = patchVersions;
        return this;
    }

    public void validate() {
        if (this.capabilities() != null) {
            this.capabilities().validate();
        }
        if (this.patchVersions() != null) {
            this.patchVersions().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.version);
        jsonWriter.writeJsonField("capabilities", this.capabilities);
        jsonWriter.writeBooleanField("isDefault", this.isDefault);
        jsonWriter.writeBooleanField("isPreview", this.isPreview);
        jsonWriter.writeMapField("patchVersions", this.patchVersions, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static KubernetesVersion fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KubernetesVersion deserializedKubernetesVersion = new KubernetesVersion();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedKubernetesVersion.version = reader.getString();
                    continue;
                }
                if ("capabilities".equals(fieldName)) {
                    deserializedKubernetesVersion.capabilities = KubernetesVersionCapabilities.fromJson(reader);
                    continue;
                }
                if ("isDefault".equals(fieldName)) {
                    deserializedKubernetesVersion.isDefault = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isPreview".equals(fieldName)) {
                    deserializedKubernetesVersion.isPreview = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("patchVersions".equals(fieldName)) {
                    Map<String, KubernetesPatchVersion> patchVersions = reader.readMap(reader1 -> KubernetesPatchVersion.fromJson(reader1));
                    deserializedKubernetesVersion.patchVersions = patchVersions;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKubernetesVersion;
        });
    }
}

