/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.NetworkSecurityPerimeter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.NetworkSecurityPerimeterConfigurationPropertiesProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.NetworkSecurityPerimeterConfigurationProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.eventhubs.models.ProvisioningIssue;
import java.io.IOException;
import java.util.List;

public final class NetworkSecurityPerimeterConfigurationProperties
implements JsonSerializable<NetworkSecurityPerimeterConfigurationProperties> {
    private NetworkSecurityPerimeterConfigurationProvisioningState provisioningState;
    private List<ProvisioningIssue> provisioningIssues;
    private NetworkSecurityPerimeter networkSecurityPerimeter;
    private NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation resourceAssociation;
    private NetworkSecurityPerimeterConfigurationPropertiesProfile profile;
    private Boolean isBackingResource;
    private List<String> applicableFeatures;
    private String parentAssociationName;
    private String sourceResourceId;

    public NetworkSecurityPerimeterConfigurationProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public NetworkSecurityPerimeterConfigurationProperties withProvisioningState(NetworkSecurityPerimeterConfigurationProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public List<ProvisioningIssue> provisioningIssues() {
        return this.provisioningIssues;
    }

    public NetworkSecurityPerimeterConfigurationProperties withProvisioningIssues(List<ProvisioningIssue> provisioningIssues) {
        this.provisioningIssues = provisioningIssues;
        return this;
    }

    public NetworkSecurityPerimeter networkSecurityPerimeter() {
        return this.networkSecurityPerimeter;
    }

    public NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation resourceAssociation() {
        return this.resourceAssociation;
    }

    public NetworkSecurityPerimeterConfigurationPropertiesProfile profile() {
        return this.profile;
    }

    public Boolean isBackingResource() {
        return this.isBackingResource;
    }

    public List<String> applicableFeatures() {
        return this.applicableFeatures;
    }

    public String parentAssociationName() {
        return this.parentAssociationName;
    }

    public String sourceResourceId() {
        return this.sourceResourceId;
    }

    public void validate() {
        if (this.provisioningIssues() != null) {
            this.provisioningIssues().forEach(e -> e.validate());
        }
        if (this.networkSecurityPerimeter() != null) {
            this.networkSecurityPerimeter().validate();
        }
        if (this.resourceAssociation() != null) {
            this.resourceAssociation().validate();
        }
        if (this.profile() != null) {
            this.profile().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("provisioningState", this.provisioningState == null ? null : this.provisioningState.toString());
        jsonWriter.writeArrayField("provisioningIssues", this.provisioningIssues, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static NetworkSecurityPerimeterConfigurationProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkSecurityPerimeterConfigurationProperties deserializedNetworkSecurityPerimeterConfigurationProperties = new NetworkSecurityPerimeterConfigurationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationProperties.provisioningState = NetworkSecurityPerimeterConfigurationProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("provisioningIssues".equals(fieldName)) {
                    List<ProvisioningIssue> provisioningIssues = reader.readArray(reader1 -> ProvisioningIssue.fromJson(reader1));
                    deserializedNetworkSecurityPerimeterConfigurationProperties.provisioningIssues = provisioningIssues;
                    continue;
                }
                if ("networkSecurityPerimeter".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationProperties.networkSecurityPerimeter = NetworkSecurityPerimeter.fromJson(reader);
                    continue;
                }
                if ("resourceAssociation".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationProperties.resourceAssociation = NetworkSecurityPerimeterConfigurationPropertiesResourceAssociation.fromJson(reader);
                    continue;
                }
                if ("profile".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationProperties.profile = NetworkSecurityPerimeterConfigurationPropertiesProfile.fromJson(reader);
                    continue;
                }
                if ("isBackingResource".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationProperties.isBackingResource = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("applicableFeatures".equals(fieldName)) {
                    List<String> applicableFeatures = reader.readArray(reader1 -> reader1.getString());
                    deserializedNetworkSecurityPerimeterConfigurationProperties.applicableFeatures = applicableFeatures;
                    continue;
                }
                if ("parentAssociationName".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationProperties.parentAssociationName = reader.getString();
                    continue;
                }
                if ("sourceResourceId".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationProperties.sourceResourceId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkSecurityPerimeterConfigurationProperties;
        });
    }
}

