/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.ActiveDirectoryGroup;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.ActiveDirectoryUser;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.ServicePrincipal;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.implementation.VaultImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.AccessPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.AccessPolicyEntry;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.CertificatePermissions;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.KeyPermissions;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.Permissions;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.SecretPermissions;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.StoragePermissions;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.keyvault.models.Vault;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

class AccessPolicyImpl
extends ChildResourceImpl<AccessPolicyEntry, VaultImpl, Vault>
implements AccessPolicy,
AccessPolicy.Definition<Vault.DefinitionStages.WithCreate>,
AccessPolicy.UpdateDefinition<Vault.Update>,
AccessPolicy.Update {
    private String userPrincipalName;
    private String servicePrincipalName;

    AccessPolicyImpl(AccessPolicyEntry innerObject, VaultImpl parent) {
        super(innerObject, parent);
        ((AccessPolicyEntry)this.innerModel()).withTenantId(UUID.fromString(parent.tenantId()));
    }

    String userPrincipalName() {
        return this.userPrincipalName;
    }

    String servicePrincipalName() {
        return this.servicePrincipalName;
    }

    @Override
    public String tenantId() {
        if (((AccessPolicyEntry)this.innerModel()).tenantId() == null) {
            return null;
        }
        return ((AccessPolicyEntry)this.innerModel()).tenantId().toString();
    }

    @Override
    public String objectId() {
        if (((AccessPolicyEntry)this.innerModel()).objectId() == null) {
            return null;
        }
        return ((AccessPolicyEntry)this.innerModel()).objectId();
    }

    @Override
    public String applicationId() {
        if (((AccessPolicyEntry)this.innerModel()).applicationId() == null) {
            return null;
        }
        return ((AccessPolicyEntry)this.innerModel()).applicationId().toString();
    }

    @Override
    public Permissions permissions() {
        return ((AccessPolicyEntry)this.innerModel()).permissions();
    }

    @Override
    public String name() {
        return ((AccessPolicyEntry)this.innerModel()).objectId();
    }

    private void initializeKeyPermissions() {
        if (((AccessPolicyEntry)this.innerModel()).permissions() == null) {
            ((AccessPolicyEntry)this.innerModel()).withPermissions(new Permissions());
        }
        if (((AccessPolicyEntry)this.innerModel()).permissions().keys() == null) {
            ((AccessPolicyEntry)this.innerModel()).permissions().withKeys(new ArrayList<KeyPermissions>());
        }
    }

    private void initializeSecretPermissions() {
        if (((AccessPolicyEntry)this.innerModel()).permissions() == null) {
            ((AccessPolicyEntry)this.innerModel()).withPermissions(new Permissions());
        }
        if (((AccessPolicyEntry)this.innerModel()).permissions().secrets() == null) {
            ((AccessPolicyEntry)this.innerModel()).permissions().withSecrets(new ArrayList<SecretPermissions>());
        }
    }

    private void initializeCertificatePermissions() {
        if (((AccessPolicyEntry)this.innerModel()).permissions() == null) {
            ((AccessPolicyEntry)this.innerModel()).withPermissions(new Permissions());
        }
        if (((AccessPolicyEntry)this.innerModel()).permissions().certificates() == null) {
            ((AccessPolicyEntry)this.innerModel()).permissions().withCertificates(new ArrayList<CertificatePermissions>());
        }
    }

    private void initializeStoragePermissions() {
        if (((AccessPolicyEntry)this.innerModel()).permissions() == null) {
            ((AccessPolicyEntry)this.innerModel()).withPermissions(new Permissions());
        }
        if (((AccessPolicyEntry)this.innerModel()).permissions().storage() == null) {
            ((AccessPolicyEntry)this.innerModel()).permissions().withStorage(new ArrayList<StoragePermissions>());
        }
    }

    @Override
    public AccessPolicyImpl allowKeyPermissions(KeyPermissions ... permissions) {
        this.initializeKeyPermissions();
        for (KeyPermissions permission : permissions) {
            if (((AccessPolicyEntry)this.innerModel()).permissions().keys().contains(permission)) continue;
            ((AccessPolicyEntry)this.innerModel()).permissions().keys().add(permission);
        }
        return this;
    }

    @Override
    public AccessPolicyImpl allowKeyPermissions(List<KeyPermissions> permissions) {
        this.initializeKeyPermissions();
        for (KeyPermissions permission : permissions) {
            if (((AccessPolicyEntry)this.innerModel()).permissions().keys().contains(permission)) continue;
            ((AccessPolicyEntry)this.innerModel()).permissions().keys().add(permission);
        }
        return this;
    }

    @Override
    public AccessPolicyImpl allowSecretPermissions(SecretPermissions ... permissions) {
        this.initializeSecretPermissions();
        for (SecretPermissions permission : permissions) {
            if (((AccessPolicyEntry)this.innerModel()).permissions().secrets().contains(permission)) continue;
            ((AccessPolicyEntry)this.innerModel()).permissions().secrets().add(permission);
        }
        return this;
    }

    @Override
    public AccessPolicyImpl allowSecretPermissions(List<SecretPermissions> permissions) {
        this.initializeSecretPermissions();
        for (SecretPermissions permission : permissions) {
            if (((AccessPolicyEntry)this.innerModel()).permissions().secrets().contains(permission)) continue;
            ((AccessPolicyEntry)this.innerModel()).permissions().secrets().add(permission);
        }
        return this;
    }

    @Override
    public AccessPolicyImpl allowCertificateAllPermissions() {
        for (CertificatePermissions permission : CertificatePermissions.values()) {
            this.allowCertificatePermissions(permission);
        }
        return this;
    }

    @Override
    public AccessPolicyImpl allowCertificatePermissions(CertificatePermissions ... permissions) {
        this.initializeCertificatePermissions();
        for (CertificatePermissions permission : permissions) {
            if (((AccessPolicyEntry)this.innerModel()).permissions().certificates().contains(permission)) continue;
            ((AccessPolicyEntry)this.innerModel()).permissions().certificates().add(permission);
        }
        return this;
    }

    @Override
    public AccessPolicyImpl allowCertificatePermissions(List<CertificatePermissions> permissions) {
        this.initializeCertificatePermissions();
        for (CertificatePermissions permission : permissions) {
            if (((AccessPolicyEntry)this.innerModel()).permissions().certificates().contains(permission)) continue;
            ((AccessPolicyEntry)this.innerModel()).permissions().certificates().add(permission);
        }
        return this;
    }

    @Override
    public AccessPolicyImpl allowStorageAllPermissions() {
        for (StoragePermissions permission : StoragePermissions.values()) {
            this.allowStoragePermissions(permission);
        }
        return this;
    }

    @Override
    public AccessPolicyImpl allowStoragePermissions(StoragePermissions ... permissions) {
        this.initializeStoragePermissions();
        for (StoragePermissions permission : permissions) {
            if (((AccessPolicyEntry)this.innerModel()).permissions().storage().contains(permission)) continue;
            ((AccessPolicyEntry)this.innerModel()).permissions().storage().add(permission);
        }
        return this;
    }

    @Override
    public AccessPolicyImpl allowStoragePermissions(List<StoragePermissions> permissions) {
        this.initializeStoragePermissions();
        for (StoragePermissions permission : permissions) {
            if (((AccessPolicyEntry)this.innerModel()).permissions().storage().contains(permission)) continue;
            ((AccessPolicyEntry)this.innerModel()).permissions().storage().add(permission);
        }
        return this;
    }

    @Override
    public AccessPolicyImpl disallowCertificateAllPermissions() {
        this.initializeCertificatePermissions();
        ((AccessPolicyEntry)this.innerModel()).permissions().secrets().clear();
        return this;
    }

    @Override
    public AccessPolicyImpl disallowCertificatePermissions(CertificatePermissions ... permissions) {
        this.initializeCertificatePermissions();
        ((AccessPolicyEntry)this.innerModel()).permissions().certificates().removeAll(Arrays.asList(permissions));
        return this;
    }

    @Override
    public AccessPolicyImpl disallowCertificatePermissions(List<CertificatePermissions> permissions) {
        this.initializeCertificatePermissions();
        ((AccessPolicyEntry)this.innerModel()).permissions().certificates().removeAll(permissions);
        return this;
    }

    @Override
    public VaultImpl attach() {
        ((VaultImpl)this.parent()).withAccessPolicy(this);
        return (VaultImpl)this.parent();
    }

    public AccessPolicyImpl forObjectId(String objectId) {
        ((AccessPolicyEntry)this.innerModel()).withObjectId(objectId);
        return this;
    }

    public AccessPolicyImpl forUser(ActiveDirectoryUser user) {
        ((AccessPolicyEntry)this.innerModel()).withObjectId(user.id());
        return this;
    }

    public AccessPolicyImpl forUser(String userPrincipalName) {
        this.userPrincipalName = userPrincipalName;
        return this;
    }

    public AccessPolicyImpl forApplicationId(String applicationId) {
        ((AccessPolicyEntry)this.innerModel()).withApplicationId(UUID.fromString(applicationId));
        return this;
    }

    public AccessPolicyImpl forTenantId(String tenantId) {
        ((AccessPolicyEntry)this.innerModel()).withTenantId(UUID.fromString(tenantId));
        return this;
    }

    public AccessPolicyImpl forGroup(ActiveDirectoryGroup activeDirectoryGroup) {
        ((AccessPolicyEntry)this.innerModel()).withObjectId(activeDirectoryGroup.id());
        return this;
    }

    public AccessPolicyImpl forServicePrincipal(ServicePrincipal servicePrincipal) {
        ((AccessPolicyEntry)this.innerModel()).withObjectId(servicePrincipal.id());
        return this;
    }

    public AccessPolicyImpl forServicePrincipal(String servicePrincipalName) {
        this.servicePrincipalName = servicePrincipalName;
        return this;
    }

    @Override
    public AccessPolicyImpl allowKeyAllPermissions() {
        for (KeyPermissions permission : KeyPermissions.values()) {
            this.allowKeyPermissions(permission);
        }
        return this;
    }

    @Override
    public AccessPolicyImpl disallowKeyAllPermissions() {
        this.initializeKeyPermissions();
        ((AccessPolicyEntry)this.innerModel()).permissions().keys().clear();
        return this;
    }

    @Override
    public AccessPolicyImpl disallowKeyPermissions(KeyPermissions ... permissions) {
        this.initializeSecretPermissions();
        ((AccessPolicyEntry)this.innerModel()).permissions().keys().removeAll(Arrays.asList(permissions));
        return this;
    }

    @Override
    public AccessPolicyImpl disallowKeyPermissions(List<KeyPermissions> permissions) {
        this.initializeSecretPermissions();
        ((AccessPolicyEntry)this.innerModel()).permissions().keys().removeAll(permissions);
        return this;
    }

    @Override
    public AccessPolicyImpl allowSecretAllPermissions() {
        for (SecretPermissions permission : SecretPermissions.values()) {
            this.allowSecretPermissions(permission);
        }
        return this;
    }

    @Override
    public AccessPolicyImpl disallowSecretAllPermissions() {
        this.initializeSecretPermissions();
        ((AccessPolicyEntry)this.innerModel()).permissions().secrets().clear();
        return this;
    }

    @Override
    public AccessPolicyImpl disallowSecretPermissions(SecretPermissions ... permissions) {
        this.initializeSecretPermissions();
        ((AccessPolicyEntry)this.innerModel()).permissions().secrets().removeAll(Arrays.asList(permissions));
        return this;
    }

    @Override
    public AccessPolicyImpl disallowSecretPermissions(List<SecretPermissions> permissions) {
        this.initializeSecretPermissions();
        ((AccessPolicyEntry)this.innerModel()).permissions().secrets().removeAll(permissions);
        return this;
    }

    @Override
    public AccessPolicyImpl disallowStorageAllPermissions() {
        this.initializeStoragePermissions();
        ((AccessPolicyEntry)this.innerModel()).permissions().storage().clear();
        return this;
    }

    @Override
    public AccessPolicyImpl disallowStoragePermissions(StoragePermissions ... permissions) {
        this.initializeStoragePermissions();
        ((AccessPolicyEntry)this.innerModel()).permissions().storage().removeAll(Arrays.asList(permissions));
        return this;
    }

    @Override
    public AccessPolicyImpl disallowStoragePermissions(List<StoragePermissions> permissions) {
        this.initializeStoragePermissions();
        ((AccessPolicyEntry)this.innerModel()).permissions().storage().removeAll(permissions);
        return this;
    }
}

