/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.MetricAlertAction;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.MetricAlertCriteria;
import java.io.IOException;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.List;

public final class MetricAlertPropertiesPatch
implements JsonSerializable<MetricAlertPropertiesPatch> {
    private String description;
    private Integer severity;
    private Boolean enabled;
    private List<String> scopes;
    private Duration evaluationFrequency;
    private Duration windowSize;
    private String targetResourceType;
    private String targetResourceRegion;
    private MetricAlertCriteria criteria;
    private Boolean autoMitigate;
    private List<MetricAlertAction> actions;
    private OffsetDateTime lastUpdatedTime;
    private Boolean isMigrated;

    public String description() {
        return this.description;
    }

    public MetricAlertPropertiesPatch withDescription(String description) {
        this.description = description;
        return this;
    }

    public Integer severity() {
        return this.severity;
    }

    public MetricAlertPropertiesPatch withSeverity(Integer severity) {
        this.severity = severity;
        return this;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public MetricAlertPropertiesPatch withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public List<String> scopes() {
        return this.scopes;
    }

    public MetricAlertPropertiesPatch withScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public Duration evaluationFrequency() {
        return this.evaluationFrequency;
    }

    public MetricAlertPropertiesPatch withEvaluationFrequency(Duration evaluationFrequency) {
        this.evaluationFrequency = evaluationFrequency;
        return this;
    }

    public Duration windowSize() {
        return this.windowSize;
    }

    public MetricAlertPropertiesPatch withWindowSize(Duration windowSize) {
        this.windowSize = windowSize;
        return this;
    }

    public String targetResourceType() {
        return this.targetResourceType;
    }

    public MetricAlertPropertiesPatch withTargetResourceType(String targetResourceType) {
        this.targetResourceType = targetResourceType;
        return this;
    }

    public String targetResourceRegion() {
        return this.targetResourceRegion;
    }

    public MetricAlertPropertiesPatch withTargetResourceRegion(String targetResourceRegion) {
        this.targetResourceRegion = targetResourceRegion;
        return this;
    }

    public MetricAlertCriteria criteria() {
        return this.criteria;
    }

    public MetricAlertPropertiesPatch withCriteria(MetricAlertCriteria criteria) {
        this.criteria = criteria;
        return this;
    }

    public Boolean autoMitigate() {
        return this.autoMitigate;
    }

    public MetricAlertPropertiesPatch withAutoMitigate(Boolean autoMitigate) {
        this.autoMitigate = autoMitigate;
        return this;
    }

    public List<MetricAlertAction> actions() {
        return this.actions;
    }

    public MetricAlertPropertiesPatch withActions(List<MetricAlertAction> actions) {
        this.actions = actions;
        return this;
    }

    public OffsetDateTime lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Boolean isMigrated() {
        return this.isMigrated;
    }

    public void validate() {
        if (this.criteria() != null) {
            this.criteria().validate();
        }
        if (this.actions() != null) {
            this.actions().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeNumberField("severity", this.severity);
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeArrayField("scopes", this.scopes, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeStringField("evaluationFrequency", CoreUtils.durationToStringWithDays(this.evaluationFrequency));
        jsonWriter.writeStringField("windowSize", CoreUtils.durationToStringWithDays(this.windowSize));
        jsonWriter.writeStringField("targetResourceType", this.targetResourceType);
        jsonWriter.writeStringField("targetResourceRegion", this.targetResourceRegion);
        jsonWriter.writeJsonField("criteria", this.criteria);
        jsonWriter.writeBooleanField("autoMitigate", this.autoMitigate);
        jsonWriter.writeArrayField("actions", this.actions, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static MetricAlertPropertiesPatch fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MetricAlertPropertiesPatch deserializedMetricAlertPropertiesPatch = new MetricAlertPropertiesPatch();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedMetricAlertPropertiesPatch.description = reader.getString();
                    continue;
                }
                if ("severity".equals(fieldName)) {
                    deserializedMetricAlertPropertiesPatch.severity = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("enabled".equals(fieldName)) {
                    deserializedMetricAlertPropertiesPatch.enabled = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("scopes".equals(fieldName)) {
                    List<String> scopes = reader.readArray(reader1 -> reader1.getString());
                    deserializedMetricAlertPropertiesPatch.scopes = scopes;
                    continue;
                }
                if ("evaluationFrequency".equals(fieldName)) {
                    deserializedMetricAlertPropertiesPatch.evaluationFrequency = reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("windowSize".equals(fieldName)) {
                    deserializedMetricAlertPropertiesPatch.windowSize = reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("targetResourceType".equals(fieldName)) {
                    deserializedMetricAlertPropertiesPatch.targetResourceType = reader.getString();
                    continue;
                }
                if ("targetResourceRegion".equals(fieldName)) {
                    deserializedMetricAlertPropertiesPatch.targetResourceRegion = reader.getString();
                    continue;
                }
                if ("criteria".equals(fieldName)) {
                    deserializedMetricAlertPropertiesPatch.criteria = MetricAlertCriteria.fromJson(reader);
                    continue;
                }
                if ("autoMitigate".equals(fieldName)) {
                    deserializedMetricAlertPropertiesPatch.autoMitigate = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("actions".equals(fieldName)) {
                    List<MetricAlertAction> actions = reader.readArray(reader1 -> MetricAlertAction.fromJson(reader1));
                    deserializedMetricAlertPropertiesPatch.actions = actions;
                    continue;
                }
                if ("lastUpdatedTime".equals(fieldName)) {
                    deserializedMetricAlertPropertiesPatch.lastUpdatedTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("isMigrated".equals(fieldName)) {
                    deserializedMetricAlertPropertiesPatch.isMigrated = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMetricAlertPropertiesPatch;
        });
    }
}

