/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.fluent.VMInsightsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.fluent.models.VMInsightsOnboardingStatusInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.implementation.MonitorClientImpl;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public final class VMInsightsClientImpl
implements VMInsightsClient {
    private final VMInsightsService service;
    private final MonitorClientImpl client;

    VMInsightsClientImpl(MonitorClientImpl client) {
        this.service = RestProxy.create(VMInsightsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<VMInsightsOnboardingStatusInner>> getOnboardingStatusWithResponseAsync(String resourceUri) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        String apiVersion = "2018-11-27-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getOnboardingStatus(this.client.getEndpoint(), "2018-11-27-preview", resourceUri, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<VMInsightsOnboardingStatusInner>> getOnboardingStatusWithResponseAsync(String resourceUri, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceUri == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceUri is required and cannot be null."));
        }
        String apiVersion = "2018-11-27-preview";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getOnboardingStatus(this.client.getEndpoint(), "2018-11-27-preview", resourceUri, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VMInsightsOnboardingStatusInner> getOnboardingStatusAsync(String resourceUri) {
        return this.getOnboardingStatusWithResponseAsync(resourceUri).flatMap(res -> Mono.justOrEmpty((VMInsightsOnboardingStatusInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<VMInsightsOnboardingStatusInner> getOnboardingStatusWithResponse(String resourceUri, Context context) {
        return this.getOnboardingStatusWithResponseAsync(resourceUri, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VMInsightsOnboardingStatusInner getOnboardingStatus(String resourceUri) {
        return this.getOnboardingStatusWithResponse(resourceUri, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MonitorClientVMInsig")
    public static interface VMInsightsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{resourceUri}/providers/Microsoft.Insights/vmInsightsOnboardingStatuses/default")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VMInsightsOnboardingStatusInner>> getOnboardingStatus(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="resourceUri", encoded=true) String var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

