/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.AggregationTypeEnum;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.CriterionType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.DynamicThresholdFailingPeriods;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.DynamicThresholdOperator;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.DynamicThresholdSensitivity;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.MetricDimension;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.MultiMetricCriteria;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class DynamicMetricCriteria
extends MultiMetricCriteria {
    private CriterionType criterionType = CriterionType.DYNAMIC_THRESHOLD_CRITERION;
    private DynamicThresholdOperator operator;
    private DynamicThresholdSensitivity alertSensitivity;
    private DynamicThresholdFailingPeriods failingPeriods;
    private OffsetDateTime ignoreDataBefore;
    private static final ClientLogger LOGGER = new ClientLogger(DynamicMetricCriteria.class);

    @Override
    public CriterionType criterionType() {
        return this.criterionType;
    }

    public DynamicThresholdOperator operator() {
        return this.operator;
    }

    public DynamicMetricCriteria withOperator(DynamicThresholdOperator operator) {
        this.operator = operator;
        return this;
    }

    public DynamicThresholdSensitivity alertSensitivity() {
        return this.alertSensitivity;
    }

    public DynamicMetricCriteria withAlertSensitivity(DynamicThresholdSensitivity alertSensitivity) {
        this.alertSensitivity = alertSensitivity;
        return this;
    }

    public DynamicThresholdFailingPeriods failingPeriods() {
        return this.failingPeriods;
    }

    public DynamicMetricCriteria withFailingPeriods(DynamicThresholdFailingPeriods failingPeriods) {
        this.failingPeriods = failingPeriods;
        return this;
    }

    public OffsetDateTime ignoreDataBefore() {
        return this.ignoreDataBefore;
    }

    public DynamicMetricCriteria withIgnoreDataBefore(OffsetDateTime ignoreDataBefore) {
        this.ignoreDataBefore = ignoreDataBefore;
        return this;
    }

    @Override
    public DynamicMetricCriteria withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public DynamicMetricCriteria withMetricName(String metricName) {
        super.withMetricName(metricName);
        return this;
    }

    @Override
    public DynamicMetricCriteria withMetricNamespace(String metricNamespace) {
        super.withMetricNamespace(metricNamespace);
        return this;
    }

    @Override
    public DynamicMetricCriteria withTimeAggregation(AggregationTypeEnum timeAggregation) {
        super.withTimeAggregation(timeAggregation);
        return this;
    }

    @Override
    public DynamicMetricCriteria withDimensions(List<MetricDimension> dimensions) {
        super.withDimensions(dimensions);
        return this;
    }

    @Override
    public DynamicMetricCriteria withSkipMetricValidation(Boolean skipMetricValidation) {
        super.withSkipMetricValidation(skipMetricValidation);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.operator() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property operator in model DynamicMetricCriteria"));
        }
        if (this.alertSensitivity() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property alertSensitivity in model DynamicMetricCriteria"));
        }
        if (this.failingPeriods() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property failingPeriods in model DynamicMetricCriteria"));
        }
        this.failingPeriods().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("metricName", this.metricName());
        jsonWriter.writeStringField("timeAggregation", this.timeAggregation() == null ? null : this.timeAggregation().toString());
        jsonWriter.writeStringField("metricNamespace", this.metricNamespace());
        jsonWriter.writeArrayField("dimensions", this.dimensions(), (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeBooleanField("skipMetricValidation", this.skipMetricValidation());
        jsonWriter.writeStringField("operator", this.operator == null ? null : this.operator.toString());
        jsonWriter.writeStringField("alertSensitivity", this.alertSensitivity == null ? null : this.alertSensitivity.toString());
        jsonWriter.writeJsonField("failingPeriods", this.failingPeriods);
        jsonWriter.writeStringField("criterionType", this.criterionType == null ? null : this.criterionType.toString());
        jsonWriter.writeStringField("ignoreDataBefore", this.ignoreDataBefore == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.ignoreDataBefore));
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static DynamicMetricCriteria fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DynamicMetricCriteria deserializedDynamicMetricCriteria = new DynamicMetricCriteria();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedDynamicMetricCriteria.withName(reader.getString());
                    continue;
                }
                if ("metricName".equals(fieldName)) {
                    deserializedDynamicMetricCriteria.withMetricName(reader.getString());
                    continue;
                }
                if ("timeAggregation".equals(fieldName)) {
                    deserializedDynamicMetricCriteria.withTimeAggregation(AggregationTypeEnum.fromString(reader.getString()));
                    continue;
                }
                if ("metricNamespace".equals(fieldName)) {
                    deserializedDynamicMetricCriteria.withMetricNamespace(reader.getString());
                    continue;
                }
                if ("dimensions".equals(fieldName)) {
                    List<MetricDimension> dimensions = reader.readArray(reader1 -> MetricDimension.fromJson(reader1));
                    deserializedDynamicMetricCriteria.withDimensions((List)dimensions);
                    continue;
                }
                if ("skipMetricValidation".equals(fieldName)) {
                    deserializedDynamicMetricCriteria.withSkipMetricValidation(reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("operator".equals(fieldName)) {
                    deserializedDynamicMetricCriteria.operator = DynamicThresholdOperator.fromString(reader.getString());
                    continue;
                }
                if ("alertSensitivity".equals(fieldName)) {
                    deserializedDynamicMetricCriteria.alertSensitivity = DynamicThresholdSensitivity.fromString(reader.getString());
                    continue;
                }
                if ("failingPeriods".equals(fieldName)) {
                    deserializedDynamicMetricCriteria.failingPeriods = DynamicThresholdFailingPeriods.fromJson(reader);
                    continue;
                }
                if ("criterionType".equals(fieldName)) {
                    deserializedDynamicMetricCriteria.criterionType = CriterionType.fromString(reader.getString());
                    continue;
                }
                if ("ignoreDataBefore".equals(fieldName)) {
                    deserializedDynamicMetricCriteria.ignoreDataBefore = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedDynamicMetricCriteria.withAdditionalProperties(additionalProperties);
            return deserializedDynamicMetricCriteria;
        });
    }
}

