/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public final class MetricAlertStatusProperties
implements JsonSerializable<MetricAlertStatusProperties> {
    private Map<String, String> dimensions;
    private String status;
    private OffsetDateTime timestamp;

    public Map<String, String> dimensions() {
        return this.dimensions;
    }

    public MetricAlertStatusProperties withDimensions(Map<String, String> dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public String status() {
        return this.status;
    }

    public MetricAlertStatusProperties withStatus(String status) {
        this.status = status;
        return this;
    }

    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    public MetricAlertStatusProperties withTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("dimensions", this.dimensions, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeStringField("status", this.status);
        jsonWriter.writeStringField("timestamp", this.timestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timestamp));
        return jsonWriter.writeEndObject();
    }

    public static MetricAlertStatusProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MetricAlertStatusProperties deserializedMetricAlertStatusProperties = new MetricAlertStatusProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dimensions".equals(fieldName)) {
                    Map<String, String> dimensions = reader.readMap(reader1 -> reader1.getString());
                    deserializedMetricAlertStatusProperties.dimensions = dimensions;
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedMetricAlertStatusProperties.status = reader.getString();
                    continue;
                }
                if ("timestamp".equals(fieldName)) {
                    deserializedMetricAlertStatusProperties.timestamp = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMetricAlertStatusProperties;
        });
    }
}

