/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class RecurrentSchedule
implements JsonSerializable<RecurrentSchedule> {
    private String timeZone;
    private List<String> days;
    private List<Integer> hours;
    private List<Integer> minutes;
    private static final ClientLogger LOGGER = new ClientLogger(RecurrentSchedule.class);

    public String timeZone() {
        return this.timeZone;
    }

    public RecurrentSchedule withTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public List<String> days() {
        return this.days;
    }

    public RecurrentSchedule withDays(List<String> days) {
        this.days = days;
        return this;
    }

    public List<Integer> hours() {
        return this.hours;
    }

    public RecurrentSchedule withHours(List<Integer> hours) {
        this.hours = hours;
        return this;
    }

    public List<Integer> minutes() {
        return this.minutes;
    }

    public RecurrentSchedule withMinutes(List<Integer> minutes) {
        this.minutes = minutes;
        return this;
    }

    public void validate() {
        if (this.timeZone() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property timeZone in model RecurrentSchedule"));
        }
        if (this.days() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property days in model RecurrentSchedule"));
        }
        if (this.hours() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property hours in model RecurrentSchedule"));
        }
        if (this.minutes() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property minutes in model RecurrentSchedule"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("timeZone", this.timeZone);
        jsonWriter.writeArrayField("days", this.days, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("hours", this.hours, (writer, element) -> writer.writeInt((int)element));
        jsonWriter.writeArrayField("minutes", this.minutes, (writer, element) -> writer.writeInt((int)element));
        return jsonWriter.writeEndObject();
    }

    public static RecurrentSchedule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RecurrentSchedule deserializedRecurrentSchedule = new RecurrentSchedule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("timeZone".equals(fieldName)) {
                    deserializedRecurrentSchedule.timeZone = reader.getString();
                    continue;
                }
                if ("days".equals(fieldName)) {
                    List<String> days = reader.readArray(reader1 -> reader1.getString());
                    deserializedRecurrentSchedule.days = days;
                    continue;
                }
                if ("hours".equals(fieldName)) {
                    List<Integer> hours = reader.readArray(reader1 -> reader1.getInt());
                    deserializedRecurrentSchedule.hours = hours;
                    continue;
                }
                if ("minutes".equals(fieldName)) {
                    List<Integer> minutes = reader.readArray(reader1 -> reader1.getInt());
                    deserializedRecurrentSchedule.minutes = minutes;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRecurrentSchedule;
        });
    }
}

