/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.monitor.models.BaselineSensitivity;
import java.io.IOException;
import java.util.List;

public final class SingleBaseline
implements JsonSerializable<SingleBaseline> {
    private BaselineSensitivity sensitivity;
    private List<Double> lowThresholds;
    private List<Double> highThresholds;
    private static final ClientLogger LOGGER = new ClientLogger(SingleBaseline.class);

    public BaselineSensitivity sensitivity() {
        return this.sensitivity;
    }

    public SingleBaseline withSensitivity(BaselineSensitivity sensitivity) {
        this.sensitivity = sensitivity;
        return this;
    }

    public List<Double> lowThresholds() {
        return this.lowThresholds;
    }

    public SingleBaseline withLowThresholds(List<Double> lowThresholds) {
        this.lowThresholds = lowThresholds;
        return this;
    }

    public List<Double> highThresholds() {
        return this.highThresholds;
    }

    public SingleBaseline withHighThresholds(List<Double> highThresholds) {
        this.highThresholds = highThresholds;
        return this;
    }

    public void validate() {
        if (this.sensitivity() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property sensitivity in model SingleBaseline"));
        }
        if (this.lowThresholds() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property lowThresholds in model SingleBaseline"));
        }
        if (this.highThresholds() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property highThresholds in model SingleBaseline"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sensitivity", this.sensitivity == null ? null : this.sensitivity.toString());
        jsonWriter.writeArrayField("lowThresholds", this.lowThresholds, (writer, element) -> writer.writeDouble((double)element));
        jsonWriter.writeArrayField("highThresholds", this.highThresholds, (writer, element) -> writer.writeDouble((double)element));
        return jsonWriter.writeEndObject();
    }

    public static SingleBaseline fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SingleBaseline deserializedSingleBaseline = new SingleBaseline();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sensitivity".equals(fieldName)) {
                    deserializedSingleBaseline.sensitivity = BaselineSensitivity.fromString(reader.getString());
                    continue;
                }
                if ("lowThresholds".equals(fieldName)) {
                    List<Double> lowThresholds = reader.readArray(reader1 -> reader1.getDouble());
                    deserializedSingleBaseline.lowThresholds = lowThresholds;
                    continue;
                }
                if ("highThresholds".equals(fieldName)) {
                    List<Double> highThresholds = reader.readArray(reader1 -> reader1.getDouble());
                    deserializedSingleBaseline.highThresholds = highThresholds;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSingleBaseline;
        });
    }
}

