/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Resource;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.ExpressRouteConnectionInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.ExpressRouteGatewayProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ExpressRouteGatewayPropertiesAutoScaleConfiguration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.VirtualHubId;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ExpressRouteGatewayInner
extends Resource {
    private ExpressRouteGatewayProperties innerProperties;
    private String etag;
    private String id;
    private String type;
    private String name;

    private ExpressRouteGatewayProperties innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    @Override
    public String id() {
        return this.id;
    }

    public ExpressRouteGatewayInner withId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ExpressRouteGatewayInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public ExpressRouteGatewayInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public ExpressRouteGatewayPropertiesAutoScaleConfiguration autoScaleConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().autoScaleConfiguration();
    }

    public ExpressRouteGatewayInner withAutoScaleConfiguration(ExpressRouteGatewayPropertiesAutoScaleConfiguration autoScaleConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteGatewayProperties();
        }
        this.innerProperties().withAutoScaleConfiguration(autoScaleConfiguration);
        return this;
    }

    public List<ExpressRouteConnectionInner> expressRouteConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().expressRouteConnections();
    }

    public ExpressRouteGatewayInner withExpressRouteConnections(List<ExpressRouteConnectionInner> expressRouteConnections) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteGatewayProperties();
        }
        this.innerProperties().withExpressRouteConnections(expressRouteConnections);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public VirtualHubId virtualHub() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualHub();
    }

    public ExpressRouteGatewayInner withVirtualHub(VirtualHubId virtualHub) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteGatewayProperties();
        }
        this.innerProperties().withVirtualHub(virtualHub);
        return this;
    }

    public Boolean allowNonVirtualWanTraffic() {
        return this.innerProperties() == null ? null : this.innerProperties().allowNonVirtualWanTraffic();
    }

    public ExpressRouteGatewayInner withAllowNonVirtualWanTraffic(Boolean allowNonVirtualWanTraffic) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ExpressRouteGatewayProperties();
        }
        this.innerProperties().withAllowNonVirtualWanTraffic(allowNonVirtualWanTraffic);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static ExpressRouteGatewayInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressRouteGatewayInner deserializedExpressRouteGatewayInner = new ExpressRouteGatewayInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedExpressRouteGatewayInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedExpressRouteGatewayInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedExpressRouteGatewayInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedExpressRouteGatewayInner.withTags((Map)tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedExpressRouteGatewayInner.innerProperties = ExpressRouteGatewayProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedExpressRouteGatewayInner.etag = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedExpressRouteGatewayInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExpressRouteGatewayInner;
        });
    }
}

