/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.FlowLogInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.NetworkInterfaceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.SecurityRuleInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class NetworkSecurityGroupPropertiesFormat
implements JsonSerializable<NetworkSecurityGroupPropertiesFormat> {
    private Boolean flushConnection;
    private List<SecurityRuleInner> securityRules;
    private List<SecurityRuleInner> defaultSecurityRules;
    private List<NetworkInterfaceInner> networkInterfaces;
    private List<SubnetInner> subnets;
    private List<FlowLogInner> flowLogs;
    private String resourceGuid;
    private ProvisioningState provisioningState;

    public Boolean flushConnection() {
        return this.flushConnection;
    }

    public NetworkSecurityGroupPropertiesFormat withFlushConnection(Boolean flushConnection) {
        this.flushConnection = flushConnection;
        return this;
    }

    public List<SecurityRuleInner> securityRules() {
        return this.securityRules;
    }

    public NetworkSecurityGroupPropertiesFormat withSecurityRules(List<SecurityRuleInner> securityRules) {
        this.securityRules = securityRules;
        return this;
    }

    public List<SecurityRuleInner> defaultSecurityRules() {
        return this.defaultSecurityRules;
    }

    public List<NetworkInterfaceInner> networkInterfaces() {
        return this.networkInterfaces;
    }

    public List<SubnetInner> subnets() {
        return this.subnets;
    }

    public List<FlowLogInner> flowLogs() {
        return this.flowLogs;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.securityRules() != null) {
            this.securityRules().forEach(e -> e.validate());
        }
        if (this.defaultSecurityRules() != null) {
            this.defaultSecurityRules().forEach(e -> e.validate());
        }
        if (this.networkInterfaces() != null) {
            this.networkInterfaces().forEach(e -> e.validate());
        }
        if (this.subnets() != null) {
            this.subnets().forEach(e -> e.validate());
        }
        if (this.flowLogs() != null) {
            this.flowLogs().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("flushConnection", this.flushConnection);
        jsonWriter.writeArrayField("securityRules", this.securityRules, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static NetworkSecurityGroupPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkSecurityGroupPropertiesFormat deserializedNetworkSecurityGroupPropertiesFormat = new NetworkSecurityGroupPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("flushConnection".equals(fieldName)) {
                    deserializedNetworkSecurityGroupPropertiesFormat.flushConnection = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("securityRules".equals(fieldName)) {
                    List<SecurityRuleInner> securityRules = reader.readArray(reader1 -> SecurityRuleInner.fromJson(reader1));
                    deserializedNetworkSecurityGroupPropertiesFormat.securityRules = securityRules;
                    continue;
                }
                if ("defaultSecurityRules".equals(fieldName)) {
                    List<SecurityRuleInner> defaultSecurityRules = reader.readArray(reader1 -> SecurityRuleInner.fromJson(reader1));
                    deserializedNetworkSecurityGroupPropertiesFormat.defaultSecurityRules = defaultSecurityRules;
                    continue;
                }
                if ("networkInterfaces".equals(fieldName)) {
                    List<NetworkInterfaceInner> networkInterfaces = reader.readArray(reader1 -> NetworkInterfaceInner.fromJson(reader1));
                    deserializedNetworkSecurityGroupPropertiesFormat.networkInterfaces = networkInterfaces;
                    continue;
                }
                if ("subnets".equals(fieldName)) {
                    List<SubnetInner> subnets = reader.readArray(reader1 -> SubnetInner.fromJson(reader1));
                    deserializedNetworkSecurityGroupPropertiesFormat.subnets = subnets;
                    continue;
                }
                if ("flowLogs".equals(fieldName)) {
                    List<FlowLogInner> flowLogs = reader.readArray(reader1 -> FlowLogInner.fromJson(reader1));
                    deserializedNetworkSecurityGroupPropertiesFormat.flowLogs = flowLogs;
                    continue;
                }
                if ("resourceGuid".equals(fieldName)) {
                    deserializedNetworkSecurityGroupPropertiesFormat.resourceGuid = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedNetworkSecurityGroupPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkSecurityGroupPropertiesFormat;
        });
    }
}

