/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Resource;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.RouteInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.RouteTablePropertiesFormat;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class RouteTableInner
extends Resource {
    private RouteTablePropertiesFormat innerProperties;
    private String etag;
    private String id;
    private String type;
    private String name;

    private RouteTablePropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    @Override
    public String id() {
        return this.id;
    }

    public RouteTableInner withId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public RouteTableInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public RouteTableInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public List<RouteInner> routes() {
        return this.innerProperties() == null ? null : this.innerProperties().routes();
    }

    public RouteTableInner withRoutes(List<RouteInner> routes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RouteTablePropertiesFormat();
        }
        this.innerProperties().withRoutes(routes);
        return this;
    }

    public List<SubnetInner> subnets() {
        return this.innerProperties() == null ? null : this.innerProperties().subnets();
    }

    public Boolean disableBgpRoutePropagation() {
        return this.innerProperties() == null ? null : this.innerProperties().disableBgpRoutePropagation();
    }

    public RouteTableInner withDisableBgpRoutePropagation(Boolean disableBgpRoutePropagation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RouteTablePropertiesFormat();
        }
        this.innerProperties().withDisableBgpRoutePropagation(disableBgpRoutePropagation);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    public static RouteTableInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RouteTableInner deserializedRouteTableInner = new RouteTableInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedRouteTableInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRouteTableInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedRouteTableInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedRouteTableInner.withTags((Map)tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedRouteTableInner.innerProperties = RouteTablePropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedRouteTableInner.etag = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedRouteTableInner.id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRouteTableInner;
        });
    }
}

