/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.SubResource;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.ApplicationGatewayInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayForContainersReferenceDefinition;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ManagedRulesDefinition;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PolicySettings;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.WebApplicationFirewallCustomRule;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.WebApplicationFirewallPolicyResourceState;
import java.io.IOException;
import java.util.List;

public final class WebApplicationFirewallPolicyPropertiesFormat
implements JsonSerializable<WebApplicationFirewallPolicyPropertiesFormat> {
    private PolicySettings policySettings;
    private List<WebApplicationFirewallCustomRule> customRules;
    private List<ApplicationGatewayInner> applicationGateways;
    private ProvisioningState provisioningState;
    private WebApplicationFirewallPolicyResourceState resourceState;
    private ManagedRulesDefinition managedRules;
    private List<SubResource> httpListeners;
    private List<SubResource> pathBasedRules;
    private List<ApplicationGatewayForContainersReferenceDefinition> applicationGatewayForContainers;
    private static final ClientLogger LOGGER = new ClientLogger(WebApplicationFirewallPolicyPropertiesFormat.class);

    public PolicySettings policySettings() {
        return this.policySettings;
    }

    public WebApplicationFirewallPolicyPropertiesFormat withPolicySettings(PolicySettings policySettings) {
        this.policySettings = policySettings;
        return this;
    }

    public List<WebApplicationFirewallCustomRule> customRules() {
        return this.customRules;
    }

    public WebApplicationFirewallPolicyPropertiesFormat withCustomRules(List<WebApplicationFirewallCustomRule> customRules) {
        this.customRules = customRules;
        return this;
    }

    public List<ApplicationGatewayInner> applicationGateways() {
        return this.applicationGateways;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public WebApplicationFirewallPolicyResourceState resourceState() {
        return this.resourceState;
    }

    public ManagedRulesDefinition managedRules() {
        return this.managedRules;
    }

    public WebApplicationFirewallPolicyPropertiesFormat withManagedRules(ManagedRulesDefinition managedRules) {
        this.managedRules = managedRules;
        return this;
    }

    public List<SubResource> httpListeners() {
        return this.httpListeners;
    }

    public List<SubResource> pathBasedRules() {
        return this.pathBasedRules;
    }

    public List<ApplicationGatewayForContainersReferenceDefinition> applicationGatewayForContainers() {
        return this.applicationGatewayForContainers;
    }

    public void validate() {
        if (this.policySettings() != null) {
            this.policySettings().validate();
        }
        if (this.customRules() != null) {
            this.customRules().forEach(e -> e.validate());
        }
        if (this.applicationGateways() != null) {
            this.applicationGateways().forEach(e -> e.validate());
        }
        if (this.managedRules() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property managedRules in model WebApplicationFirewallPolicyPropertiesFormat"));
        }
        this.managedRules().validate();
        if (this.applicationGatewayForContainers() != null) {
            this.applicationGatewayForContainers().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("managedRules", this.managedRules);
        jsonWriter.writeJsonField("policySettings", this.policySettings);
        jsonWriter.writeArrayField("customRules", this.customRules, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static WebApplicationFirewallPolicyPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WebApplicationFirewallPolicyPropertiesFormat deserializedWebApplicationFirewallPolicyPropertiesFormat = new WebApplicationFirewallPolicyPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("managedRules".equals(fieldName)) {
                    deserializedWebApplicationFirewallPolicyPropertiesFormat.managedRules = ManagedRulesDefinition.fromJson(reader);
                    continue;
                }
                if ("policySettings".equals(fieldName)) {
                    deserializedWebApplicationFirewallPolicyPropertiesFormat.policySettings = PolicySettings.fromJson(reader);
                    continue;
                }
                if ("customRules".equals(fieldName)) {
                    List<WebApplicationFirewallCustomRule> customRules = reader.readArray(reader1 -> WebApplicationFirewallCustomRule.fromJson(reader1));
                    deserializedWebApplicationFirewallPolicyPropertiesFormat.customRules = customRules;
                    continue;
                }
                if ("applicationGateways".equals(fieldName)) {
                    List<ApplicationGatewayInner> applicationGateways = reader.readArray(reader1 -> ApplicationGatewayInner.fromJson(reader1));
                    deserializedWebApplicationFirewallPolicyPropertiesFormat.applicationGateways = applicationGateways;
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedWebApplicationFirewallPolicyPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("resourceState".equals(fieldName)) {
                    deserializedWebApplicationFirewallPolicyPropertiesFormat.resourceState = WebApplicationFirewallPolicyResourceState.fromString(reader.getString());
                    continue;
                }
                if ("httpListeners".equals(fieldName)) {
                    List<SubResource> httpListeners = reader.readArray(reader1 -> SubResource.fromJson(reader1));
                    deserializedWebApplicationFirewallPolicyPropertiesFormat.httpListeners = httpListeners;
                    continue;
                }
                if ("pathBasedRules".equals(fieldName)) {
                    List<SubResource> pathBasedRules = reader.readArray(reader1 -> SubResource.fromJson(reader1));
                    deserializedWebApplicationFirewallPolicyPropertiesFormat.pathBasedRules = pathBasedRules;
                    continue;
                }
                if ("applicationGatewayForContainers".equals(fieldName)) {
                    List<ApplicationGatewayForContainersReferenceDefinition> applicationGatewayForContainers = reader.readArray(reader1 -> ApplicationGatewayForContainersReferenceDefinition.fromJson(reader1));
                    deserializedWebApplicationFirewallPolicyPropertiesFormat.applicationGatewayForContainers = applicationGatewayForContainers;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebApplicationFirewallPolicyPropertiesFormat;
        });
    }
}

