/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.ApplicationGatewayProbeInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.ApplicationGatewayImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGateway;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayProbe;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayProbeHealthResponseMatch;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayProtocol;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

class ApplicationGatewayProbeImpl
extends ChildResourceImpl<ApplicationGatewayProbeInner, ApplicationGatewayImpl, ApplicationGateway>
implements ApplicationGatewayProbe,
ApplicationGatewayProbe.Definition<ApplicationGateway.DefinitionStages.WithCreate>,
ApplicationGatewayProbe.UpdateDefinition<ApplicationGateway.Update>,
ApplicationGatewayProbe.Update {
    private final ClientLogger logger = new ClientLogger(this.getClass());

    ApplicationGatewayProbeImpl(ApplicationGatewayProbeInner inner, ApplicationGatewayImpl parent) {
        super(inner, parent);
    }

    @Override
    public String name() {
        return ((ApplicationGatewayProbeInner)this.innerModel()).name();
    }

    @Override
    public String healthyHttpResponseBodyContents() {
        ApplicationGatewayProbeHealthResponseMatch match = ((ApplicationGatewayProbeInner)this.innerModel()).match();
        if (match == null) {
            return null;
        }
        return match.body();
    }

    @Override
    public ApplicationGatewayProtocol protocol() {
        return ((ApplicationGatewayProbeInner)this.innerModel()).protocol();
    }

    @Override
    public int timeBetweenProbesInSeconds() {
        return ((ApplicationGatewayProbeInner)this.innerModel()).interval() != null ? ((ApplicationGatewayProbeInner)this.innerModel()).interval() : 0;
    }

    @Override
    public String path() {
        return ((ApplicationGatewayProbeInner)this.innerModel()).path();
    }

    @Override
    public Set<String> healthyHttpResponseStatusCodeRanges() {
        TreeSet<String> httpResponseStatusCodeRanges = new TreeSet<String>();
        if (((ApplicationGatewayProbeInner)this.innerModel()).match() != null && ((ApplicationGatewayProbeInner)this.innerModel()).match().statusCodes() != null) {
            httpResponseStatusCodeRanges.addAll(((ApplicationGatewayProbeInner)this.innerModel()).match().statusCodes());
        }
        return Collections.unmodifiableSet(httpResponseStatusCodeRanges);
    }

    @Override
    public int timeoutInSeconds() {
        return ((ApplicationGatewayProbeInner)this.innerModel()).timeout() != null ? ((ApplicationGatewayProbeInner)this.innerModel()).timeout() : 0;
    }

    @Override
    public int retriesBeforeUnhealthy() {
        return ((ApplicationGatewayProbeInner)this.innerModel()).unhealthyThreshold() != null ? ((ApplicationGatewayProbeInner)this.innerModel()).unhealthyThreshold() : 0;
    }

    @Override
    public String host() {
        return ((ApplicationGatewayProbeInner)this.innerModel()).host();
    }

    @Override
    public Boolean isHostNameFromBackendHttpSettings() {
        return ((ApplicationGatewayProbeInner)this.innerModel()).pickHostnameFromBackendHttpSettings();
    }

    @Override
    public ApplicationGatewayProbeImpl withProtocol(ApplicationGatewayProtocol protocol) {
        ((ApplicationGatewayProbeInner)this.innerModel()).withProtocol(protocol);
        return this;
    }

    @Override
    public ApplicationGatewayProbeImpl withHttp() {
        return this.withProtocol(ApplicationGatewayProtocol.HTTP);
    }

    @Override
    public ApplicationGatewayProbeImpl withHttps() {
        return this.withProtocol(ApplicationGatewayProtocol.HTTPS);
    }

    @Override
    public ApplicationGatewayProbeImpl withPath(String path) {
        if (path != null && !path.startsWith("/")) {
            path = "/" + path;
        }
        ((ApplicationGatewayProbeInner)this.innerModel()).withPath(path);
        return this;
    }

    @Override
    public ApplicationGatewayProbeImpl withHost(String host) {
        ((ApplicationGatewayProbeInner)this.innerModel()).withHost(host);
        return this;
    }

    @Override
    public ApplicationGatewayProbeImpl withHostNameFromBackendHttpSettings() {
        ((ApplicationGatewayProbeInner)this.innerModel()).withPickHostnameFromBackendHttpSettings(true);
        return this;
    }

    @Override
    public ApplicationGatewayProbeImpl withoutHostNameFromBackendHttpSettings() {
        ((ApplicationGatewayProbeInner)this.innerModel()).withPickHostnameFromBackendHttpSettings(false);
        return this;
    }

    @Override
    public ApplicationGatewayProbeImpl withTimeoutInSeconds(int seconds) {
        ((ApplicationGatewayProbeInner)this.innerModel()).withTimeout(seconds);
        return this;
    }

    @Override
    public ApplicationGatewayProbeImpl withTimeBetweenProbesInSeconds(int seconds) {
        ((ApplicationGatewayProbeInner)this.innerModel()).withInterval(seconds);
        return this;
    }

    @Override
    public ApplicationGatewayProbeImpl withRetriesBeforeUnhealthy(int retryCount) {
        ((ApplicationGatewayProbeInner)this.innerModel()).withUnhealthyThreshold(retryCount);
        return this;
    }

    @Override
    public ApplicationGatewayProbeImpl withHealthyHttpResponseStatusCodeRanges(Set<String> ranges) {
        if (ranges != null) {
            for (String range : ranges) {
                this.withHealthyHttpResponseStatusCodeRange(range);
            }
        }
        return this;
    }

    @Override
    public ApplicationGatewayProbeImpl withHealthyHttpResponseStatusCodeRange(String range) {
        if (range != null) {
            List<String> ranges;
            ApplicationGatewayProbeHealthResponseMatch match = ((ApplicationGatewayProbeInner)this.innerModel()).match();
            if (match == null) {
                match = new ApplicationGatewayProbeHealthResponseMatch();
                ((ApplicationGatewayProbeInner)this.innerModel()).withMatch(match);
            }
            if ((ranges = match.statusCodes()) == null) {
                ranges = new ArrayList<String>();
                match.withStatusCodes(ranges);
            }
            if (!ranges.contains(range)) {
                ranges.add(range);
            }
        }
        return this;
    }

    @Override
    public ApplicationGatewayProbeImpl withHealthyHttpResponseStatusCodeRange(int from, int to) {
        if (from < 0 || to < 0) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("The start and end of a range cannot be negative numbers."));
        }
        if (to < from) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("The end of the range cannot be less than the start of the range."));
        }
        return this.withHealthyHttpResponseStatusCodeRange(String.valueOf(from) + "-" + String.valueOf(to));
    }

    @Override
    public ApplicationGatewayProbeImpl withoutHealthyHttpResponseStatusCodeRanges() {
        ApplicationGatewayProbeHealthResponseMatch match = ((ApplicationGatewayProbeInner)this.innerModel()).match();
        if (match != null) {
            match.withStatusCodes(null);
            if (match.body() == null) {
                ((ApplicationGatewayProbeInner)this.innerModel()).withMatch(null);
            }
        }
        return this;
    }

    @Override
    public ApplicationGatewayProbeImpl withHealthyHttpResponseBodyContents(String text) {
        ApplicationGatewayProbeHealthResponseMatch match = ((ApplicationGatewayProbeInner)this.innerModel()).match();
        if (text != null) {
            if (match == null) {
                match = new ApplicationGatewayProbeHealthResponseMatch();
                ((ApplicationGatewayProbeInner)this.innerModel()).withMatch(match);
            }
            match.withBody(text);
        } else if (match != null) {
            if (match.statusCodes() == null || match.statusCodes().isEmpty()) {
                ((ApplicationGatewayProbeInner)this.innerModel()).withMatch(null);
            } else {
                match.withBody(null);
            }
        }
        return this;
    }

    @Override
    public ApplicationGatewayImpl attach() {
        return ((ApplicationGatewayImpl)this.parent()).withProbe(this);
    }
}

