/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.management.provider.IdentifierProvider;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.NetworkManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.ApplicationSecurityGroupInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.NetworkInterfaceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.NetworkInterfaceIpConfigurationInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.NetworkSecurityGroupInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.GroupableParentResourceWithTagsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.implementation.NicIpConfigurationImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationSecurityGroup;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.DeleteOptions;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.IpAllocationMethod;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.LoadBalancer;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.Network;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NetworkInterface;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NetworkSecurityGroup;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NicIpConfiguration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PublicIpAddress;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.TagsObject;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Accepted;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Indexable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.implementation.AcceptedImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.ResourceGroup;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

class NetworkInterfaceImpl
extends GroupableParentResourceWithTagsImpl<NetworkInterface, NetworkInterfaceInner, NetworkInterfaceImpl, NetworkManager>
implements NetworkInterface,
NetworkInterface.Definition,
NetworkInterface.Update {
    private final ClientLogger logger = new ClientLogger(this.getClass());
    private final String nicName;
    protected final IdentifierProvider namer;
    private Map<String, NicIpConfiguration> nicIPConfigurations;
    private String creatableNetworkSecurityGroupKey;
    private NetworkSecurityGroup existingNetworkSecurityGroupToAssociate;
    private NetworkSecurityGroup networkSecurityGroup;
    private Map<String, DeleteOptions> specifiedIpConfigNames;

    NetworkInterfaceImpl(String name, NetworkInterfaceInner innerModel, NetworkManager networkManager) {
        super(name, innerModel, networkManager);
        this.nicName = name;
        this.namer = ((NetworkManager)this.manager()).resourceManager().internalContext().createIdentifierProvider(this.nicName);
        this.specifiedIpConfigNames = new HashMap<String, DeleteOptions>();
        this.initializeChildrenFromInner();
    }

    @Override
    public Mono<NetworkInterface> refreshAsync() {
        return super.refreshAsync().map(networkInterface -> {
            NetworkInterfaceImpl impl = (NetworkInterfaceImpl)networkInterface;
            impl.clearCachedRelatedResources();
            impl.initializeChildrenFromInner();
            return impl;
        });
    }

    @Override
    protected Mono<NetworkInterfaceInner> getInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getNetworkInterfaces().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    protected Mono<NetworkInterfaceInner> applyTagsToInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getNetworkInterfaces().updateTagsAsync(this.resourceGroupName(), this.name(), new TagsObject().withTags(((NetworkInterfaceInner)this.innerModel()).tags()));
    }

    @Override
    public NetworkInterfaceImpl withAcceleratedNetworking() {
        ((NetworkInterfaceInner)this.innerModel()).withEnableAcceleratedNetworking(true);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withoutAcceleratedNetworking() {
        ((NetworkInterfaceInner)this.innerModel()).withEnableAcceleratedNetworking(false);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withNewPrimaryNetwork(Creatable<Network> creatable) {
        this.primaryIPConfiguration().withNewNetwork((Creatable)creatable);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withNewPrimaryNetwork(String name, String addressSpaceCidr) {
        this.primaryIPConfiguration().withNewNetwork(name, addressSpaceCidr);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withNewPrimaryNetwork(String addressSpaceCidr) {
        this.primaryIPConfiguration().withNewNetwork(addressSpaceCidr);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withExistingPrimaryNetwork(Network network) {
        this.primaryIPConfiguration().withExistingNetwork(network);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withNewPrimaryPublicIPAddress(Creatable<PublicIpAddress> creatable) {
        this.primaryIPConfiguration().withNewPublicIpAddress((Creatable)creatable);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withNewPrimaryPublicIPAddress() {
        this.primaryIPConfiguration().withNewPublicIpAddress();
        return this;
    }

    @Override
    public NetworkInterfaceImpl withNewPrimaryPublicIPAddress(String leafDnsLabel) {
        this.primaryIPConfiguration().withNewPublicIpAddress(leafDnsLabel);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withExistingLoadBalancerBackend(LoadBalancer loadBalancer, String backendName) {
        this.primaryIPConfiguration().withExistingLoadBalancerBackend(loadBalancer, backendName);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withExistingLoadBalancerInboundNatRule(LoadBalancer loadBalancer, String inboundNatRuleName) {
        this.primaryIPConfiguration().withExistingLoadBalancerInboundNatRule(loadBalancer, inboundNatRuleName);
        return this;
    }

    @Override
    public NetworkInterface.Update withoutLoadBalancerBackends() {
        for (NicIpConfiguration ipConfig : this.ipConfigurations().values()) {
            this.updateIPConfiguration(ipConfig.name()).withoutLoadBalancerBackends();
        }
        return this;
    }

    @Override
    public NetworkInterface.Update withoutLoadBalancerInboundNatRules() {
        for (NicIpConfiguration ipConfig : this.ipConfigurations().values()) {
            this.updateIPConfiguration(ipConfig.name()).withoutLoadBalancerInboundNatRules();
        }
        return this;
    }

    @Override
    public NetworkInterfaceImpl withoutPrimaryPublicIPAddress() {
        this.primaryIPConfiguration().withoutPublicIpAddress();
        return this;
    }

    @Override
    public NetworkInterfaceImpl withExistingPrimaryPublicIPAddress(PublicIpAddress publicIPAddress) {
        this.primaryIPConfiguration().withExistingPublicIpAddress(publicIPAddress);
        this.primaryIPConfiguration().withPrivateIpVersion(publicIPAddress.version());
        return this;
    }

    @Override
    public NetworkInterfaceImpl withPrimaryPrivateIPAddressDynamic() {
        this.primaryIPConfiguration().withPrivateIpAddressDynamic();
        return this;
    }

    @Override
    public NetworkInterfaceImpl withPrimaryPrivateIPAddressStatic(String staticPrivateIPAddress) {
        this.primaryIPConfiguration().withPrivateIpAddressStatic(staticPrivateIPAddress);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withNewNetworkSecurityGroup(Creatable<NetworkSecurityGroup> creatable) {
        if (this.creatableNetworkSecurityGroupKey == null) {
            this.creatableNetworkSecurityGroupKey = this.addDependency(creatable);
        }
        return this;
    }

    @Override
    public NetworkInterfaceImpl withExistingNetworkSecurityGroup(NetworkSecurityGroup networkSecurityGroup) {
        this.existingNetworkSecurityGroupToAssociate = networkSecurityGroup;
        return this;
    }

    @Override
    public NetworkInterfaceImpl withoutNetworkSecurityGroup() {
        ((NetworkInterfaceInner)this.innerModel()).withNetworkSecurityGroup(null);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withExistingApplicationSecurityGroup(ApplicationSecurityGroup applicationSecurityGroup) {
        for (NicIpConfiguration ipConfiguration : this.nicIPConfigurations.values()) {
            ((NicIpConfigurationImpl)ipConfiguration).withExistingApplicationSecurityGroup(applicationSecurityGroup);
        }
        return this;
    }

    @Override
    public NetworkInterfaceImpl withoutApplicationSecurityGroup(String applicationSecurityGroupName) {
        for (NicIpConfiguration ipConfiguration : this.nicIPConfigurations.values()) {
            ((NicIpConfigurationImpl)ipConfiguration).withoutApplicationSecurityGroup(applicationSecurityGroupName);
        }
        return this;
    }

    public NicIpConfigurationImpl defineSecondaryIPConfiguration(String name) {
        NicIpConfigurationImpl nicIpConfiguration = this.prepareNewNicIPConfiguration(name);
        List<ApplicationSecurityGroupInner> inners = ((NetworkInterfaceIpConfigurationInner)this.primaryIPConfiguration().innerModel()).applicationSecurityGroups();
        if (inners != null) {
            for (ApplicationSecurityGroupInner inner : inners) {
                nicIpConfiguration.withExistingApplicationSecurityGroup(inner);
            }
        }
        return nicIpConfiguration;
    }

    @Override
    public NicIpConfigurationImpl updateIPConfiguration(String name) {
        return (NicIpConfigurationImpl)this.nicIPConfigurations.get(name);
    }

    @Override
    public NetworkInterfaceImpl withIPForwarding() {
        ((NetworkInterfaceInner)this.innerModel()).withEnableIpForwarding(true);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withoutIPConfiguration(String name) {
        this.nicIPConfigurations.remove(name);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withoutIPForwarding() {
        ((NetworkInterfaceInner)this.innerModel()).withEnableIpForwarding(false);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withDnsServer(String ipAddress) {
        this.dnsServerIPs().add(ipAddress);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withoutDnsServer(String ipAddress) {
        this.dnsServerIPs().remove(ipAddress);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withAzureDnsServer() {
        this.dnsServerIPs().clear();
        return this;
    }

    @Override
    public NetworkInterfaceImpl withSubnet(String name) {
        this.primaryIPConfiguration().withSubnet(name);
        return this;
    }

    @Override
    public NetworkInterfaceImpl withInternalDnsNameLabel(String dnsNameLabel) {
        ((NetworkInterfaceInner)this.innerModel()).dnsSettings().withInternalDnsNameLabel(dnsNameLabel);
        return this;
    }

    @Override
    public boolean isAcceleratedNetworkingEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean(((NetworkInterfaceInner)this.innerModel()).enableAcceleratedNetworking());
    }

    @Override
    public String virtualMachineId() {
        if (((NetworkInterfaceInner)this.innerModel()).virtualMachine() != null) {
            return ((NetworkInterfaceInner)this.innerModel()).virtualMachine().id();
        }
        return null;
    }

    @Override
    public boolean isIPForwardingEnabled() {
        return ResourceManagerUtils.toPrimitiveBoolean(((NetworkInterfaceInner)this.innerModel()).enableIpForwarding());
    }

    @Override
    public String macAddress() {
        return ((NetworkInterfaceInner)this.innerModel()).macAddress();
    }

    @Override
    public String internalDnsNameLabel() {
        return ((NetworkInterfaceInner)this.innerModel()).dnsSettings() != null ? ((NetworkInterfaceInner)this.innerModel()).dnsSettings().internalDnsNameLabel() : null;
    }

    @Override
    public String internalDomainNameSuffix() {
        return ((NetworkInterfaceInner)this.innerModel()).dnsSettings() != null ? ((NetworkInterfaceInner)this.innerModel()).dnsSettings().internalDomainNameSuffix() : null;
    }

    @Override
    public List<String> appliedDnsServers() {
        ArrayList dnsServers = new ArrayList();
        if (((NetworkInterfaceInner)this.innerModel()).dnsSettings() == null) {
            return Collections.unmodifiableList(dnsServers);
        }
        if (((NetworkInterfaceInner)this.innerModel()).dnsSettings().appliedDnsServers() == null) {
            return Collections.unmodifiableList(dnsServers);
        }
        return Collections.unmodifiableList(((NetworkInterfaceInner)this.innerModel()).dnsSettings().appliedDnsServers());
    }

    @Override
    public String internalFqdn() {
        return ((NetworkInterfaceInner)this.innerModel()).dnsSettings() != null ? ((NetworkInterfaceInner)this.innerModel()).dnsSettings().internalFqdn() : null;
    }

    @Override
    public List<String> dnsServers() {
        return this.dnsServerIPs();
    }

    @Override
    public String primaryPrivateIP() {
        return this.primaryIPConfiguration().privateIpAddress();
    }

    @Override
    public IpAllocationMethod primaryPrivateIpAllocationMethod() {
        return this.primaryIPConfiguration().privateIpAllocationMethod();
    }

    @Override
    public Map<String, NicIpConfiguration> ipConfigurations() {
        return Collections.unmodifiableMap(this.nicIPConfigurations);
    }

    @Override
    public String networkSecurityGroupId() {
        return ((NetworkInterfaceInner)this.innerModel()).networkSecurityGroup() != null ? ((NetworkInterfaceInner)this.innerModel()).networkSecurityGroup().id() : null;
    }

    @Override
    public NetworkSecurityGroup getNetworkSecurityGroup() {
        if (this.networkSecurityGroup == null && this.networkSecurityGroupId() != null) {
            String id = this.networkSecurityGroupId();
            this.networkSecurityGroup = (NetworkSecurityGroup)((NetworkManager)this.myManager).networkSecurityGroups().getByResourceGroup(ResourceUtils.groupFromResourceId(id), ResourceUtils.nameFromResourceId(id));
        }
        return this.networkSecurityGroup;
    }

    @Override
    public NicIpConfigurationImpl primaryIPConfiguration() {
        NicIpConfigurationImpl primaryIPConfig = null;
        if (this.nicIPConfigurations.size() == 0) {
            primaryIPConfig = this.prepareNewNicIPConfiguration("primary");
            ((NetworkInterfaceIpConfigurationInner)primaryIPConfig.innerModel()).withPrimary(true);
            this.withIPConfiguration(primaryIPConfig);
        } else if (this.nicIPConfigurations.size() == 1) {
            primaryIPConfig = (NicIpConfigurationImpl)this.nicIPConfigurations.values().iterator().next();
        } else {
            for (NicIpConfiguration ipConfig : this.nicIPConfigurations.values()) {
                if (!ipConfig.isPrimary()) continue;
                primaryIPConfig = (NicIpConfigurationImpl)ipConfig;
                break;
            }
        }
        return primaryIPConfig;
    }

    private List<String> dnsServerIPs() {
        ArrayList<String> dnsServers = new ArrayList<String>();
        if (((NetworkInterfaceInner)this.innerModel()).dnsSettings() == null) {
            return dnsServers;
        }
        if (((NetworkInterfaceInner)this.innerModel()).dnsSettings().dnsServers() == null) {
            return dnsServers;
        }
        return ((NetworkInterfaceInner)this.innerModel()).dnsSettings().dnsServers();
    }

    @Override
    protected void initializeChildrenFromInner() {
        this.nicIPConfigurations = new TreeMap<String, NicIpConfiguration>(Comparator.comparing(key -> key.toLowerCase(Locale.ROOT)));
        List<NetworkInterfaceIpConfigurationInner> inners = ((NetworkInterfaceInner)this.innerModel()).ipConfigurations();
        if (inners != null) {
            for (NetworkInterfaceIpConfigurationInner inner : inners) {
                NicIpConfigurationImpl nicIPConfiguration = new NicIpConfigurationImpl(inner, this, (NetworkManager)this.myManager, false);
                this.nicIPConfigurations.put(nicIPConfiguration.name(), nicIPConfiguration);
            }
        }
    }

    private NicIpConfigurationImpl prepareNewNicIPConfiguration(String name) {
        NicIpConfigurationImpl nicIPConfiguration = NicIpConfigurationImpl.prepareNicIPConfiguration(name, this, (NetworkManager)this.myManager);
        return nicIPConfiguration;
    }

    private void clearCachedRelatedResources() {
        this.networkSecurityGroup = null;
    }

    NetworkInterfaceImpl withIPConfiguration(NicIpConfigurationImpl nicIPConfiguration) {
        this.nicIPConfigurations.put(nicIPConfiguration.name(), nicIPConfiguration);
        return this;
    }

    void addToCreatableDependencies(Creatable<? extends Resource> creatableResource) {
        this.addDependency(creatableResource);
    }

    Resource createdDependencyResource(String key) {
        return (Resource)this.taskResult(key);
    }

    Creatable<ResourceGroup> newGroup() {
        return this.creatableGroup;
    }

    @Override
    public Accepted<NetworkInterface> beginCreate() {
        return AcceptedImpl.newAccepted(this.logger, ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getHttpPipeline(), ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getDefaultPollInterval(), () -> ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getNetworkInterfaces().createOrUpdateWithResponseAsync(this.resourceGroupName(), this.name(), (NetworkInterfaceInner)this.innerModel()).block(), inner -> new NetworkInterfaceImpl(inner.name(), (NetworkInterfaceInner)inner, (NetworkManager)this.manager()), NetworkInterfaceInner.class, () -> {
            Flux<Indexable> dependencyTasksAsync = this.taskGroup().invokeDependencyAsync(this.taskGroup().newInvocationContext());
            dependencyTasksAsync.blockLast();
            this.beforeCreating();
        }, inner -> {
            this.innerToFluentMap(this);
            this.initializeChildrenFromInner();
            this.afterCreating();
        }, Context.NONE);
    }

    @Override
    protected Mono<NetworkInterfaceInner> createInner() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getNetworkInterfaces().createOrUpdateAsync(this.resourceGroupName(), this.name(), (NetworkInterfaceInner)this.innerModel());
    }

    @Override
    protected void afterCreating() {
        this.clearCachedRelatedResources();
    }

    @Override
    protected void beforeCreating() {
        NetworkSecurityGroup networkSecurityGroup = null;
        if (this.creatableNetworkSecurityGroupKey != null) {
            networkSecurityGroup = (NetworkSecurityGroup)this.taskResult(this.creatableNetworkSecurityGroupKey);
        } else if (this.existingNetworkSecurityGroupToAssociate != null) {
            networkSecurityGroup = this.existingNetworkSecurityGroupToAssociate;
        }
        if (networkSecurityGroup != null) {
            ((NetworkInterfaceInner)this.innerModel()).withNetworkSecurityGroup(new NetworkSecurityGroupInner().withId(networkSecurityGroup.id()));
        }
        NicIpConfigurationImpl.ensureConfigurations(this.nicIPConfigurations.values(), this.specifiedIpConfigNames);
        ((NetworkInterfaceInner)this.innerModel()).withIpConfigurations(this.innersFromWrappers(this.nicIPConfigurations.values()));
    }

    @Override
    public NetworkInterfaceImpl withPrimaryPublicIPAddressDeleteOptions(DeleteOptions deleteOptions) {
        this.ensureDeleteOptions(deleteOptions, "primary");
        return this;
    }

    @Override
    public NetworkInterfaceImpl update() {
        this.specifiedIpConfigNames = new HashMap<String, DeleteOptions>();
        return (NetworkInterfaceImpl)super.update();
    }

    public void ensureDeleteOptions(DeleteOptions deleteOptions, String ipConfigName) {
        this.specifiedIpConfigNames.put(ipConfigName, deleteOptions);
    }
}

