/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.fluent.models.AdminPropertiesFormat;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.AddressPrefixItem;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ConfigurationGroup;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.EffectiveAdminRuleKind;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.EffectiveBaseSecurityAdminRule;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NetworkManagerSecurityGroupItem;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.SecurityConfigurationRuleAccess;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.SecurityConfigurationRuleDirection;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.SecurityConfigurationRuleProtocol;
import java.io.IOException;
import java.util.List;

public final class EffectiveSecurityAdminRule
extends EffectiveBaseSecurityAdminRule {
    private EffectiveAdminRuleKind kind = EffectiveAdminRuleKind.CUSTOM;
    private AdminPropertiesFormat innerProperties;

    @Override
    public EffectiveAdminRuleKind kind() {
        return this.kind;
    }

    private AdminPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    @Override
    public EffectiveSecurityAdminRule withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public EffectiveSecurityAdminRule withConfigurationDescription(String configurationDescription) {
        super.withConfigurationDescription(configurationDescription);
        return this;
    }

    @Override
    public EffectiveSecurityAdminRule withRuleCollectionDescription(String ruleCollectionDescription) {
        super.withRuleCollectionDescription(ruleCollectionDescription);
        return this;
    }

    @Override
    public EffectiveSecurityAdminRule withRuleCollectionAppliesToGroups(List<NetworkManagerSecurityGroupItem> ruleCollectionAppliesToGroups) {
        super.withRuleCollectionAppliesToGroups(ruleCollectionAppliesToGroups);
        return this;
    }

    @Override
    public EffectiveSecurityAdminRule withRuleGroups(List<ConfigurationGroup> ruleGroups) {
        super.withRuleGroups(ruleGroups);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public EffectiveSecurityAdminRule withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdminPropertiesFormat();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public SecurityConfigurationRuleProtocol protocol() {
        return this.innerProperties() == null ? null : this.innerProperties().protocol();
    }

    public EffectiveSecurityAdminRule withProtocol(SecurityConfigurationRuleProtocol protocol) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdminPropertiesFormat();
        }
        this.innerProperties().withProtocol(protocol);
        return this;
    }

    public List<AddressPrefixItem> sources() {
        return this.innerProperties() == null ? null : this.innerProperties().sources();
    }

    public EffectiveSecurityAdminRule withSources(List<AddressPrefixItem> sources) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdminPropertiesFormat();
        }
        this.innerProperties().withSources(sources);
        return this;
    }

    public List<AddressPrefixItem> destinations() {
        return this.innerProperties() == null ? null : this.innerProperties().destinations();
    }

    public EffectiveSecurityAdminRule withDestinations(List<AddressPrefixItem> destinations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdminPropertiesFormat();
        }
        this.innerProperties().withDestinations(destinations);
        return this;
    }

    public List<String> sourcePortRanges() {
        return this.innerProperties() == null ? null : this.innerProperties().sourcePortRanges();
    }

    public EffectiveSecurityAdminRule withSourcePortRanges(List<String> sourcePortRanges) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdminPropertiesFormat();
        }
        this.innerProperties().withSourcePortRanges(sourcePortRanges);
        return this;
    }

    public List<String> destinationPortRanges() {
        return this.innerProperties() == null ? null : this.innerProperties().destinationPortRanges();
    }

    public EffectiveSecurityAdminRule withDestinationPortRanges(List<String> destinationPortRanges) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdminPropertiesFormat();
        }
        this.innerProperties().withDestinationPortRanges(destinationPortRanges);
        return this;
    }

    public SecurityConfigurationRuleAccess access() {
        return this.innerProperties() == null ? null : this.innerProperties().access();
    }

    public EffectiveSecurityAdminRule withAccess(SecurityConfigurationRuleAccess access) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdminPropertiesFormat();
        }
        this.innerProperties().withAccess(access);
        return this;
    }

    public Integer priority() {
        return this.innerProperties() == null ? null : Integer.valueOf(this.innerProperties().priority());
    }

    public EffectiveSecurityAdminRule withPriority(Integer priority) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdminPropertiesFormat();
        }
        this.innerProperties().withPriority(priority);
        return this;
    }

    public SecurityConfigurationRuleDirection direction() {
        return this.innerProperties() == null ? null : this.innerProperties().direction();
    }

    public EffectiveSecurityAdminRule withDirection(SecurityConfigurationRuleDirection direction) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AdminPropertiesFormat();
        }
        this.innerProperties().withDirection(direction);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.ruleCollectionAppliesToGroups() != null) {
            this.ruleCollectionAppliesToGroups().forEach(e -> e.validate());
        }
        if (this.ruleGroups() != null) {
            this.ruleGroups().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("configurationDescription", this.configurationDescription());
        jsonWriter.writeStringField("ruleCollectionDescription", this.ruleCollectionDescription());
        jsonWriter.writeArrayField("ruleCollectionAppliesToGroups", this.ruleCollectionAppliesToGroups(), (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("ruleGroups", this.ruleGroups(), (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static EffectiveSecurityAdminRule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EffectiveSecurityAdminRule deserializedEffectiveSecurityAdminRule = new EffectiveSecurityAdminRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedEffectiveSecurityAdminRule.withId(reader.getString());
                    continue;
                }
                if ("configurationDescription".equals(fieldName)) {
                    deserializedEffectiveSecurityAdminRule.withConfigurationDescription(reader.getString());
                    continue;
                }
                if ("ruleCollectionDescription".equals(fieldName)) {
                    deserializedEffectiveSecurityAdminRule.withRuleCollectionDescription(reader.getString());
                    continue;
                }
                if ("ruleCollectionAppliesToGroups".equals(fieldName)) {
                    List<NetworkManagerSecurityGroupItem> ruleCollectionAppliesToGroups = reader.readArray(reader1 -> NetworkManagerSecurityGroupItem.fromJson(reader1));
                    deserializedEffectiveSecurityAdminRule.withRuleCollectionAppliesToGroups((List)ruleCollectionAppliesToGroups);
                    continue;
                }
                if ("ruleGroups".equals(fieldName)) {
                    List<ConfigurationGroup> ruleGroups = reader.readArray(reader1 -> ConfigurationGroup.fromJson(reader1));
                    deserializedEffectiveSecurityAdminRule.withRuleGroups((List)ruleGroups);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedEffectiveSecurityAdminRule.kind = EffectiveAdminRuleKind.fromString(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedEffectiveSecurityAdminRule.innerProperties = AdminPropertiesFormat.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEffectiveSecurityAdminRule;
        });
    }
}

