/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NetworkConfigurationDiagnosticProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.VerbosityLevel;
import java.io.IOException;
import java.util.List;

public final class NetworkConfigurationDiagnosticParameters
implements JsonSerializable<NetworkConfigurationDiagnosticParameters> {
    private String targetResourceId;
    private VerbosityLevel verbosityLevel;
    private List<NetworkConfigurationDiagnosticProfile> profiles;
    private static final ClientLogger LOGGER = new ClientLogger(NetworkConfigurationDiagnosticParameters.class);

    public String targetResourceId() {
        return this.targetResourceId;
    }

    public NetworkConfigurationDiagnosticParameters withTargetResourceId(String targetResourceId) {
        this.targetResourceId = targetResourceId;
        return this;
    }

    public VerbosityLevel verbosityLevel() {
        return this.verbosityLevel;
    }

    public NetworkConfigurationDiagnosticParameters withVerbosityLevel(VerbosityLevel verbosityLevel) {
        this.verbosityLevel = verbosityLevel;
        return this;
    }

    public List<NetworkConfigurationDiagnosticProfile> profiles() {
        return this.profiles;
    }

    public NetworkConfigurationDiagnosticParameters withProfiles(List<NetworkConfigurationDiagnosticProfile> profiles) {
        this.profiles = profiles;
        return this;
    }

    public void validate() {
        if (this.targetResourceId() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property targetResourceId in model NetworkConfigurationDiagnosticParameters"));
        }
        if (this.profiles() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property profiles in model NetworkConfigurationDiagnosticParameters"));
        }
        this.profiles().forEach(e -> e.validate());
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("targetResourceId", this.targetResourceId);
        jsonWriter.writeArrayField("profiles", this.profiles, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeStringField("verbosityLevel", this.verbosityLevel == null ? null : this.verbosityLevel.toString());
        return jsonWriter.writeEndObject();
    }

    public static NetworkConfigurationDiagnosticParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkConfigurationDiagnosticParameters deserializedNetworkConfigurationDiagnosticParameters = new NetworkConfigurationDiagnosticParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetResourceId".equals(fieldName)) {
                    deserializedNetworkConfigurationDiagnosticParameters.targetResourceId = reader.getString();
                    continue;
                }
                if ("profiles".equals(fieldName)) {
                    List<NetworkConfigurationDiagnosticProfile> profiles = reader.readArray(reader1 -> NetworkConfigurationDiagnosticProfile.fromJson(reader1));
                    deserializedNetworkConfigurationDiagnosticParameters.profiles = profiles;
                    continue;
                }
                if ("verbosityLevel".equals(fieldName)) {
                    deserializedNetworkConfigurationDiagnosticParameters.verbosityLevel = VerbosityLevel.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkConfigurationDiagnosticParameters;
        });
    }
}

