/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PublicIpAddressSku;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PublicIpAddressSkuName;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class PublicIPSkuType {
    private static final Map<String, PublicIPSkuType> VALUES_BY_NAME = new HashMap<String, PublicIPSkuType>();
    public static final PublicIPSkuType BASIC = new PublicIPSkuType(PublicIpAddressSkuName.BASIC);
    public static final PublicIPSkuType STANDARD = new PublicIPSkuType(PublicIpAddressSkuName.STANDARD);
    private final PublicIpAddressSkuName skuName;

    public static PublicIPSkuType[] values() {
        Collection<PublicIPSkuType> valuesCollection = VALUES_BY_NAME.values();
        return valuesCollection.toArray(new PublicIPSkuType[valuesCollection.size()]);
    }

    private PublicIPSkuType(PublicIpAddressSkuName skuName) {
        this.skuName = skuName;
        if (skuName != null) {
            VALUES_BY_NAME.put(skuName.toString().toLowerCase(Locale.ROOT), this);
        }
    }

    public static PublicIPSkuType fromSku(PublicIpAddressSku pipSku) {
        if (pipSku == null) {
            return null;
        }
        if (pipSku.name() == null) {
            return null;
        }
        PublicIPSkuType result = VALUES_BY_NAME.get(pipSku.name().toString().toLowerCase(Locale.ROOT));
        if (result != null) {
            return result;
        }
        return new PublicIPSkuType(pipSku.name());
    }

    public PublicIpAddressSku sku() {
        return new PublicIpAddressSku().withName(this.skuName);
    }

    public int hashCode() {
        return this.skuName.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PublicIPSkuType)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.skuName == null) {
            return ((PublicIPSkuType)obj).skuName == null;
        }
        return this.skuName.equals(((PublicIPSkuType)obj).skuName);
    }
}

