/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.ReplicationRole;
import java.io.IOException;

public class RedisLinkedServerCreateProperties
implements JsonSerializable<RedisLinkedServerCreateProperties> {
    private String linkedRedisCacheId;
    private String linkedRedisCacheLocation;
    private ReplicationRole serverRole;
    private String geoReplicatedPrimaryHostname;
    private String primaryHostname;
    private static final ClientLogger LOGGER = new ClientLogger(RedisLinkedServerCreateProperties.class);

    public String linkedRedisCacheId() {
        return this.linkedRedisCacheId;
    }

    public RedisLinkedServerCreateProperties withLinkedRedisCacheId(String linkedRedisCacheId) {
        this.linkedRedisCacheId = linkedRedisCacheId;
        return this;
    }

    public String linkedRedisCacheLocation() {
        return this.linkedRedisCacheLocation;
    }

    public RedisLinkedServerCreateProperties withLinkedRedisCacheLocation(String linkedRedisCacheLocation) {
        this.linkedRedisCacheLocation = linkedRedisCacheLocation;
        return this;
    }

    public ReplicationRole serverRole() {
        return this.serverRole;
    }

    public RedisLinkedServerCreateProperties withServerRole(ReplicationRole serverRole) {
        this.serverRole = serverRole;
        return this;
    }

    public String geoReplicatedPrimaryHostname() {
        return this.geoReplicatedPrimaryHostname;
    }

    RedisLinkedServerCreateProperties withGeoReplicatedPrimaryHostname(String geoReplicatedPrimaryHostname) {
        this.geoReplicatedPrimaryHostname = geoReplicatedPrimaryHostname;
        return this;
    }

    public String primaryHostname() {
        return this.primaryHostname;
    }

    RedisLinkedServerCreateProperties withPrimaryHostname(String primaryHostname) {
        this.primaryHostname = primaryHostname;
        return this;
    }

    public void validate() {
        if (this.linkedRedisCacheId() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property linkedRedisCacheId in model RedisLinkedServerCreateProperties"));
        }
        if (this.linkedRedisCacheLocation() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property linkedRedisCacheLocation in model RedisLinkedServerCreateProperties"));
        }
        if (this.serverRole() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property serverRole in model RedisLinkedServerCreateProperties"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("linkedRedisCacheId", this.linkedRedisCacheId);
        jsonWriter.writeStringField("linkedRedisCacheLocation", this.linkedRedisCacheLocation);
        jsonWriter.writeStringField("serverRole", this.serverRole == null ? null : this.serverRole.toString());
        return jsonWriter.writeEndObject();
    }

    public static RedisLinkedServerCreateProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RedisLinkedServerCreateProperties deserializedRedisLinkedServerCreateProperties = new RedisLinkedServerCreateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedRedisCacheId".equals(fieldName)) {
                    deserializedRedisLinkedServerCreateProperties.linkedRedisCacheId = reader.getString();
                    continue;
                }
                if ("linkedRedisCacheLocation".equals(fieldName)) {
                    deserializedRedisLinkedServerCreateProperties.linkedRedisCacheLocation = reader.getString();
                    continue;
                }
                if ("serverRole".equals(fieldName)) {
                    deserializedRedisLinkedServerCreateProperties.serverRole = ReplicationRole.fromString(reader.getString());
                    continue;
                }
                if ("geoReplicatedPrimaryHostName".equals(fieldName)) {
                    deserializedRedisLinkedServerCreateProperties.geoReplicatedPrimaryHostname = reader.getString();
                    continue;
                }
                if ("primaryHostName".equals(fieldName)) {
                    deserializedRedisLinkedServerCreateProperties.primaryHostname = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRedisLinkedServerCreateProperties;
        });
    }
}

