/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.fluent.PrivateLinkResourcesClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.fluent.models.PrivateLinkResourceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.implementation.RedisManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.redis.models.PrivateLinkResourceListResult;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public final class PrivateLinkResourcesClientImpl
implements PrivateLinkResourcesClient {
    private final PrivateLinkResourcesService service;
    private final RedisManagementClientImpl client;

    PrivateLinkResourcesClientImpl(RedisManagementClientImpl client) {
        this.service = RestProxy.create(PrivateLinkResourcesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PrivateLinkResourceInner>> listByRedisCacheSinglePageAsync(String resourceGroupName, String cacheName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error(new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByRedisCache(this.client.getEndpoint(), resourceGroupName, cacheName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, PrivateLinkResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PrivateLinkResourceListResult)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PrivateLinkResourceInner>> listByRedisCacheSinglePageAsync(String resourceGroupName, String cacheName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cacheName == null) {
            return Mono.error(new IllegalArgumentException("Parameter cacheName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByRedisCache(this.client.getEndpoint(), resourceGroupName, cacheName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase<Object, PrivateLinkResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PrivateLinkResourceListResult)res.getValue()).value(), null, null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PrivateLinkResourceInner> listByRedisCacheAsync(String resourceGroupName, String cacheName) {
        return new PagedFlux<PrivateLinkResourceInner>(() -> this.listByRedisCacheSinglePageAsync(resourceGroupName, cacheName));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PrivateLinkResourceInner> listByRedisCacheAsync(String resourceGroupName, String cacheName, Context context) {
        return new PagedFlux<PrivateLinkResourceInner>(() -> this.listByRedisCacheSinglePageAsync(resourceGroupName, cacheName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PrivateLinkResourceInner> listByRedisCache(String resourceGroupName, String cacheName) {
        return new PagedIterable<PrivateLinkResourceInner>(this.listByRedisCacheAsync(resourceGroupName, cacheName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PrivateLinkResourceInner> listByRedisCache(String resourceGroupName, String cacheName, Context context) {
        return new PagedIterable<PrivateLinkResourceInner>(this.listByRedisCacheAsync(resourceGroupName, cacheName, context));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="RedisManagementClien")
    public static interface PrivateLinkResourcesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/redis/{cacheName}/privateLinkResources")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<PrivateLinkResourceListResult>> listByRedisCache(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="cacheName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

