/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.ResourceManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluent.ResourceManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluent.ResourcesClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluent.models.GenericResourceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.Accepted;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.implementation.AcceptedImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.implementation.GenericResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.GenericResource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.GenericResources;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.ResourceGroup;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.models.ResourcesMoveInfo;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.List;
import java.util.function.Function;

public final class GenericResourcesImpl
extends GroupableResourcesImpl<GenericResource, GenericResourceImpl, GenericResourceInner, ResourcesClient, ResourceManager>
implements GenericResources {
    private final ClientLogger logger = new ClientLogger(this.getClass());

    public GenericResourcesImpl(ResourceManager resourceManager) {
        super(((ResourceManagementClient)resourceManager.serviceClient()).getResources(), resourceManager);
    }

    @Override
    public PagedIterable<GenericResource> list() {
        return new PagedIterable<GenericResource>(this.listAsync());
    }

    @Override
    public PagedIterable<GenericResource> listByResourceGroup(String groupName) {
        return new PagedIterable<GenericResource>(this.listByResourceGroupAsync(groupName));
    }

    @Override
    public PagedIterable<GenericResource> listByTag(String resourceGroupName, String tagName, String tagValue) {
        return new PagedIterable<GenericResource>(this.listByTagAsync(resourceGroupName, tagName, tagValue));
    }

    @Override
    public PagedFlux<GenericResource> listByTagAsync(String resourceGroupName, String tagName, String tagValue) {
        return this.wrapPageAsync(PagedConverter.mapPage(((ResourceManagementClient)((ResourceManager)this.manager()).serviceClient()).getResources().listByResourceGroupAsync(resourceGroupName, ResourceManagerUtils.createOdataFilterForTags(tagName, tagValue), null, null), res -> res));
    }

    @Override
    public GenericResource.DefinitionStages.Blank define(String name) {
        return new GenericResourceImpl(name, new GenericResourceInner(), (ResourceManager)this.manager());
    }

    @Override
    public boolean checkExistence(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion) {
        return ((ResourcesClient)this.inner()).checkExistence(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion);
    }

    @Override
    public boolean checkExistenceById(String id) {
        if (CoreUtils.isNullOrEmpty(id)) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("Parameter 'id' is required and cannot be null."));
        }
        String apiVersion = this.getApiVersionFromIdAsync(id).block();
        return this.checkExistenceById(id, apiVersion);
    }

    @Override
    public boolean checkExistenceById(String id, String apiVersion) {
        if (CoreUtils.isNullOrEmpty(id)) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("Parameter 'id' is required and cannot be null."));
        }
        if (CoreUtils.isNullOrEmpty(apiVersion)) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("Parameter 'apiVersion' is required and cannot be null."));
        }
        return ((ResourcesClient)this.inner()).checkExistenceById(ResourceUtils.encodeResourceId(id), apiVersion);
    }

    @Override
    public Mono<GenericResource> getByIdAsync(String id) {
        if (CoreUtils.isNullOrEmpty(id)) {
            return Mono.error(new IllegalArgumentException("Parameter 'id' is required and cannot be null."));
        }
        return this.getApiVersionFromIdAsync(id).flatMap(apiVersion -> this.getByIdAsync(ResourceUtils.encodeResourceId(id), (String)apiVersion));
    }

    @Override
    public GenericResource getById(String id, String apiVersion) {
        return this.getByIdAsync(id, apiVersion).block();
    }

    @Override
    public Mono<GenericResource> getByIdAsync(String id, String apiVersion) {
        if (CoreUtils.isNullOrEmpty(id)) {
            return Mono.error(new IllegalArgumentException("Parameter 'id' is required and cannot be null."));
        }
        if (CoreUtils.isNullOrEmpty(apiVersion)) {
            return Mono.error(new IllegalArgumentException("Parameter 'apiVersion' is required and cannot be null."));
        }
        return ((ResourcesClient)this.inner()).getByIdAsync(ResourceUtils.encodeResourceId(id), apiVersion).map(this::wrapModel).map(r -> r.withApiVersion(apiVersion));
    }

    @Override
    public Mono<Void> deleteByIdAsync(String id) {
        if (CoreUtils.isNullOrEmpty(id)) {
            return Mono.error(new IllegalArgumentException("Parameter 'id' is required and cannot be null."));
        }
        return this.getApiVersionFromIdAsync(id).flatMap(apiVersion -> this.deleteByIdAsync(ResourceUtils.encodeResourceId(id), (String)apiVersion));
    }

    @Override
    public void deleteById(String id, String apiVersion) {
        this.deleteByIdAsync(id, apiVersion).block();
    }

    @Override
    public Mono<Void> deleteByIdAsync(String id, String apiVersion) {
        if (CoreUtils.isNullOrEmpty(id)) {
            return Mono.error(new IllegalArgumentException("Parameter 'id' is required and cannot be null."));
        }
        if (CoreUtils.isNullOrEmpty(apiVersion)) {
            return Mono.error(new IllegalArgumentException("Parameter 'apiVersion' is required and cannot be null."));
        }
        return ((ResourcesClient)this.inner()).deleteByIdAsync(ResourceUtils.encodeResourceId(id), apiVersion);
    }

    @Override
    public GenericResource get(String resourceGroupName, String providerNamespace, String resourceType, String name) {
        PagedIterable<GenericResource> genericResources = this.listByResourceGroup(resourceGroupName);
        for (GenericResource resource : genericResources) {
            if (!resource.name().equalsIgnoreCase(name) || !resource.resourceProviderNamespace().equalsIgnoreCase(providerNamespace) || !resource.resourceType().equalsIgnoreCase(resourceType)) continue;
            return resource;
        }
        return null;
    }

    @Override
    public void validateMoveResources(String sourceResourceGroupName, ResourceGroup targetResourceGroup, List<String> resourceIds) {
        this.validateMoveResourcesAsync(sourceResourceGroupName, targetResourceGroup, resourceIds).block();
    }

    @Override
    public Mono<Void> validateMoveResourcesAsync(String sourceResourceGroupName, ResourceGroup targetResourceGroup, List<String> resourceIds) {
        ResourcesMoveInfo moveInfo = new ResourcesMoveInfo();
        moveInfo.withTargetResourceGroup(targetResourceGroup.id());
        moveInfo.withResources(resourceIds);
        return ((ResourcesClient)this.inner()).validateMoveResourcesAsync(sourceResourceGroupName, moveInfo);
    }

    @Override
    public GenericResource get(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion) {
        if (parentResourcePath == null) {
            parentResourcePath = "";
        }
        GenericResourceInner inner = ((ResourcesClient)this.inner()).get(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion);
        GenericResourceImpl resource = new GenericResourceImpl(resourceName, inner, (ResourceManager)this.manager());
        return ((GenericResourceImpl)resource.withExistingResourceGroup(resourceGroupName)).withProviderNamespace(resourceProviderNamespace).withParentResourcePath(parentResourcePath).withResourceType(resourceType).withApiVersion(apiVersion);
    }

    @Override
    public void moveResources(String sourceResourceGroupName, ResourceGroup targetResourceGroup, List<String> resourceIds) {
        this.moveResourcesAsync(sourceResourceGroupName, targetResourceGroup, resourceIds).block();
    }

    @Override
    public Mono<Void> moveResourcesAsync(String sourceResourceGroupName, ResourceGroup targetResourceGroup, List<String> resourceIds) {
        ResourcesMoveInfo moveInfo = new ResourcesMoveInfo();
        moveInfo.withTargetResourceGroup(targetResourceGroup.id());
        moveInfo.withResources(resourceIds);
        return ((ResourcesClient)this.inner()).moveResourcesAsync(sourceResourceGroupName, moveInfo);
    }

    @Override
    public void delete(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion) {
        this.deleteAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion).block();
    }

    @Override
    public Mono<Void> deleteAsync(String resourceGroupName, String resourceProviderNamespace, String parentResourcePath, String resourceType, String resourceName, String apiVersion) {
        return ((ResourcesClient)this.inner()).deleteAsync(resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, apiVersion);
    }

    @Override
    protected GenericResourceImpl wrapModel(String id) {
        return ((GenericResourceImpl)new GenericResourceImpl(id, new GenericResourceInner(), (ResourceManager)this.manager()).withExistingResourceGroup(ResourceUtils.groupFromResourceId(id))).withProviderNamespace(ResourceUtils.resourceProviderFromResourceId(id)).withResourceType(ResourceUtils.resourceTypeFromResourceId(id)).withParentResourceId(ResourceUtils.parentResourceIdFromResourceId(id));
    }

    @Override
    protected GenericResourceImpl wrapModel(GenericResourceInner inner) {
        if (inner == null) {
            return null;
        }
        return ((GenericResourceImpl)new GenericResourceImpl(inner.id(), inner, (ResourceManager)this.manager()).withExistingResourceGroup(ResourceUtils.groupFromResourceId(inner.id()))).withProviderNamespace(ResourceUtils.resourceProviderFromResourceId(inner.id())).withResourceType(ResourceUtils.resourceTypeFromResourceId(inner.id())).withParentResourceId(ResourceUtils.parentResourceIdFromResourceId(inner.id()));
    }

    @Override
    public Mono<GenericResourceInner> getInnerAsync(String groupName, String name) {
        throw this.logger.logExceptionAsError(new UnsupportedOperationException("Get just by resource group and name is not supported. Please use other overloads."));
    }

    @Override
    protected Mono<Void> deleteInnerAsync(String resourceGroupName, String name) {
        throw this.logger.logExceptionAsError(new UnsupportedOperationException("Delete just by resource group and name is not supported. Please use other overloads."));
    }

    @Override
    public Accepted<Void> beginDeleteById(String id) {
        if (CoreUtils.isNullOrEmpty(id)) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("Parameter 'id' is required and cannot be null."));
        }
        String apiVersion = this.getApiVersionFromIdAsync(id).block();
        return this.beginDeleteById(id, apiVersion);
    }

    @Override
    public Accepted<Void> beginDeleteById(String id, String apiVersion) {
        if (CoreUtils.isNullOrEmpty(id)) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("Parameter 'id' is required and cannot be null."));
        }
        if (CoreUtils.isNullOrEmpty(apiVersion)) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("Parameter 'apiVersion' is required and cannot be null."));
        }
        return AcceptedImpl.newAccepted(this.logger, ((ResourceManagementClient)((ResourceManager)this.manager()).serviceClient()).getHttpPipeline(), ((ResourceManagementClient)((ResourceManager)this.manager()).serviceClient()).getDefaultPollInterval(), () -> ((ResourcesClient)this.inner()).deleteByIdWithResponseAsync(id, apiVersion).block(), Function.identity(), Void.class, null, Context.NONE);
    }

    private Mono<String> getApiVersionFromIdAsync(String id) {
        return ((ResourceManager)this.manager()).providers().getByNameAsync(ResourceUtils.resourceProviderFromResourceId(id)).map(provider -> ResourceUtils.defaultApiVersion(id, provider));
    }

    @Override
    public PagedFlux<GenericResource> listAsync() {
        return this.wrapPageAsync(PagedConverter.mapPage(((ResourcesClient)this.inner()).listAsync(), res -> res));
    }

    @Override
    public PagedFlux<GenericResource> listByResourceGroupAsync(String resourceGroupName) {
        if (CoreUtils.isNullOrEmpty(resourceGroupName)) {
            return new PagedFlux<GenericResource>(() -> Mono.error(new IllegalArgumentException("Parameter 'resourceGroupName' is required and cannot be null.")));
        }
        return this.wrapPageAsync(PagedConverter.mapPage(((ResourceManagementClient)((ResourceManager)this.manager()).serviceClient()).getResources().listByResourceGroupAsync(resourceGroupName), res -> res));
    }
}

