/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.SqlServerManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models.ServerSecurityAlertPolicyInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlServerImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SecurityAlertPolicyNameAutoGenerated;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SecurityAlertPolicyState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlServer;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlServerSecurityAlertPolicy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlServerSecurityAlertPolicyOperations;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class SqlServerSecurityAlertPolicyImpl
extends ExternalChildResourceImpl<SqlServerSecurityAlertPolicy, ServerSecurityAlertPolicyInner, SqlServerImpl, SqlServer>
implements SqlServerSecurityAlertPolicy,
SqlServerSecurityAlertPolicy.Update,
SqlServerSecurityAlertPolicyOperations.SqlServerSecurityAlertPolicyOperationsDefinition {
    private SqlServerManager sqlServerManager;
    private String resourceGroupName;
    private String sqlServerName;

    SqlServerSecurityAlertPolicyImpl(SqlServerImpl parent, ServerSecurityAlertPolicyInner innerObject, SqlServerManager sqlServerManager) {
        super("Default", parent, innerObject);
        Objects.requireNonNull(parent);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = parent.resourceGroupName();
        this.sqlServerName = parent.name();
    }

    SqlServerSecurityAlertPolicyImpl(String resourceGroupName, String sqlServerName, ServerSecurityAlertPolicyInner innerObject, SqlServerManager sqlServerManager) {
        super("Default", null, innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
    }

    SqlServerSecurityAlertPolicyImpl(ServerSecurityAlertPolicyInner innerObject, SqlServerManager sqlServerManager) {
        super("Default", null, innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        if (innerObject != null && innerObject.id() != null) {
            try {
                ResourceId resourceId = ResourceId.fromString(innerObject.id());
                this.resourceGroupName = resourceId.resourceGroupName();
                this.sqlServerName = resourceId.parent().name();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Override
    public String id() {
        return ((ServerSecurityAlertPolicyInner)this.innerModel()).id();
    }

    @Override
    public String name() {
        return "Default";
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public String sqlServerName() {
        return this.sqlServerName;
    }

    @Override
    public String parentId() {
        return ResourceUtils.parentResourceIdFromResourceId(((ServerSecurityAlertPolicyInner)this.innerModel()).id());
    }

    @Override
    public SecurityAlertPolicyState state() {
        return ((ServerSecurityAlertPolicyInner)this.innerModel()).state() == null ? null : SecurityAlertPolicyState.fromString(((ServerSecurityAlertPolicyInner)this.innerModel()).state().toString());
    }

    @Override
    public List<String> disabledAlerts() {
        return Collections.unmodifiableList(((ServerSecurityAlertPolicyInner)this.innerModel()).disabledAlerts());
    }

    @Override
    public List<String> emailAddresses() {
        return Collections.unmodifiableList(((ServerSecurityAlertPolicyInner)this.innerModel()).emailAddresses());
    }

    @Override
    public boolean emailAccountAdmins() {
        return ((ServerSecurityAlertPolicyInner)this.innerModel()).emailAccountAdmins();
    }

    @Override
    public String storageEndpoint() {
        return ((ServerSecurityAlertPolicyInner)this.innerModel()).storageEndpoint();
    }

    @Override
    public String storageAccountAccessKey() {
        return ((ServerSecurityAlertPolicyInner)this.innerModel()).storageAccountAccessKey();
    }

    @Override
    public int retentionDays() {
        return ((ServerSecurityAlertPolicyInner)this.innerModel()).retentionDays();
    }

    @Override
    public SqlServerSecurityAlertPolicyImpl withExistingSqlServer(String resourceGroupName, String sqlServerName) {
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        return this;
    }

    @Override
    public SqlServerSecurityAlertPolicyImpl withExistingSqlServerId(String sqlServerId) {
        Objects.requireNonNull(sqlServerId);
        ResourceId resourceId = ResourceId.fromString(sqlServerId);
        this.resourceGroupName = resourceId.resourceGroupName();
        this.sqlServerName = resourceId.name();
        return this;
    }

    @Override
    public SqlServerSecurityAlertPolicyImpl withExistingSqlServer(SqlServer sqlServer) {
        Objects.requireNonNull(sqlServer);
        this.resourceGroupName = sqlServer.resourceGroupName();
        this.sqlServerName = sqlServer.name();
        return this;
    }

    @Override
    public SqlServerSecurityAlertPolicyImpl update() {
        super.prepareUpdate();
        ((ServerSecurityAlertPolicyInner)this.innerModel()).withStorageEndpoint(null);
        return this;
    }

    @Override
    public Mono<SqlServerSecurityAlertPolicy> createResourceAsync() {
        SqlServerSecurityAlertPolicyImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getServerSecurityAlertPolicies().createOrUpdateAsync(self.resourceGroupName, self.sqlServerName, SecurityAlertPolicyNameAutoGenerated.DEFAULT, (ServerSecurityAlertPolicyInner)self.innerModel()).map(serverSecurityAlertPolicyInner -> {
            self.setInner(serverSecurityAlertPolicyInner);
            return self;
        });
    }

    @Override
    public Mono<SqlServerSecurityAlertPolicy> updateResourceAsync() {
        ((ServerSecurityAlertPolicyInner)this.innerModel()).withStorageEndpoint(null);
        return this.createResourceAsync();
    }

    @Override
    public Mono<Void> deleteResourceAsync() {
        return null;
    }

    @Override
    protected Mono<ServerSecurityAlertPolicyInner> getInnerAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getServerSecurityAlertPolicies().getAsync(this.resourceGroupName, this.sqlServerName, SecurityAlertPolicyNameAutoGenerated.DEFAULT);
    }

    @Override
    public SqlServerSecurityAlertPolicyImpl withState(SecurityAlertPolicyState state) {
        ((ServerSecurityAlertPolicyInner)this.innerModel()).withState(state);
        return this;
    }

    @Override
    public SqlServerSecurityAlertPolicyImpl withEmailAccountAdmins() {
        ((ServerSecurityAlertPolicyInner)this.innerModel()).withEmailAccountAdmins(true);
        return this;
    }

    @Override
    public SqlServerSecurityAlertPolicyImpl withoutEmailAccountAdmins() {
        ((ServerSecurityAlertPolicyInner)this.innerModel()).withEmailAccountAdmins(false);
        return this;
    }

    @Override
    public SqlServerSecurityAlertPolicyImpl withStorageEndpoint(String storageEndpointUri, String storageAccessKey) {
        ((ServerSecurityAlertPolicyInner)this.innerModel()).withStorageEndpoint(storageEndpointUri);
        ((ServerSecurityAlertPolicyInner)this.innerModel()).withStorageAccountAccessKey(storageAccessKey);
        return this;
    }

    @Override
    public SqlServerSecurityAlertPolicyImpl withEmailAddresses(String ... emailAddresses) {
        ((ServerSecurityAlertPolicyInner)this.innerModel()).withEmailAddresses(Arrays.asList(emailAddresses));
        return this;
    }

    @Override
    public SqlServerSecurityAlertPolicyImpl withDisabledAlerts(String ... disabledAlerts) {
        ((ServerSecurityAlertPolicyInner)this.innerModel()).withDisabledAlerts(Arrays.asList(disabledAlerts));
        return this;
    }

    @Override
    public SqlServerSecurityAlertPolicyImpl withRetentionDays(int days) {
        ((ServerSecurityAlertPolicyInner)this.innerModel()).withRetentionDays(days);
        return this;
    }
}

