/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.implementation.RefreshableWrapperImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.SqlServerManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models.LogicalDatabaseTransparentDataEncryptionInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.TransparentDataEncryption;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.TransparentDataEncryptionName;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.TransparentDataEncryptionState;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

class TransparentDataEncryptionImpl
extends RefreshableWrapperImpl<LogicalDatabaseTransparentDataEncryptionInner, TransparentDataEncryption>
implements TransparentDataEncryption {
    private final String sqlServerName;
    private final String resourceGroupName;
    private final SqlServerManager sqlServerManager;
    private final ResourceId resourceId;

    protected TransparentDataEncryptionImpl(String resourceGroupName, String sqlServerName, LogicalDatabaseTransparentDataEncryptionInner innerObject, SqlServerManager sqlServerManager) {
        super(innerObject);
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        this.sqlServerManager = sqlServerManager;
        this.resourceId = ResourceId.fromString(((LogicalDatabaseTransparentDataEncryptionInner)this.innerModel()).id());
    }

    @Override
    public String name() {
        return ((LogicalDatabaseTransparentDataEncryptionInner)this.innerModel()).name();
    }

    @Override
    public String id() {
        return ((LogicalDatabaseTransparentDataEncryptionInner)this.innerModel()).id();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public String sqlServerName() {
        return this.sqlServerName;
    }

    @Override
    public String databaseName() {
        return this.resourceId.parent().name();
    }

    @Override
    public TransparentDataEncryptionState status() {
        return ((LogicalDatabaseTransparentDataEncryptionInner)this.innerModel()).state();
    }

    @Override
    public TransparentDataEncryption updateStatus(TransparentDataEncryptionState transparentDataEncryptionState) {
        ((SqlManagementClient)this.sqlServerManager.serviceClient()).getTransparentDataEncryptions().createOrUpdate(this.resourceGroupName, this.sqlServerName, this.databaseName(), TransparentDataEncryptionName.CURRENT, new LogicalDatabaseTransparentDataEncryptionInner().withState(transparentDataEncryptionState));
        this.refresh();
        return this;
    }

    @Override
    public Mono<TransparentDataEncryption> updateStatusAsync(TransparentDataEncryptionState transparentDataEncryptionState) {
        TransparentDataEncryptionImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getTransparentDataEncryptions().createOrUpdateAsync(self.resourceGroupName, self.sqlServerName, self.databaseName(), TransparentDataEncryptionName.CURRENT, new LogicalDatabaseTransparentDataEncryptionInner().withState(transparentDataEncryptionState)).then(this.refreshAsync());
    }

    @Override
    protected Mono<LogicalDatabaseTransparentDataEncryptionInner> getInnerAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getTransparentDataEncryptions().getAsync(this.resourceGroupName, this.sqlServerName, this.databaseName(), TransparentDataEncryptionName.CURRENT);
    }
}

