/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models.DatabaseUpdateProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.BackupStorageRedundancy;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.CatalogCollationType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.CreateMode;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.DatabaseIdentity;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.DatabaseLicenseType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.DatabaseReadScale;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.DatabaseStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SampleName;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SecondaryType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.Sku;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.UUID;

public final class DatabaseUpdate
implements JsonSerializable<DatabaseUpdate> {
    private Sku sku;
    private DatabaseIdentity identity;
    private DatabaseUpdateProperties innerProperties;
    private Map<String, String> tags;

    public Sku sku() {
        return this.sku;
    }

    public DatabaseUpdate withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public DatabaseIdentity identity() {
        return this.identity;
    }

    public DatabaseUpdate withIdentity(DatabaseIdentity identity) {
        this.identity = identity;
        return this;
    }

    private DatabaseUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public DatabaseUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public CreateMode createMode() {
        return this.innerProperties() == null ? null : this.innerProperties().createMode();
    }

    public DatabaseUpdate withCreateMode(CreateMode createMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseUpdateProperties();
        }
        this.innerProperties().withCreateMode(createMode);
        return this;
    }

    public String collation() {
        return this.innerProperties() == null ? null : this.innerProperties().collation();
    }

    public DatabaseUpdate withCollation(String collation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseUpdateProperties();
        }
        this.innerProperties().withCollation(collation);
        return this;
    }

    public Long maxSizeBytes() {
        return this.innerProperties() == null ? null : this.innerProperties().maxSizeBytes();
    }

    public DatabaseUpdate withMaxSizeBytes(Long maxSizeBytes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseUpdateProperties();
        }
        this.innerProperties().withMaxSizeBytes(maxSizeBytes);
        return this;
    }

    public SampleName sampleName() {
        return this.innerProperties() == null ? null : this.innerProperties().sampleName();
    }

    public DatabaseUpdate withSampleName(SampleName sampleName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseUpdateProperties();
        }
        this.innerProperties().withSampleName(sampleName);
        return this;
    }

    public String elasticPoolId() {
        return this.innerProperties() == null ? null : this.innerProperties().elasticPoolId();
    }

    public DatabaseUpdate withElasticPoolId(String elasticPoolId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseUpdateProperties();
        }
        this.innerProperties().withElasticPoolId(elasticPoolId);
        return this;
    }

    public String sourceDatabaseId() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceDatabaseId();
    }

    public DatabaseUpdate withSourceDatabaseId(String sourceDatabaseId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseUpdateProperties();
        }
        this.innerProperties().withSourceDatabaseId(sourceDatabaseId);
        return this;
    }

    public DatabaseStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public UUID databaseId() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseId();
    }

    public OffsetDateTime creationDate() {
        return this.innerProperties() == null ? null : this.innerProperties().creationDate();
    }

    public String currentServiceObjectiveName() {
        return this.innerProperties() == null ? null : this.innerProperties().currentServiceObjectiveName();
    }

    public String requestedServiceObjectiveName() {
        return this.innerProperties() == null ? null : this.innerProperties().requestedServiceObjectiveName();
    }

    public String defaultSecondaryLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultSecondaryLocation();
    }

    public String failoverGroupId() {
        return this.innerProperties() == null ? null : this.innerProperties().failoverGroupId();
    }

    public OffsetDateTime restorePointInTime() {
        return this.innerProperties() == null ? null : this.innerProperties().restorePointInTime();
    }

    public DatabaseUpdate withRestorePointInTime(OffsetDateTime restorePointInTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseUpdateProperties();
        }
        this.innerProperties().withRestorePointInTime(restorePointInTime);
        return this;
    }

    public OffsetDateTime sourceDatabaseDeletionDate() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceDatabaseDeletionDate();
    }

    public DatabaseUpdate withSourceDatabaseDeletionDate(OffsetDateTime sourceDatabaseDeletionDate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseUpdateProperties();
        }
        this.innerProperties().withSourceDatabaseDeletionDate(sourceDatabaseDeletionDate);
        return this;
    }

    public String recoveryServicesRecoveryPointId() {
        return this.innerProperties() == null ? null : this.innerProperties().recoveryServicesRecoveryPointId();
    }

    public DatabaseUpdate withRecoveryServicesRecoveryPointId(String recoveryServicesRecoveryPointId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseUpdateProperties();
        }
        this.innerProperties().withRecoveryServicesRecoveryPointId(recoveryServicesRecoveryPointId);
        return this;
    }

    public String longTermRetentionBackupResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().longTermRetentionBackupResourceId();
    }

    public DatabaseUpdate withLongTermRetentionBackupResourceId(String longTermRetentionBackupResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseUpdateProperties();
        }
        this.innerProperties().withLongTermRetentionBackupResourceId(longTermRetentionBackupResourceId);
        return this;
    }

    public String recoverableDatabaseId() {
        return this.innerProperties() == null ? null : this.innerProperties().recoverableDatabaseId();
    }

    public DatabaseUpdate withRecoverableDatabaseId(String recoverableDatabaseId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseUpdateProperties();
        }
        this.innerProperties().withRecoverableDatabaseId(recoverableDatabaseId);
        return this;
    }

    public String restorableDroppedDatabaseId() {
        return this.innerProperties() == null ? null : this.innerProperties().restorableDroppedDatabaseId();
    }

    public DatabaseUpdate withRestorableDroppedDatabaseId(String restorableDroppedDatabaseId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseUpdateProperties();
        }
        this.innerProperties().withRestorableDroppedDatabaseId(restorableDroppedDatabaseId);
        return this;
    }

    public CatalogCollationType catalogCollation() {
        return this.innerProperties() == null ? null : this.innerProperties().catalogCollation();
    }

    public DatabaseUpdate withCatalogCollation(CatalogCollationType catalogCollation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseUpdateProperties();
        }
        this.innerProperties().withCatalogCollation(catalogCollation);
        return this;
    }

    public Boolean zoneRedundant() {
        return this.innerProperties() == null ? null : this.innerProperties().zoneRedundant();
    }

    public DatabaseUpdate withZoneRedundant(Boolean zoneRedundant) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseUpdateProperties();
        }
        this.innerProperties().withZoneRedundant(zoneRedundant);
        return this;
    }

    public DatabaseLicenseType licenseType() {
        return this.innerProperties() == null ? null : this.innerProperties().licenseType();
    }

    public DatabaseUpdate withLicenseType(DatabaseLicenseType licenseType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseUpdateProperties();
        }
        this.innerProperties().withLicenseType(licenseType);
        return this;
    }

    public Long maxLogSizeBytes() {
        return this.innerProperties() == null ? null : this.innerProperties().maxLogSizeBytes();
    }

    public OffsetDateTime earliestRestoreDate() {
        return this.innerProperties() == null ? null : this.innerProperties().earliestRestoreDate();
    }

    public DatabaseReadScale readScale() {
        return this.innerProperties() == null ? null : this.innerProperties().readScale();
    }

    public DatabaseUpdate withReadScale(DatabaseReadScale readScale) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseUpdateProperties();
        }
        this.innerProperties().withReadScale(readScale);
        return this;
    }

    public Integer highAvailabilityReplicaCount() {
        return this.innerProperties() == null ? null : this.innerProperties().highAvailabilityReplicaCount();
    }

    public DatabaseUpdate withHighAvailabilityReplicaCount(Integer highAvailabilityReplicaCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseUpdateProperties();
        }
        this.innerProperties().withHighAvailabilityReplicaCount(highAvailabilityReplicaCount);
        return this;
    }

    public SecondaryType secondaryType() {
        return this.innerProperties() == null ? null : this.innerProperties().secondaryType();
    }

    public DatabaseUpdate withSecondaryType(SecondaryType secondaryType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseUpdateProperties();
        }
        this.innerProperties().withSecondaryType(secondaryType);
        return this;
    }

    public Sku currentSku() {
        return this.innerProperties() == null ? null : this.innerProperties().currentSku();
    }

    public Integer autoPauseDelay() {
        return this.innerProperties() == null ? null : this.innerProperties().autoPauseDelay();
    }

    public DatabaseUpdate withAutoPauseDelay(Integer autoPauseDelay) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseUpdateProperties();
        }
        this.innerProperties().withAutoPauseDelay(autoPauseDelay);
        return this;
    }

    public BackupStorageRedundancy currentBackupStorageRedundancy() {
        return this.innerProperties() == null ? null : this.innerProperties().currentBackupStorageRedundancy();
    }

    public BackupStorageRedundancy requestedBackupStorageRedundancy() {
        return this.innerProperties() == null ? null : this.innerProperties().requestedBackupStorageRedundancy();
    }

    public DatabaseUpdate withRequestedBackupStorageRedundancy(BackupStorageRedundancy requestedBackupStorageRedundancy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseUpdateProperties();
        }
        this.innerProperties().withRequestedBackupStorageRedundancy(requestedBackupStorageRedundancy);
        return this;
    }

    public Double minCapacity() {
        return this.innerProperties() == null ? null : this.innerProperties().minCapacity();
    }

    public DatabaseUpdate withMinCapacity(Double minCapacity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseUpdateProperties();
        }
        this.innerProperties().withMinCapacity(minCapacity);
        return this;
    }

    public OffsetDateTime pausedDate() {
        return this.innerProperties() == null ? null : this.innerProperties().pausedDate();
    }

    public OffsetDateTime resumedDate() {
        return this.innerProperties() == null ? null : this.innerProperties().resumedDate();
    }

    public String maintenanceConfigurationId() {
        return this.innerProperties() == null ? null : this.innerProperties().maintenanceConfigurationId();
    }

    public DatabaseUpdate withMaintenanceConfigurationId(String maintenanceConfigurationId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseUpdateProperties();
        }
        this.innerProperties().withMaintenanceConfigurationId(maintenanceConfigurationId);
        return this;
    }

    public Boolean isLedgerOn() {
        return this.innerProperties() == null ? null : this.innerProperties().isLedgerOn();
    }

    public DatabaseUpdate withIsLedgerOn(Boolean isLedgerOn) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseUpdateProperties();
        }
        this.innerProperties().withIsLedgerOn(isLedgerOn);
        return this;
    }

    public Boolean isInfraEncryptionEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().isInfraEncryptionEnabled();
    }

    public UUID federatedClientId() {
        return this.innerProperties() == null ? null : this.innerProperties().federatedClientId();
    }

    public DatabaseUpdate withFederatedClientId(UUID federatedClientId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DatabaseUpdateProperties();
        }
        this.innerProperties().withFederatedClientId(federatedClientId);
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sku", this.sku);
        jsonWriter.writeJsonField("identity", this.identity);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString((String)element));
        return jsonWriter.writeEndObject();
    }

    public static DatabaseUpdate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DatabaseUpdate deserializedDatabaseUpdate = new DatabaseUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sku".equals(fieldName)) {
                    deserializedDatabaseUpdate.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedDatabaseUpdate.identity = DatabaseIdentity.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDatabaseUpdate.innerProperties = DatabaseUpdateProperties.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDatabaseUpdate.tags = tags;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseUpdate;
        });
    }
}

