/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.TagFilter;
import java.io.IOException;
import java.util.List;

public final class ManagementPolicyFilter
implements JsonSerializable<ManagementPolicyFilter> {
    private List<String> prefixMatch;
    private List<String> blobTypes;
    private List<TagFilter> blobIndexMatch;
    private static final ClientLogger LOGGER = new ClientLogger(ManagementPolicyFilter.class);

    public List<String> prefixMatch() {
        return this.prefixMatch;
    }

    public ManagementPolicyFilter withPrefixMatch(List<String> prefixMatch) {
        this.prefixMatch = prefixMatch;
        return this;
    }

    public List<String> blobTypes() {
        return this.blobTypes;
    }

    public ManagementPolicyFilter withBlobTypes(List<String> blobTypes) {
        this.blobTypes = blobTypes;
        return this;
    }

    public List<TagFilter> blobIndexMatch() {
        return this.blobIndexMatch;
    }

    public ManagementPolicyFilter withBlobIndexMatch(List<TagFilter> blobIndexMatch) {
        this.blobIndexMatch = blobIndexMatch;
        return this;
    }

    public void validate() {
        if (this.blobTypes() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property blobTypes in model ManagementPolicyFilter"));
        }
        if (this.blobIndexMatch() != null) {
            this.blobIndexMatch().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("blobTypes", this.blobTypes, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("prefixMatch", this.prefixMatch, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("blobIndexMatch", this.blobIndexMatch, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static ManagementPolicyFilter fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagementPolicyFilter deserializedManagementPolicyFilter = new ManagementPolicyFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("blobTypes".equals(fieldName)) {
                    List<String> blobTypes = reader.readArray(reader1 -> reader1.getString());
                    deserializedManagementPolicyFilter.blobTypes = blobTypes;
                    continue;
                }
                if ("prefixMatch".equals(fieldName)) {
                    List<String> prefixMatch = reader.readArray(reader1 -> reader1.getString());
                    deserializedManagementPolicyFilter.prefixMatch = prefixMatch;
                    continue;
                }
                if ("blobIndexMatch".equals(fieldName)) {
                    List<TagFilter> blobIndexMatch = reader.readArray(reader1 -> TagFilter.fromJson(reader1));
                    deserializedManagementPolicyFilter.blobIndexMatch = blobIndexMatch;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagementPolicyFilter;
        });
    }
}

