/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.core.client.traits.ConfigurationTrait;
import com.dataiku.dss.shadelibazure.com.azure.core.client.traits.HttpTrait;
import com.dataiku.dss.shadelibazure.com.azure.core.client.traits.TokenCredentialTrait;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpClient;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeader;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaders;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineBuilder;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelinePosition;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.AddHeadersPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpLogOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpLoggingPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpPipelinePolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpPolicyProviders;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.RetryOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.RetryPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.UserAgentPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.util.ClientOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Configuration;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.TracingOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.util.builder.ClientBuilderUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.core.util.tracing.Tracer;
import com.dataiku.dss.shadelibazure.com.azure.core.util.tracing.TracerProvider;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.SecretAsyncClient;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.SecretClient;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.SecretServiceVersion;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.implementation.KeyVaultCredentialPolicy;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.implementation.SecretClientImpl;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@ServiceClientBuilder(serviceClients={SecretClient.class})
public final class SecretClientBuilder
implements TokenCredentialTrait<SecretClientBuilder>,
HttpTrait<SecretClientBuilder>,
ConfigurationTrait<SecretClientBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(SecretClientBuilder.class);
    private static final String AZURE_KEY_VAULT_SECRETS = "azure-key-vault-secrets.properties";
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    private static final String KEYVAULT_TRACING_NAMESPACE_VALUE = "Microsoft.KeyVault";
    private static final ClientOptions DEFAULT_CLIENT_OPTIONS = new ClientOptions();
    private final List<HttpPipelinePolicy> perCallPolicies;
    private final List<HttpPipelinePolicy> perRetryPolicies;
    private final Map<String, String> properties;
    private TokenCredential credential;
    private HttpPipeline pipeline;
    private String vaultUrl;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions = new HttpLogOptions();
    private RetryPolicy retryPolicy;
    private RetryOptions retryOptions;
    private Configuration configuration;
    private SecretServiceVersion version;
    private ClientOptions clientOptions;
    private boolean disableChallengeResourceVerification = false;

    public SecretClientBuilder() {
        this.perCallPolicies = new ArrayList<HttpPipelinePolicy>();
        this.perRetryPolicies = new ArrayList<HttpPipelinePolicy>();
        this.properties = CoreUtils.getProperties(AZURE_KEY_VAULT_SECRETS);
    }

    public SecretClient buildClient() {
        return new SecretClient(this.buildInnerClient(), this.vaultUrl);
    }

    public SecretAsyncClient buildAsyncClient() {
        return new SecretAsyncClient(this.buildInnerClient(), this.vaultUrl);
    }

    private SecretClientImpl buildInnerClient() {
        SecretServiceVersion serviceVersion;
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration().clone() : this.configuration;
        String buildEndpoint = this.getBuildEndpoint(buildConfiguration);
        if (buildEndpoint == null) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("Azure Key Vault endpoint url is required."));
        }
        SecretServiceVersion secretServiceVersion = serviceVersion = this.version != null ? this.version : SecretServiceVersion.getLatest();
        if (this.pipeline != null) {
            return new SecretClientImpl(this.pipeline, serviceVersion.getVersion());
        }
        if (this.credential == null) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("Azure Key Vault credentials are required."));
        }
        ArrayList<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        String clientName = this.properties.getOrDefault(SDK_NAME, "UnknownName");
        String clientVersion = this.properties.getOrDefault(SDK_VERSION, "UnknownVersion");
        this.httpLogOptions = this.httpLogOptions == null ? new HttpLogOptions() : this.httpLogOptions;
        ClientOptions localClientOptions = this.clientOptions != null ? this.clientOptions : DEFAULT_CLIENT_OPTIONS;
        policies.add(new UserAgentPolicy(CoreUtils.getApplicationId(localClientOptions, this.httpLogOptions), clientName, clientVersion, buildConfiguration));
        ArrayList<HttpHeader> httpHeaderList = new ArrayList<HttpHeader>();
        localClientOptions.getHeaders().forEach(header -> httpHeaderList.add(new HttpHeader(header.getName(), header.getValue())));
        policies.add(new AddHeadersPolicy(new HttpHeaders(httpHeaderList)));
        policies.addAll(this.perCallPolicies);
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(ClientBuilderUtil.validateAndGetRetryPolicy(this.retryPolicy, this.retryOptions));
        policies.add(new KeyVaultCredentialPolicy(this.credential, this.disableChallengeResourceVerification));
        policies.addAll(this.perRetryPolicies);
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(new HttpLoggingPolicy(this.httpLogOptions));
        TracingOptions tracingOptions = localClientOptions.getTracingOptions();
        Tracer tracer = TracerProvider.getDefaultProvider().createTracer(clientName, clientVersion, KEYVAULT_TRACING_NAMESPACE_VALUE, tracingOptions);
        HttpPipeline pipeline = new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).clientOptions(localClientOptions).tracer(tracer).build();
        return new SecretClientImpl(pipeline, serviceVersion.getVersion());
    }

    public SecretClientBuilder vaultUrl(String vaultUrl) {
        if (vaultUrl == null) {
            throw LOGGER.logExceptionAsError(new NullPointerException("'vaultUrl' cannot be null."));
        }
        try {
            URL url = new URL(vaultUrl);
            this.vaultUrl = url.toString();
        }
        catch (MalformedURLException e) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("The Azure Key Vault url is malformed.", e));
        }
        return this;
    }

    @Override
    public SecretClientBuilder credential(TokenCredential credential) {
        if (credential == null) {
            throw LOGGER.logExceptionAsError(new NullPointerException("'credential' cannot be null."));
        }
        this.credential = credential;
        return this;
    }

    @Override
    public SecretClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.httpLogOptions = logOptions;
        return this;
    }

    @Override
    public SecretClientBuilder addPolicy(HttpPipelinePolicy policy) {
        if (policy == null) {
            throw LOGGER.logExceptionAsError(new NullPointerException("'policy' cannot be null."));
        }
        if (policy.getPipelinePosition() == HttpPipelinePosition.PER_CALL) {
            this.perCallPolicies.add(policy);
        } else {
            this.perRetryPolicies.add(policy);
        }
        return this;
    }

    @Override
    public SecretClientBuilder httpClient(HttpClient client) {
        this.httpClient = client;
        return this;
    }

    @Override
    public SecretClientBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    @Override
    public SecretClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public SecretClientBuilder serviceVersion(SecretServiceVersion version) {
        this.version = version;
        return this;
    }

    public SecretClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    @Override
    public SecretClientBuilder retryOptions(RetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    @Override
    public SecretClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public SecretClientBuilder disableChallengeResourceVerification() {
        this.disableChallengeResourceVerification = true;
        return this;
    }

    private String getBuildEndpoint(Configuration configuration) {
        if (this.vaultUrl != null) {
            return this.vaultUrl;
        }
        String configEndpoint = configuration.get("AZURE_KEYVAULT_ENDPOINT");
        if (CoreUtils.isNullOrEmpty(configEndpoint)) {
            return null;
        }
        try {
            URL url = new URL(configEndpoint);
            return url.toString();
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }
}

