/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation;

import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Queue;

final class PayloadSizeGate {
    private final long threshold;
    private long size = 0L;
    private Queue<ByteBuffer> byteBuffers = new LinkedList<ByteBuffer>();

    PayloadSizeGate(long threshold) {
        this.threshold = threshold;
    }

    Flux<ByteBuffer> write(ByteBuffer buf) {
        if (this.isThresholdBreached()) {
            this.size += (long)buf.remaining();
            return Flux.just(buf);
        }
        this.size += (long)buf.remaining();
        this.byteBuffers.add(buf);
        if (this.isThresholdBreached()) {
            Flux<ByteBuffer> result = PayloadSizeGate.dequeuingFlux(this.byteBuffers);
            this.byteBuffers = null;
            return result;
        }
        return Flux.empty();
    }

    Flux<ByteBuffer> flush() {
        if (this.byteBuffers != null) {
            Flux<ByteBuffer> result = Flux.fromIterable(this.byteBuffers);
            this.byteBuffers = null;
            return result;
        }
        return Flux.empty();
    }

    long size() {
        return this.size;
    }

    boolean isThresholdBreached() {
        return this.size > this.threshold;
    }

    private static Flux<ByteBuffer> dequeuingFlux(Queue<ByteBuffer> queue) {
        return Flux.generate(sink2 -> {
            ByteBuffer buffer = (ByteBuffer)queue.poll();
            if (buffer != null) {
                sink2.next(buffer);
            } else {
                sink2.complete();
            }
        });
    }
}

