/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.xml;

import com.dataiku.dss.shadelibazure.com.azure.xml.XmlReadValueCallback;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlToken;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Base64;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class XmlReader
implements AutoCloseable {
    private static final XMLInputFactory XML_INPUT_FACTORY = XMLInputFactory.newInstance();
    private final XMLStreamReader reader;
    private XmlToken currentToken;
    private boolean needToReadElementString = true;
    private String currentElementString;

    public static XmlReader fromBytes(byte[] xml) throws XMLStreamException {
        Objects.requireNonNull(xml, "'xml' cannot be null.");
        return XmlReader.fromStream(new ByteArrayInputStream(xml));
    }

    public static XmlReader fromString(String xml) throws XMLStreamException {
        Objects.requireNonNull(xml, "'xml' cannot be null.");
        return XmlReader.fromReader(new StringReader(xml));
    }

    public static XmlReader fromStream(InputStream xml) throws XMLStreamException {
        Objects.requireNonNull(xml, "'xml' cannot be null.");
        return new XmlReader(XML_INPUT_FACTORY.createXMLStreamReader(xml));
    }

    public static XmlReader fromReader(Reader xml) throws XMLStreamException {
        Objects.requireNonNull(xml, "'xml' cannot be null.");
        return new XmlReader(XML_INPUT_FACTORY.createXMLStreamReader(xml));
    }

    public static XmlReader fromXmlStreamReader(XMLStreamReader reader) {
        return new XmlReader(reader);
    }

    private XmlReader(XMLStreamReader reader) {
        this.reader = Objects.requireNonNull(reader, "'reader' cannot be null.");
        this.currentToken = XmlReader.convertEventToToken(reader.getEventType());
    }

    public XmlToken currentToken() {
        return this.currentToken;
    }

    public XmlToken nextElement() throws XMLStreamException {
        int next = this.reader.next();
        while (next != 1 && next != 2 && next != 8) {
            next = this.reader.next();
        }
        this.currentToken = XmlReader.convertEventToToken(next);
        this.needToReadElementString = true;
        this.currentElementString = null;
        return this.currentToken;
    }

    @Override
    public void close() throws XMLStreamException {
        this.reader.close();
    }

    public QName getElementName() {
        return this.reader.getName();
    }

    public String getStringAttribute(String namespaceUri, String localName) {
        String value = this.reader.getAttributeValue(namespaceUri, localName);
        return "".equals(value) ? null : value;
    }

    public byte[] getBinaryAttribute(String namespaceUri, String localName) {
        String value = this.getStringAttribute(namespaceUri, localName);
        return value == null || value.isEmpty() ? null : Base64.getDecoder().decode(value);
    }

    public boolean getBooleanAttribute(String namespaceUri, String localName) {
        return Boolean.parseBoolean(this.getStringAttribute(namespaceUri, localName));
    }

    public double getDoubleAttribute(String namespaceUri, String localName) {
        return Double.parseDouble(this.getStringAttribute(namespaceUri, localName));
    }

    public float getFloatAttribute(String namespaceUri, String localName) {
        return Float.parseFloat(this.getStringAttribute(namespaceUri, localName));
    }

    public int getIntAttribute(String namespaceUri, String localName) {
        return Integer.parseInt(this.getStringAttribute(namespaceUri, localName));
    }

    public long getLongAttribute(String namespaceUri, String localName) {
        return Long.parseLong(this.getStringAttribute(namespaceUri, localName));
    }

    public <T> T getNullableAttribute(String namespaceUri, String localName, XmlReadValueCallback<String, T> converter) throws XMLStreamException {
        String textValue = this.getStringAttribute(namespaceUri, localName);
        if (textValue == null) {
            return null;
        }
        return converter.read(textValue);
    }

    public String getStringElement() throws XMLStreamException {
        if (!this.needToReadElementString) {
            return this.currentElementString;
        }
        int readCount = 0;
        String firstRead = null;
        String[] buffer = null;
        int stringBufferSize = 0;
        int nextEvent = this.reader.next();
        while (nextEvent != 2) {
            if (nextEvent == 4 || nextEvent == 12 || nextEvent == 6 || nextEvent == 9) {
                if (++readCount == 1) {
                    firstRead = this.reader.getText();
                    stringBufferSize = firstRead.length();
                } else {
                    String readText;
                    if (readCount == 2) {
                        buffer = new String[4];
                        buffer[0] = firstRead;
                    }
                    if (readCount > buffer.length - 1) {
                        String[] newBuffer = new String[buffer.length * 2];
                        System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
                        buffer = newBuffer;
                    }
                    buffer[readCount - 1] = readText = this.reader.getText();
                    stringBufferSize += readText.length();
                }
            } else if (nextEvent != 3 && nextEvent != 5) {
                throw new XMLStreamException("Unexpected event type while reading element value " + nextEvent);
            }
            nextEvent = this.reader.next();
        }
        if (readCount == 0) {
            this.currentElementString = null;
        } else if (readCount == 1) {
            this.currentElementString = firstRead;
        } else {
            StringBuilder finalText = new StringBuilder(stringBufferSize);
            for (int i = 0; i < readCount; ++i) {
                finalText.append(buffer[i]);
            }
            this.currentElementString = finalText.toString();
        }
        this.needToReadElementString = false;
        return this.currentElementString;
    }

    public byte[] getBinaryElement() throws XMLStreamException {
        String value = this.getStringElement();
        return value == null || value.isEmpty() ? null : Base64.getDecoder().decode(value);
    }

    public boolean getBooleanElement() throws XMLStreamException {
        return Boolean.parseBoolean(this.getStringElement());
    }

    public double getDoubleElement() throws XMLStreamException {
        return Double.parseDouble(this.getStringElement());
    }

    public float getFloatElement() throws XMLStreamException {
        return Float.parseFloat(this.getStringElement());
    }

    public int getIntElement() throws XMLStreamException {
        return Integer.parseInt(this.getStringElement());
    }

    public long getLongElement() throws XMLStreamException {
        return Long.parseLong(this.getStringElement());
    }

    public <T> T getNullableElement(XmlReadValueCallback<String, T> converter) throws XMLStreamException {
        String textValue = this.getStringElement();
        if (textValue == null) {
            return null;
        }
        return converter.read(textValue);
    }

    public <T> T readObject(String localName, XmlReadValueCallback<XmlReader, T> converter) throws XMLStreamException {
        return this.readObject(null, localName, converter);
    }

    public <T> T readObject(String namespaceUri, String localName, XmlReadValueCallback<XmlReader, T> converter) throws XMLStreamException {
        return this.readObject(new QName(namespaceUri, localName), converter);
    }

    private <T> T readObject(QName startTagName, XmlReadValueCallback<XmlReader, T> converter) throws XMLStreamException {
        if (this.currentToken() != XmlToken.START_ELEMENT) {
            this.nextElement();
        }
        if (this.currentToken() != XmlToken.START_ELEMENT) {
            throw new IllegalStateException("Illegal start of XML deserialization. Expected 'XmlToken.START_ELEMENT' but it was: 'XmlToken." + (Object)((Object)this.currentToken()) + "'.");
        }
        QName tagName = this.getElementName();
        if (!Objects.equals(startTagName, tagName)) {
            throw new IllegalStateException("Expected XML element to be '" + startTagName + "' but it was: " + tagName + "'.");
        }
        return converter.read(this);
    }

    public void skipElement() throws XMLStreamException {
        XmlToken currentToken = this.currentToken();
        if (currentToken != XmlToken.START_ELEMENT) {
            return;
        }
        int depth = 1;
        while (depth > 0) {
            currentToken = this.nextElement();
            if (currentToken == XmlToken.START_ELEMENT) {
                ++depth;
                continue;
            }
            if (currentToken != XmlToken.END_ELEMENT) break;
            --depth;
        }
    }

    private static XmlToken convertEventToToken(int event) {
        switch (event) {
            case 1: {
                return XmlToken.START_ELEMENT;
            }
            case 2: {
                return XmlToken.END_ELEMENT;
            }
            case 7: {
                return XmlToken.START_DOCUMENT;
            }
            case 8: {
                return XmlToken.END_DOCUMENT;
            }
        }
        throw new IllegalStateException("Unknown/unsupported XMLStreamConstants: " + event);
    }

    static {
        XML_INPUT_FACTORY.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        XML_INPUT_FACTORY.setProperty("javax.xml.stream.supportDTD", false);
    }
}

