/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.microsoft.graph.serializer;

import com.dataiku.dss.shadelibazure.com.google.gson.JsonElement;
import com.dataiku.dss.shadelibazure.com.google.gson.JsonObject;
import com.dataiku.dss.shadelibazure.com.google.gson.annotations.Expose;
import com.dataiku.dss.shadelibazure.com.google.gson.annotations.SerializedName;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.serializer.IJsonBackedObject;
import com.dataiku.dss.shadelibazure.javax.annotation.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AdditionalDataManager
extends HashMap<String, JsonElement> {
    private static final long serialVersionUID = 8641634955796941429L;
    private final transient IJsonBackedObject jsonBackedObject;

    @SuppressFBWarnings
    public AdditionalDataManager(@Nullable IJsonBackedObject jsonBackedObject) {
        this.jsonBackedObject = jsonBackedObject;
    }

    final void setAdditionalData(JsonObject json) {
        Set<String> objectFields = this.getFields();
        Set<String> jsonKeys = this.getJsonKeys(json);
        HashSet<String> additionalDataKeys = new HashSet<String>(jsonKeys);
        additionalDataKeys.removeAll(objectFields);
        for (String jsonKey : additionalDataKeys) {
            this.put(jsonKey, json.get(jsonKey));
        }
    }

    private Set<String> getJsonKeys(JsonObject json) {
        HashSet<String> keys2 = new HashSet<String>();
        Set<Map.Entry<String, JsonElement>> entries = json.entrySet();
        for (Map.Entry<String, JsonElement> entry : entries) {
            keys2.add(entry.getKey());
        }
        return keys2;
    }

    private Set<String> getFields() {
        HashSet<String> serializingFields = new HashSet<String>();
        if (this.jsonBackedObject != null) {
            Field[] fields;
            for (Field field : fields = this.jsonBackedObject.getClass().getFields()) {
                SerializedName serializedName = field.getAnnotation(SerializedName.class);
                if (null == serializedName || null == field.getAnnotation(Expose.class)) continue;
                serializingFields.add(serializedName.value());
            }
        }
        return serializingFields;
    }
}

