/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.nimbusds.jwt;

import com.dataiku.dss.shadelibazure.com.nimbusds.jose.JOSEObject;
import com.dataiku.dss.shadelibazure.com.nimbusds.jose.Payload;
import com.dataiku.dss.shadelibazure.com.nimbusds.jose.PlainHeader;
import com.dataiku.dss.shadelibazure.com.nimbusds.jose.PlainObject;
import com.dataiku.dss.shadelibazure.com.nimbusds.jose.shaded.jcip.ThreadSafe;
import com.dataiku.dss.shadelibazure.com.nimbusds.jose.util.Base64URL;
import com.dataiku.dss.shadelibazure.com.nimbusds.jwt.JWT;
import com.dataiku.dss.shadelibazure.com.nimbusds.jwt.JWTClaimsSet;
import java.text.ParseException;
import java.util.Map;

@ThreadSafe
public class PlainJWT
extends PlainObject
implements JWT {
    private static final long serialVersionUID = 1L;
    private JWTClaimsSet claimsSet;

    public PlainJWT(JWTClaimsSet claimsSet) {
        super(claimsSet.toPayload());
        this.claimsSet = claimsSet;
    }

    public PlainJWT(PlainHeader header, JWTClaimsSet claimsSet) {
        super(header, claimsSet.toPayload());
        this.claimsSet = claimsSet;
    }

    public PlainJWT(Base64URL firstPart, Base64URL secondPart) throws ParseException {
        super(firstPart, secondPart);
    }

    @Override
    public JWTClaimsSet getJWTClaimsSet() throws ParseException {
        if (this.claimsSet != null) {
            return this.claimsSet;
        }
        Map<String, Object> jsonObject = this.getPayload().toJSONObject();
        if (jsonObject == null) {
            throw new ParseException("Payload of unsecured JOSE object is not a valid JSON object", 0);
        }
        this.claimsSet = JWTClaimsSet.parse(jsonObject);
        return this.claimsSet;
    }

    @Override
    protected void setPayload(Payload payload) {
        this.claimsSet = null;
        super.setPayload(payload);
    }

    public static PlainJWT parse(String s2) throws ParseException {
        Base64URL[] parts = JOSEObject.split(s2);
        if (!parts[2].toString().isEmpty()) {
            throw new ParseException("Unexpected third Base64URL part in the unsecured JWT object", 0);
        }
        return new PlainJWT(parts[0], parts[1]);
    }
}

