/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.core.publisher;

import com.dataiku.dss.shadelibazure.io.micrometer.core.instrument.Clock;
import com.dataiku.dss.shadelibazure.io.micrometer.core.instrument.MeterRegistry;
import com.dataiku.dss.shadelibazure.io.micrometer.core.instrument.Tags;
import com.dataiku.dss.shadelibazure.io.micrometer.core.instrument.Timer;
import com.dataiku.dss.shadelibazure.org.reactivestreams.Subscription;
import com.dataiku.dss.shadelibazure.reactor.core.CoreSubscriber;
import com.dataiku.dss.shadelibazure.reactor.core.Fuseable;
import com.dataiku.dss.shadelibazure.reactor.core.Scannable;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.FluxMetrics;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.InternalMonoOperator;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.MonoMetrics;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Operators;
import com.dataiku.dss.shadelibazure.reactor.util.Metrics;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;

final class MonoMetricsFuseable<T>
extends InternalMonoOperator<T, T>
implements Fuseable {
    final String name;
    final Tags tags;
    final MeterRegistry registryCandidate;

    MonoMetricsFuseable(Mono<? extends T> mono) {
        super(mono);
        this.name = FluxMetrics.resolveName(mono);
        this.tags = FluxMetrics.resolveTags(mono, FluxMetrics.DEFAULT_TAGS_MONO);
        this.registryCandidate = Metrics.MicrometerConfiguration.getRegistry();
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        return new MetricsFuseableSubscriber<T>(actual, this.registryCandidate, Clock.SYSTEM, this.name, this.tags);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key);
    }

    static final class MetricsFuseableSubscriber<T>
    extends MonoMetrics.MetricsSubscriber<T>
    implements Fuseable,
    Fuseable.QueueSubscription<T> {
        int mode;
        @Nullable
        Fuseable.QueueSubscription<T> qs;

        MetricsFuseableSubscriber(CoreSubscriber<? super T> actual, MeterRegistry registry, Clock clock, String sequenceName, Tags sequenceTags) {
            super(actual, registry, clock, sequenceName, sequenceTags);
        }

        @Override
        public void clear() {
            if (this.qs != null) {
                this.qs.clear();
            }
        }

        @Override
        public void onComplete() {
            if (this.mode == 2) {
                if (!this.done) {
                    FluxMetrics.recordOnCompleteEmpty(this.sequenceName, this.commonTags, this.registry, this.subscribeToTerminateSample);
                }
                this.actual.onComplete();
            } else {
                if (this.done) {
                    return;
                }
                this.done = true;
                FluxMetrics.recordOnCompleteEmpty(this.sequenceName, this.commonTags, this.registry, this.subscribeToTerminateSample);
                this.actual.onComplete();
            }
        }

        @Override
        public void onNext(T t) {
            if (this.mode == 2) {
                this.actual.onNext(null);
            } else {
                if (this.done) {
                    FluxMetrics.recordMalformed(this.sequenceName, this.commonTags, this.registry);
                    Operators.onNextDropped(t, this.actual.currentContext());
                    return;
                }
                this.done = true;
                FluxMetrics.recordOnComplete(this.sequenceName, this.commonTags, this.registry, this.subscribeToTerminateSample);
                this.actual.onNext(t);
                this.actual.onComplete();
            }
        }

        @Override
        public boolean isEmpty() {
            return this.qs == null || this.qs.isEmpty();
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (Operators.validate(this.s, s2)) {
                FluxMetrics.recordOnSubscribe(this.sequenceName, this.commonTags, this.registry);
                this.subscribeToTerminateSample = Timer.start((Clock)this.clock);
                this.qs = Operators.as(s2);
                this.s = s2;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        @Nullable
        public T poll() {
            if (this.qs == null) {
                return null;
            }
            try {
                Object v = this.qs.poll();
                if (!this.done) {
                    if (v == null && this.mode == 1) {
                        FluxMetrics.recordOnCompleteEmpty(this.sequenceName, this.commonTags, this.registry, this.subscribeToTerminateSample);
                    } else if (v != null) {
                        FluxMetrics.recordOnComplete(this.sequenceName, this.commonTags, this.registry, this.subscribeToTerminateSample);
                    }
                }
                this.done = true;
                return (T)v;
            }
            catch (Throwable e) {
                FluxMetrics.recordOnError(this.sequenceName, this.commonTags, this.registry, this.subscribeToTerminateSample, e);
                throw e;
            }
        }

        @Override
        public int requestFusion(int mode) {
            if (this.qs != null) {
                this.mode = this.qs.requestFusion(mode);
                return this.mode;
            }
            return 0;
        }

        @Override
        public int size() {
            return this.qs == null ? 0 : this.qs.size();
        }

        @Override
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.RUN_STYLE) {
                return Scannable.Attr.RunStyle.SYNC;
            }
            return super.scanUnsafe(key);
        }
    }
}

