/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.http.server;

import com.dataiku.dss.shadelibazure.io.micrometer.core.instrument.Counter;
import com.dataiku.dss.shadelibazure.io.micrometer.core.instrument.DistributionSummary;
import com.dataiku.dss.shadelibazure.io.micrometer.core.instrument.Gauge;
import com.dataiku.dss.shadelibazure.io.micrometer.core.instrument.Timer;
import com.dataiku.dss.shadelibazure.reactor.netty.Metrics;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.MeterKey;
import com.dataiku.dss.shadelibazure.reactor.netty.http.MicrometerHttpMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.HttpServerMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.internal.util.MapUtils;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;

final class MicrometerHttpServerMetricsRecorder
extends MicrometerHttpMetricsRecorder
implements HttpServerMetricsRecorder {
    static final MicrometerHttpServerMetricsRecorder INSTANCE = new MicrometerHttpServerMetricsRecorder();
    private static final String PROTOCOL_VALUE_HTTP = "http";
    private static final String ACTIVE_CONNECTIONS_DESCRIPTION = "The number of http connections currently processing requests";
    private static final String ACTIVE_STREAMS_DESCRIPTION = "The number of HTTP/2 streams currently active on the server";
    private final ConcurrentMap<String, LongAdder> activeConnectionsCache = new ConcurrentHashMap<String, LongAdder>();
    private final ConcurrentMap<String, LongAdder> activeStreamsCache = new ConcurrentHashMap<String, LongAdder>();
    private final ConcurrentMap<String, DistributionSummary> dataReceivedCache = new ConcurrentHashMap<String, DistributionSummary>();
    private final ConcurrentMap<String, DistributionSummary> dataSentCache = new ConcurrentHashMap<String, DistributionSummary>();
    private final ConcurrentMap<String, Counter> errorsCache = new ConcurrentHashMap<String, Counter>();

    private MicrometerHttpServerMetricsRecorder() {
        super("com.dataiku.dss.shadelibazure.reactor.netty.http.server", PROTOCOL_VALUE_HTTP);
    }

    @Override
    public void recordDataReceivedTime(String uri, String method, Duration time) {
        MeterKey meterKey = new MeterKey(uri, null, method, null);
        Timer dataReceivedTime = MapUtils.computeIfAbsent(this.dataReceivedTimeCache, meterKey, key -> MicrometerHttpServerMetricsRecorder.filter(Timer.builder((String)(this.name() + ".data.received.time")).description("Time spent in consuming incoming data").tags(new String[]{"uri", uri, "method", method}).register(Metrics.REGISTRY)));
        if (dataReceivedTime != null) {
            dataReceivedTime.record(time);
        }
    }

    @Override
    public void recordDataSentTime(String uri, String method, String status, Duration time) {
        MeterKey meterKey = new MeterKey(uri, null, method, status);
        Timer dataSentTime = MapUtils.computeIfAbsent(this.dataSentTimeCache, meterKey, key -> MicrometerHttpServerMetricsRecorder.filter(Timer.builder((String)(this.name() + ".data.sent.time")).description("Time spent in sending outgoing data").tags(new String[]{"uri", uri, "method", method, "status", status}).register(Metrics.REGISTRY)));
        if (dataSentTime != null) {
            dataSentTime.record(time);
        }
    }

    @Override
    public void recordResponseTime(String uri, String method, String status, Duration time) {
        MeterKey meterKey = new MeterKey(uri, null, method, status);
        Timer responseTime = MapUtils.computeIfAbsent(this.responseTimeCache, meterKey, key -> MicrometerHttpServerMetricsRecorder.filter(Timer.builder((String)(this.name() + ".response.time")).description("Total time for the request/response").tags(new String[]{"uri", uri, "method", method, "status", status}).register(Metrics.REGISTRY)));
        if (responseTime != null) {
            responseTime.record(time);
        }
    }

    @Override
    public void recordDataReceived(SocketAddress remoteAddress, String uri, long bytes) {
        DistributionSummary dataReceived = MapUtils.computeIfAbsent(this.dataReceivedCache, uri, key -> MicrometerHttpServerMetricsRecorder.filter(DistributionSummary.builder((String)(this.name() + ".data.received")).baseUnit("bytes").description("Amount of the data received, in bytes").tags(new String[]{"uri", uri}).register(Metrics.REGISTRY)));
        if (dataReceived != null) {
            dataReceived.record((double)bytes);
        }
    }

    @Override
    public void recordDataSent(SocketAddress remoteAddress, String uri, long bytes) {
        DistributionSummary dataSent = MapUtils.computeIfAbsent(this.dataSentCache, uri, key -> MicrometerHttpServerMetricsRecorder.filter(DistributionSummary.builder((String)(this.name() + ".data.sent")).baseUnit("bytes").description("Amount of the data sent, in bytes").tags(new String[]{"uri", uri}).register(Metrics.REGISTRY)));
        if (dataSent != null) {
            dataSent.record((double)bytes);
        }
    }

    @Override
    public void incrementErrorsCount(SocketAddress remoteAddress, String uri) {
        Counter errors = MapUtils.computeIfAbsent(this.errorsCache, uri, key -> MicrometerHttpServerMetricsRecorder.filter(Counter.builder((String)(this.name() + ".errors")).description("Number of errors that occurred").tags(new String[]{"uri", uri}).register(Metrics.REGISTRY)));
        if (errors != null) {
            errors.increment();
        }
    }

    @Override
    public void recordServerConnectionActive(SocketAddress localAddress) {
        LongAdder adder = this.getServerConnectionAdder(localAddress);
        if (adder != null) {
            adder.increment();
        }
    }

    @Override
    public void recordServerConnectionInactive(SocketAddress localAddress) {
        LongAdder adder = this.getServerConnectionAdder(localAddress);
        if (adder != null) {
            adder.decrement();
        }
    }

    @Override
    public void recordStreamOpened(SocketAddress localAddress) {
        LongAdder adder = this.getActiveStreamsAdder(localAddress);
        if (adder != null) {
            adder.increment();
        }
    }

    @Override
    public void recordStreamClosed(SocketAddress localAddress) {
        LongAdder adder = this.getActiveStreamsAdder(localAddress);
        if (adder != null) {
            adder.decrement();
        }
    }

    @Override
    public void recordDataReceived(SocketAddress remoteAddress, long bytes) {
    }

    @Override
    public void recordDataSent(SocketAddress remoteAddress, long bytes) {
    }

    @Override
    public void incrementErrorsCount(SocketAddress remoteAddress) {
    }

    @Override
    public void recordTlsHandshakeTime(SocketAddress remoteAddress, Duration time, String status) {
    }

    @Override
    public void recordConnectTime(SocketAddress remoteAddress, Duration time, String status) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void recordResolveAddressTime(SocketAddress remoteAddress, Duration time, String status) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    LongAdder getActiveStreamsAdder(SocketAddress localAddress) {
        String address = Metrics.formatSocketAddress(localAddress);
        return MapUtils.computeIfAbsent(this.activeStreamsCache, address, key -> {
            LongAdder activeStreamsAdder = new LongAdder();
            Gauge gauge = MicrometerHttpServerMetricsRecorder.filter(Gauge.builder((String)(this.name() + ".streams.active"), (Object)activeStreamsAdder, LongAdder::longValue).tags(new String[]{"uri", PROTOCOL_VALUE_HTTP, "local.address", address}).description(ACTIVE_STREAMS_DESCRIPTION).register(Metrics.REGISTRY));
            return gauge != null ? activeStreamsAdder : null;
        });
    }

    @Nullable
    LongAdder getServerConnectionAdder(SocketAddress localAddress) {
        String address = Metrics.formatSocketAddress(localAddress);
        return MapUtils.computeIfAbsent(this.activeConnectionsCache, address, key -> {
            LongAdder activeConnectionsAdder = new LongAdder();
            Gauge gauge = MicrometerHttpServerMetricsRecorder.filter(Gauge.builder((String)"com.dataiku.dss.shadelibazure.reactor.netty.http.server.connections.active", (Object)activeConnectionsAdder, LongAdder::longValue).tags(new String[]{"uri", PROTOCOL_VALUE_HTTP, "local.address", address}).description(ACTIVE_CONNECTIONS_DESCRIPTION).register(Metrics.REGISTRY));
            return gauge != null ? activeConnectionsAdder : null;
        });
    }
}

