/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.tcp;

import com.dataiku.dss.shadelibazure.io.netty.channel.Channel;
import com.dataiku.dss.shadelibazure.io.netty.channel.EventLoopGroup;
import com.dataiku.dss.shadelibazure.io.netty.resolver.AddressResolverGroup;
import com.dataiku.dss.shadelibazure.io.netty.resolver.dns.DnsAddressResolverGroup;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.netty.Connection;
import com.dataiku.dss.shadelibazure.reactor.netty.ConnectionObserver;
import com.dataiku.dss.shadelibazure.reactor.netty.resources.ConnectionProvider;
import com.dataiku.dss.shadelibazure.reactor.netty.resources.LoopResources;
import com.dataiku.dss.shadelibazure.reactor.netty.transport.NameResolverProvider;
import com.dataiku.dss.shadelibazure.reactor.netty.transport.TransportConfig;
import com.dataiku.dss.shadelibazure.reactor.util.Logger;
import com.dataiku.dss.shadelibazure.reactor.util.Loggers;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public class TcpResources
implements ConnectionProvider,
LoopResources {
    final LoopResources defaultLoops;
    final ConnectionProvider defaultProvider;
    final AtomicReference<AddressResolverGroup<?>> defaultResolver;
    static final NameResolverProvider DEFAULT_NAME_RESOLVER_PROVIDER;
    static final Logger log;
    static final BiFunction<LoopResources, ConnectionProvider, TcpResources> ON_TCP_NEW;
    static final AtomicReference<TcpResources> tcpResources;

    public static void disposeLoopsAndConnections() {
        TcpResources resources = tcpResources.getAndSet(null);
        if (resources != null) {
            resources._dispose();
        }
    }

    public static Mono<Void> disposeLoopsAndConnectionsLater() {
        return TcpResources.disposeLoopsAndConnectionsLater(Duration.ofSeconds(LoopResources.DEFAULT_SHUTDOWN_QUIET_PERIOD), Duration.ofSeconds(LoopResources.DEFAULT_SHUTDOWN_TIMEOUT));
    }

    public static Mono<Void> disposeLoopsAndConnectionsLater(Duration quietPeriod, Duration timeout2) {
        Objects.requireNonNull(quietPeriod, "quietPeriod");
        Objects.requireNonNull(timeout2, "timeout");
        return Mono.defer(() -> {
            TcpResources resources = tcpResources.getAndSet(null);
            if (resources != null) {
                return resources._disposeLater(quietPeriod, timeout2);
            }
            return Mono.empty();
        });
    }

    public static TcpResources get() {
        return TcpResources.getOrCreate(tcpResources, null, null, ON_TCP_NEW, "tcp");
    }

    public static TcpResources reset() {
        TcpResources.disposeLoopsAndConnections();
        return TcpResources.getOrCreate(tcpResources, null, null, ON_TCP_NEW, "tcp");
    }

    public static TcpResources set(ConnectionProvider provider) {
        return TcpResources.getOrCreate(tcpResources, null, provider, ON_TCP_NEW, "tcp");
    }

    public static TcpResources set(LoopResources loops) {
        return TcpResources.getOrCreate(tcpResources, loops, null, ON_TCP_NEW, "tcp");
    }

    protected TcpResources(LoopResources defaultLoops, ConnectionProvider defaultProvider) {
        this.defaultLoops = defaultLoops;
        this.defaultProvider = defaultProvider;
        this.defaultResolver = new AtomicReference();
    }

    @Override
    public Mono<? extends Connection> acquire(TransportConfig config, ConnectionObserver observer, @Nullable Supplier<? extends SocketAddress> remoteAddress, @Nullable AddressResolverGroup<?> resolverGroup) {
        Objects.requireNonNull(config, "config");
        Objects.requireNonNull(observer, "observer");
        return this.defaultProvider.acquire(config, observer, remoteAddress, resolverGroup);
    }

    @Override
    public boolean daemon() {
        return this.defaultLoops.daemon();
    }

    @Override
    public void dispose() {
    }

    @Override
    public Mono<Void> disposeLater() {
        return Mono.empty();
    }

    @Override
    public Mono<Void> disposeLater(Duration quietPeriod, Duration timeout2) {
        return Mono.empty();
    }

    @Override
    public void disposeWhen(SocketAddress remoteAddress) {
        this.defaultProvider.disposeWhen(remoteAddress);
    }

    @Override
    public boolean isDisposed() {
        return this.defaultLoops.isDisposed() && this.defaultProvider.isDisposed();
    }

    @Override
    public int maxConnections() {
        return this.defaultProvider.maxConnections();
    }

    @Override
    public Map<SocketAddress, Integer> maxConnectionsPerHost() {
        return this.defaultProvider.maxConnectionsPerHost();
    }

    @Override
    public ConnectionProvider.Builder mutate() {
        return this.defaultProvider.mutate();
    }

    @Override
    public String name() {
        return this.defaultProvider.name();
    }

    @Override
    public <CHANNEL extends Channel> CHANNEL onChannel(Class<CHANNEL> channelType, EventLoopGroup group) {
        Objects.requireNonNull(channelType, "channelType");
        Objects.requireNonNull(group, "group");
        return this.defaultLoops.onChannel(channelType, group);
    }

    @Override
    public <CHANNEL extends Channel> Class<? extends CHANNEL> onChannelClass(Class<CHANNEL> channelType, EventLoopGroup group) {
        Objects.requireNonNull(channelType, "channelType");
        Objects.requireNonNull(group, "group");
        return this.defaultLoops.onChannelClass(channelType, group);
    }

    @Override
    public EventLoopGroup onClient(boolean useNative) {
        return this.defaultLoops.onClient(useNative);
    }

    @Override
    public EventLoopGroup onServer(boolean useNative) {
        return this.defaultLoops.onServer(useNative);
    }

    @Override
    public EventLoopGroup onServerSelect(boolean useNative) {
        return this.defaultLoops.onServerSelect(useNative);
    }

    protected void _dispose() {
        this.defaultProvider.dispose();
        this._disposeResolver();
        this.defaultLoops.dispose();
    }

    protected Mono<Void> _disposeLater(Duration quietPeriod, Duration timeout2) {
        return Mono.when(this._disposeResolverLater(), this.defaultLoops.disposeLater(quietPeriod, timeout2), this.defaultProvider.disposeLater());
    }

    protected AddressResolverGroup<?> getOrCreateDefaultResolver() {
        AddressResolverGroup<?> resolverGroup = this.defaultResolver.get();
        if (resolverGroup == null) {
            DnsAddressResolverGroup newResolverGroup = DEFAULT_NAME_RESOLVER_PROVIDER.newNameResolverGroup(this.defaultLoops, LoopResources.DEFAULT_NATIVE);
            if (!this.defaultResolver.compareAndSet(null, newResolverGroup)) {
                newResolverGroup.close();
            }
            resolverGroup = this.getOrCreateDefaultResolver();
        }
        return resolverGroup;
    }

    void _disposeResolver() {
        AddressResolverGroup<?> addressResolverGroup = this.defaultResolver.get();
        if (addressResolverGroup != null) {
            addressResolverGroup.close();
        }
    }

    Mono<Void> _disposeResolverLater() {
        Mono<Void> disposeResolver = Mono.empty();
        AddressResolverGroup<?> addressResolverGroup = this.defaultResolver.get();
        if (addressResolverGroup != null) {
            disposeResolver = Mono.fromRunnable(addressResolverGroup::close);
        }
        return disposeResolver;
    }

    protected static <T extends TcpResources> T getOrCreate(AtomicReference<T> ref, @Nullable LoopResources loops, @Nullable ConnectionProvider provider, BiFunction<LoopResources, ConnectionProvider, T> onNew, String name) {
        TcpResources resources;
        while ((resources = (TcpResources)ref.get()) == null || loops != null || provider != null) {
            TcpResources update = TcpResources.create(resources, loops, provider, name, onNew);
            if (ref.compareAndSet(resources, update)) {
                if (resources != null) {
                    if (loops != null) {
                        if (log.isWarnEnabled()) {
                            log.warn("[{}] resources will use a new LoopResources: {}, the previous LoopResources will be disposed", name, loops);
                        }
                        resources._disposeResolver();
                        resources.defaultLoops.dispose();
                    }
                    if (provider != null) {
                        if (log.isWarnEnabled()) {
                            log.warn("[{}] resources will use a new ConnectionProvider: {}, the previous ConnectionProvider will be disposed", name, provider);
                        }
                        resources.defaultProvider.dispose();
                    }
                } else {
                    String poolType;
                    String loopType;
                    String string = loopType = loops == null ? "default" : "provided";
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] resources will use the {} LoopResources: {}", name, loopType, update.defaultLoops);
                    }
                    String string2 = poolType = provider == null ? "default" : "provided";
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] resources will use the {} ConnectionProvider: {}", name, poolType, update.defaultProvider);
                    }
                }
                return (T)update;
            }
            update._dispose();
        }
        return (T)resources;
    }

    static <T extends TcpResources> T create(@Nullable T previous, @Nullable LoopResources loops, @Nullable ConnectionProvider provider, String name, BiFunction<LoopResources, ConnectionProvider, T> onNew) {
        if (previous == null) {
            loops = loops == null ? LoopResources.create("com.dataiku.dss.shadelibazure.reactor-" + name) : loops;
            provider = provider == null ? ConnectionProvider.create(name, 500) : provider;
        } else {
            loops = loops == null ? previous.defaultLoops : loops;
            provider = provider == null ? previous.defaultProvider : provider;
        }
        return (T)((TcpResources)onNew.apply(loops, provider));
    }

    static {
        log = Loggers.getLogger(TcpResources.class);
        DEFAULT_NAME_RESOLVER_PROVIDER = NameResolverProvider.builder().build();
        ON_TCP_NEW = TcpResources::new;
        tcpResources = new AtomicReference();
    }
}

