/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.kernels;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class DSSKernelManagerBase<T extends KernelHandle> {
    private final DKULogger logger;
    private final String metricsPrefix;
    private final KernelManagerConfig config;
    private final LinkedBlockingQueue<T> returnedKernels = new LinkedBlockingQueue();
    private final Map<String, T> startingKernels = Maps.newConcurrentMap();
    private final List<T> freeKernels = new ArrayList<T>();
    private final List<T> usedKernels = new ArrayList<T>();
    private final String processType;
    AtomicBoolean stop = new AtomicBoolean(false);

    protected abstract T createKernelHandle(String var1);

    protected T getStarting(String kernelId) {
        return (T)((KernelHandle)this.startingKernels.get(kernelId));
    }

    public void onStart() {
        DSSMetrics.registry().register(this.metricsPrefix + ".pool.freeKernels", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return DSSKernelManagerBase.this.getFreeKernelCount();
            }
        });
        DSSMetrics.registry().register(this.metricsPrefix + ".pool.inUseKernels", (Metric)new Gauge<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Integer getValue() {
                DSSKernelManagerBase dSSKernelManagerBase = DSSKernelManagerBase.this;
                synchronized (dSSKernelManagerBase) {
                    return DSSKernelManagerBase.this.usedKernels.size();
                }
            }
        });
    }

    public DSSKernelManagerBase(DKULogger logger, String metricsPrefix, String processType, KernelManagerConfig config) {
        this.processType = processType;
        this.logger = logger;
        this.metricsPrefix = metricsPrefix;
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFreeKernelCount() {
        DSSKernelManagerBase dSSKernelManagerBase = this;
        synchronized (dSSKernelManagerBase) {
            return this.freeKernels.size();
        }
    }

    private T newKernel() throws Exception {
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx(this.metricsPrefix + ".startKernel");){
            String id = this.processType + "-" + SecretKeyGenerator.generate(8);
            this.logger.info((Object)("Starting new " + this.processType + " " + id));
            T kernel = this.createKernelHandle(id);
            this.startingKernels.put(kernel.getId(), kernel);
            try {
                kernel.start();
                this.logger.info((Object)(this.processType + " " + kernel.getId() + " started and ready to work"));
            }
            catch (Exception e) {
                this.logger.warn((Object)(this.processType + " failed to start, remove from list"));
                throw e;
            }
            finally {
                this.startingKernels.remove(kernel.getId());
            }
            T t = kernel;
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateKernels() {
        ArrayList toKill;
        DSSMetrics.registry().meter(this.metricsPrefix + ".globalInvalidations").mark();
        this.logger.info((Object)("Invalidating all " + this.processType + "s"));
        DSSKernelManagerBase dSSKernelManagerBase = this;
        synchronized (dSSKernelManagerBase) {
            if (this.config.canReuseKernels()) {
                for (KernelHandle kernel : this.usedKernels) {
                    kernel.sentence();
                }
            }
            toKill = Lists.newArrayList(this.freeKernels);
            this.freeKernels.clear();
        }
        for (KernelHandle kernel : toKill) {
            this.destroyKernel(kernel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseKernel(T kernel) {
        DSSMetrics.registry().meter(this.metricsPrefix + ".releasedKernels").mark();
        this.logger.info((Object)("Release " + this.processType + " " + kernel.getId()));
        DSSKernelManagerBase dSSKernelManagerBase = this;
        synchronized (dSSKernelManagerBase) {
            assert (this.usedKernels.contains(kernel));
            assert (!this.freeKernels.contains(kernel));
            this.usedKernels.remove(kernel);
        }
        if (this.config.canReuseKernels()) {
            kernel.release();
            if (kernel.isSentenced()) {
                this.logger.info((Object)(this.processType + " " + kernel.getId() + " has been marked for removal, destroying it"));
                this.destroyKernel(kernel);
            } else {
                try {
                    this.returnedKernels.put(kernel);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.logger.info((Object)("Failed to return the " + this.processType), (Throwable)e);
                }
            }
        } else {
            this.logger.info((Object)"Not reusing kernels");
            this.destroyKernel(kernel);
        }
    }

    public void releaseAndKillKernel(T kernel) {
        DSSMetrics.registry().meter(this.metricsPrefix + ".releasedAndKilledKernels").mark();
        if (this.config.canReuseKernels()) {
            kernel.sentence();
        }
        this.releaseKernel(kernel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyKernel(T kernel) {
        DSSMetrics.registry().meter(this.metricsPrefix + ".destroyedKernels").mark();
        DSSKernelManagerBase dSSKernelManagerBase = this;
        synchronized (dSSKernelManagerBase) {
            assert (!this.freeKernels.contains(kernel));
            assert (!this.usedKernels.contains(kernel));
        }
        try {
            kernel.killWithoutMercy();
        }
        catch (Exception e) {
            this.logger.error((Object)"Failure while destroying the kernel", (Throwable)e);
        }
        this.logger.info((Object)("Destroyed " + this.processType + " " + kernel.getId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T acquireKernel(String jobId, AuthCtx authCtx, String projectKey) throws Exception {
        try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx(this.metricsPrefix + ".acquireKernel");){
            this.logger.debug((Object)("Acquiring a " + this.processType));
            KernelHandle kernel = null;
            ArrayList<KernelHandle> toKill = new ArrayList<KernelHandle>();
            Object object = this;
            synchronized (object) {
                while (!this.freeKernels.isEmpty() && kernel == null) {
                    kernel = (KernelHandle)this.freeKernels.remove(this.freeKernels.size() - 1);
                    try {
                        kernel.ping();
                    }
                    catch (Exception e) {
                        toKill.add(kernel);
                        kernel = null;
                    }
                }
            }
            for (KernelHandle k : toKill) {
                this.logger.warn((Object)(this.processType + " " + k.getId() + " not usable anymore, destroying it"));
                this.destroyKernel(k);
            }
            if (kernel == null) {
                this.logger.info((Object)("No working " + this.processType + " available in pool, starting a new one"));
                DSSMetrics.registry().meter(this.metricsPrefix + ".synchronousKernelCreated").mark();
                try (DSSMetrics.TimeCtx tctx2 = DSSMetrics.timeCtx(this.metricsPrefix + ".synchronousKernelCreation");){
                    kernel = this.newKernel();
                }
            }
            kernel.acquire(jobId, authCtx, projectKey);
            object = this;
            synchronized (object) {
                this.usedKernels.add(kernel);
            }
            object = kernel;
            return (T)object;
        }
    }

    synchronized List<T> getFreeKernels() {
        return this.freeKernels;
    }

    synchronized List<T> getUsedKernels() {
        return this.usedKernels;
    }

    public synchronized T getUsedKernel(String id) {
        return (T)((KernelHandle)this.usedKernels.stream().filter(k -> k.getId().equals(id)).findFirst().orElse(null));
    }

    public static interface KernelHandle {
        public void start() throws Exception;

        public String getId();

        public void sentence();

        public void killWithoutMercy() throws IOException, InterruptedException;

        public void ping() throws Exception;

        public boolean isSentenced();

        public void checkHealthAtEnd() throws Exception;

        public void acquire(String var1, AuthCtx var2, String var3);

        public void release();
    }

    public static interface KernelManagerConfig {
        public int getTargetMinFreeKernels();

        public int getMaxFreeKernels();

        public int getPoolCheckInterval();

        public int getPoolStartWait();

        public boolean canReuseKernels();
    }

    public class PoolReturnerThread
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DSSKernelManagerBase.this.logger.info((Object)("Starting " + DSSKernelManagerBase.this.processType + " returner thread"));
            while (!DSSKernelManagerBase.this.stop.get()) {
                try {
                    KernelHandle kernel = (KernelHandle)DSSKernelManagerBase.this.returnedKernels.take();
                    try {
                        if (kernel.isSentenced()) {
                            throw new Exception("No need to return " + DSSKernelManagerBase.this.processType + ", it was sentenced");
                        }
                        kernel.checkHealthAtEnd();
                        int maxFreeKernels = DSSKernelManagerBase.this.config.getMaxFreeKernels();
                        DSSKernelManagerBase dSSKernelManagerBase = DSSKernelManagerBase.this;
                        synchronized (dSSKernelManagerBase) {
                            if (DSSKernelManagerBase.this.freeKernels.size() >= maxFreeKernels) {
                                throw new Exception("Already enough free " + DSSKernelManagerBase.this.processType + "s " + DSSKernelManagerBase.this.freeKernels.size() + " >= " + maxFreeKernels + ")");
                            }
                            DSSMetrics.registry().meter(DSSKernelManagerBase.this.metricsPrefix + ".keptReturnedKernels").mark();
                            DSSKernelManagerBase.this.freeKernels.add(kernel);
                            DSSKernelManagerBase.this.logger.debugV(DSSKernelManagerBase.this.processType + " " + kernel.getId() + " is in good shape, returning it to pool (now free=%d)", new Object[]{DSSKernelManagerBase.this.freeKernels.size()});
                        }
                    }
                    catch (Exception ex) {
                        DSSMetrics.registry().meter(DSSKernelManagerBase.this.metricsPrefix + ".unkeptReturnedKernels").mark();
                        DSSKernelManagerBase.this.logger.info((Object)(DSSKernelManagerBase.this.processType + " " + kernel.getId() + " has ceased to be useful."), (Throwable)ex);
                        DSSKernelManagerBase.this.destroyKernel(kernel);
                    }
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                    DSSKernelManagerBase.this.logger.warn((Object)"Failed to get a kernel to return", (Throwable)e1);
                }
            }
        }
    }

    public class PoolMaintainerThread
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int start = DSSKernelManagerBase.this.config.getPoolStartWait();
            DKUtils.unsafeSleep((long)start);
            int checkInterval = DSSKernelManagerBase.this.config.getPoolCheckInterval();
            DSSKernelManagerBase.this.logger.info((Object)("Starting " + DSSKernelManagerBase.this.processType + " pool thread"));
            while (!DSSKernelManagerBase.this.stop.get()) {
                int poolSize = DSSKernelManagerBase.this.config.getTargetMinFreeKernels();
                int currentFreeSize = 0;
                DSSKernelManagerBase dSSKernelManagerBase = DSSKernelManagerBase.this;
                synchronized (dSSKernelManagerBase) {
                    currentFreeSize = DSSKernelManagerBase.this.freeKernels.size();
                }
                if (currentFreeSize >= poolSize) {
                    DKUtils.unsafeSleep((long)checkInterval);
                    continue;
                }
                try {
                    DSSKernelManagerBase.this.logger.info((Object)String.format("Background thread creating new kernel ( %d / %d )", currentFreeSize + 1, poolSize));
                    DSSMetrics.registry().meter(DSSKernelManagerBase.this.metricsPrefix + ".backgroundThreadKernelCreated").mark();
                    Object createdKernel = DSSKernelManagerBase.this.newKernel();
                    DSSKernelManagerBase dSSKernelManagerBase2 = DSSKernelManagerBase.this;
                    synchronized (dSSKernelManagerBase2) {
                        DSSKernelManagerBase.this.freeKernels.add(createdKernel);
                    }
                }
                catch (Throwable t) {
                    DSSKernelManagerBase.this.logger.error((Object)"Failed to create new kernel", t);
                    DKUtils.unsafeSleep((long)checkInterval);
                }
            }
        }
    }
}

