/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.common.server.DKUControllerBase;
import com.dataiku.dip.reports.IReflectedEventsService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.controllers.DkuJsonForSpring;
import com.dataiku.dip.utils.JSON;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractGenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class RequestResponseBodyJsonConverter
extends AbstractGenericHttpMessageConverter<Object> {
    public RequestResponseBodyJsonConverter() {
        this.setDefaultCharset(StandardCharsets.UTF_8);
        this.setSupportedMediaTypes(Arrays.asList(MediaType.APPLICATION_JSON, MediaType.APPLICATION_OCTET_STREAM));
    }

    protected boolean supports(Class<?> clazz) {
        return DkuJsonForSpring.isJsonifiable(clazz);
    }

    public boolean canRead(Type type, Class<?> contextClass, MediaType mediaType) {
        return DkuJsonForSpring.isJsonifiable(type) && this.canRead(mediaType);
    }

    public Object read(Type type, Class<?> contextClass, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        try (InputStream inputStream = inputMessage.getBody();){
            Object object = this.parseRequestBody(inputStream, type);
            return object;
        }
    }

    protected Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        return this.read(clazz, null, inputMessage);
    }

    protected void writeInternal(Object o, Type type, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        OutputStream outputStream = outputMessage.getBody();
        try {
            JSON.json((Object)o, (OutputStream)outputStream);
        }
        catch (IllegalArgumentException e) {
            IReflectedEventsService.ReflectedEvent event = new IReflectedEventsService.ReflectedEvent(e.getMessage(), e);
            SpringUtils.getBean(IReflectedEventsService.class).publish(event);
            throw e;
        }
    }

    private Object parseRequestBody(InputStream inputStream, Type type) {
        Object object;
        TypeToken gsonType = TypeToken.get((Type)type);
        try {
            object = JSON.parse((InputStream)inputStream, (TypeToken)gsonType);
        }
        catch (Exception e) {
            String cause = String.format("Could not parse a %s from request body", type.getTypeName());
            throw new DKUControllerBase.MalformedRequestException(cause, e);
        }
        if (object == null) {
            String cause = String.format("Could not parse a %s from request body", type.getTypeName());
            throw new DKUControllerBase.MalformedRequestException(cause);
        }
        return object;
    }
}

