/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud;

import com.dataiku.dip.server.SpringUtils;
import com.dataiku.fm.cloud.CloudCredentialsTestServiceInterface;
import com.dataiku.fm.cloud.CloudCryptoService;
import com.dataiku.fm.cloud.aws.AWSCredentialsTestService;
import com.dataiku.fm.cloud.azure.AzureCredentialsTestService;
import com.dataiku.fm.cloud.gcp.GCPCredentialsTestService;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.published.CloudAccountDTO;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.server.FMApp;
import javax.annotation.PostConstruct;

public class CloudCredentialsTestService
implements CloudCredentialsTestServiceInterface {
    private CloudCredentialsTestServiceInterface adapter;

    @PostConstruct
    public void init() {
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        switch (settings.cloud) {
            case AWS: {
                this.adapter = new AWSCredentialsTestService();
                break;
            }
            case AZURE: {
                this.adapter = new AzureCredentialsTestService();
                break;
            }
            case GCP: {
                this.adapter = new GCPCredentialsTestService();
            }
        }
        SpringUtils.getInstance().autowire((Object)this.adapter);
    }

    @Override
    public void testCredentials(Tenant tenant, CloudAccountDTO credentials, CloudCryptoService cloudCryptoService) throws Exception {
        this.adapter.testCredentials(tenant, credentials, cloudCryptoService);
    }
}

