/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud;

import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.fm.cloud.CloudLoadBalancerServiceInterface;
import com.dataiku.fm.cloud.aws.AWSCloudLoadBalancerService;
import com.dataiku.fm.cloud.azure.AzureCloudLoadBalancerService;
import com.dataiku.fm.cloud.gcp.GCPCloudLoadBalancerService;
import com.dataiku.fm.model.db.LoadBalancerNodeMapping;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.LogicalLoadBalancer;
import com.dataiku.fm.model.db.PhysicalLoadBalancer;
import com.dataiku.fm.model.published.LoadBalancerPhysicalStatus;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.db.DatabaseAccessService;
import javax.annotation.PostConstruct;

public class CloudLoadBalancerService
implements CloudLoadBalancerServiceInterface {
    private CloudLoadBalancerServiceInterface adapter;

    @PostConstruct
    public void init() {
        this.adapter = CloudLoadBalancerService.createAdapter();
        SpringUtils.getInstance().autowire((Object)this.adapter);
    }

    @Override
    public PhysicalLoadBalancer createPhysicalLoadBalancer(LogicalLoadBalancer lb, DatabaseAccessService.ReadWriteTransaction rwt, DKUtils.SmartLogTailBuilder smartLogTail) throws InterruptedException {
        return this.adapter.createPhysicalLoadBalancer(lb, rwt, smartLogTail);
    }

    @Override
    public boolean deletePhysicalLoadBalancer(LogicalLoadBalancer lb, DatabaseAccessService.ReadWriteTransaction rwt, DKUtils.SmartLogTailBuilder smartLogTail) throws InterruptedException {
        return this.adapter.deletePhysicalLoadBalancer(lb, rwt, smartLogTail);
    }

    @Override
    public void updatePhysicalLoadBalancer(LogicalLoadBalancer lb, DatabaseAccessService.ReadWriteTransaction rwt, DKUtils.SmartLogTailBuilder smartLogTail, PhysicalLoadBalancer physicalLoadBalancer) throws InterruptedException {
        this.adapter.updatePhysicalLoadBalancer(lb, rwt, smartLogTail, physicalLoadBalancer);
    }

    @Override
    public LoadBalancerPhysicalStatus getPhysicalLoadBalancerStatus(LogicalLoadBalancer loadBalancer) {
        return this.adapter.getPhysicalLoadBalancerStatus(loadBalancer);
    }

    @Override
    public void onInstancePhysicalStateChange(DatabaseAccessService.ReadWriteTransaction rwt, LogicalLoadBalancer currentLoadBalancer, LogicalInstance logicalInstance) {
        this.adapter.onInstancePhysicalStateChange(rwt, currentLoadBalancer, logicalInstance);
    }

    @Override
    public boolean isLoadBalancerNodeMappingProvisioned(LogicalLoadBalancer loadBalancer, LoadBalancerNodeMapping node) {
        return this.adapter.isLoadBalancerNodeMappingProvisioned(loadBalancer, node);
    }

    @Override
    public void onInstanceDeleteEvent(DatabaseAccessService.ReadWriteTransaction rwt, LogicalLoadBalancer loadBalancer, LoadBalancerNodeMapping nodeMapping, LogicalInstance logicalInstance) {
        this.adapter.onInstanceDeleteEvent(rwt, loadBalancer, nodeMapping, logicalInstance);
    }

    @Override
    public String getLoadBalancerLink(LogicalLoadBalancer loadBalancer) {
        return this.adapter.getLoadBalancerLink(loadBalancer);
    }

    private static CloudLoadBalancerServiceInterface createAdapter() {
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        switch (settings.cloud) {
            case AWS: {
                return new AWSCloudLoadBalancerService();
            }
            case AZURE: {
                return new AzureCloudLoadBalancerService();
            }
            case GCP: {
                return new GCPCloudLoadBalancerService();
            }
        }
        throw new IllegalStateException("Invalid cloud type: " + String.valueOf((Object)settings.cloud));
    }
}

