/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud.aws;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.acm.model.DescribeCertificateResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.acm.model.DomainValidation;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2Client;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.Action;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionTypeEnum;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.Certificate;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.CertificateNotFoundException;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateListenerRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateListenerResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateLoadBalancerRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateLoadBalancerResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateRuleRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateRuleResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTargetGroupRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTargetGroupResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteListenerRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteLoadBalancerRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteRuleRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteTargetGroupRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.DeregisterTargetsRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.FixedResponseActionConfig;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.ForwardActionConfig;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.Listener;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.ListenerNotFoundException;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancer;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerNotFoundException;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerSchemeEnum;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerStateEnum;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyListenerRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupAttributesRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.RegisterTargetsRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.Rule;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleCondition;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleNotFoundException;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetDescription;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroup;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupAttribute;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupIpAddressTypeEnum;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupNotFoundException;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupStickinessConfig;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupTuple;
import com.dataiku.fm.cloud.CloudCryptoService;
import com.dataiku.fm.cloud.CloudLoadBalancerServiceInterface;
import com.dataiku.fm.cloud.DNSservice;
import com.dataiku.fm.cloud.LoadBalancerUtils;
import com.dataiku.fm.cloud.aws.AWSCertificateService;
import com.dataiku.fm.cloud.aws.AWSClientService;
import com.dataiku.fm.cloud.aws.AWSDNSService;
import com.dataiku.fm.cloud.aws.AWSLBUtils;
import com.dataiku.fm.cloud.aws.AWSUtils;
import com.dataiku.fm.model.db.AWSLoadBalancerRule;
import com.dataiku.fm.model.db.AWSLoadBalancerTargetGroup;
import com.dataiku.fm.model.db.CertificateMode;
import com.dataiku.fm.model.db.LoadBalancerNodeMapping;
import com.dataiku.fm.model.db.LoadBalancerPublicIPMode;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.LogicalLoadBalancer;
import com.dataiku.fm.model.db.PhysicalDNSRecord;
import com.dataiku.fm.model.db.PhysicalInstance;
import com.dataiku.fm.model.db.PhysicalLoadBalancer;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.model.published.LoadBalancerDTO;
import com.dataiku.fm.model.published.LoadBalancerPhysicalStatus;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.instances.InstancesCRUDService;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import org.apache.log4j.Priority;
import org.springframework.beans.factory.annotation.Autowired;

public class AWSCloudLoadBalancerService
implements CloudLoadBalancerServiceInterface {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.cloud.lb.aws");
    public static final String AWS_LB_PROVISIONING_STATE_CODE = "provisioning";
    public static final String AWS_LB_ACTIVE_STATE_CODE = "active";
    public static final String CERTIFICATE_STATUS_ISSUED = "ISSUED";
    public static final String CERTIFICATE_STATUS_PENDING = "PENDING_VALIDATION";
    @Autowired
    private AWSClientService awsClientService;
    @Autowired
    private InstancesCRUDService instancesCRUDService;
    @Autowired
    private AWSDNSService awsdnsService;
    @Autowired
    private DatabaseAccessService dbService;
    @Autowired
    private AWSCertificateService certificateService;
    @Autowired
    private CloudCryptoService cloudCryptoService;

    @Override
    public PhysicalLoadBalancer createPhysicalLoadBalancer(LogicalLoadBalancer lb, DatabaseAccessService.ReadWriteTransaction rwt, DKUtils.SmartLogTailBuilder smartLogTail) throws InterruptedException {
        AWSCloudLoadBalancerService.validateConfigurationSanity(lb);
        ElasticLoadBalancingV2Client ec2 = this.awsClientService.getElasticLoadBalancingClient(AWSUtils.buildAWSAccount(lb.getVirtualNetwork(), this.cloudCryptoService));
        AWSCloudLoadBalancerService.validateConfigurationSanity(lb);
        try (FutureProgress.AutocloseableFutureProgressState globalState = FutureProgress.pushAutoCloseableState((String)"Creating AWS load balancer", (double)5.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            CreateLoadBalancerResponse awsLoadBalancerResponse;
            PhysicalLoadBalancer physicalLoadBalancer = new PhysicalLoadBalancer();
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement preparingStep = FutureProgress.pushAutoCloseableState((String)"Preparing Load balancer creation", (double)1.0);){
                physicalLoadBalancer.setId("plb-" + SecretKeyGenerator.generate((int)12));
                physicalLoadBalancer.setLogicalLoadBalancer(lb);
                lb.setCurrentPhysicalLoadBalancer(physicalLoadBalancer);
                rwt.getThreadEM().persist((Object)physicalLoadBalancer);
                rwt.getThreadEM().persist((Object)lb);
            }
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement createLBStep = FutureProgress.pushAutoCloseableState((String)"Creating Load balancer", (double)1.0);){
                smartLogTail.appendLine("Initiating the creation of load balancer '" + lb.getName() + "' on AWS", logger, Priority.INFO);
                awsLoadBalancerResponse = ec2.createLoadBalancer((CreateLoadBalancerRequest)CreateLoadBalancerRequest.builder().name(physicalLoadBalancer.getId()).scheme(lb.getPublicIpMode() == LoadBalancerPublicIPMode.NO_PUBLIC_IP ? LoadBalancerSchemeEnum.INTERNAL : LoadBalancerSchemeEnum.INTERNET_FACING).subnets(new String[]{lb.getVirtualNetwork().getAwsSubnetId(), lb.getVirtualNetwork().getAwsSecondSubnetId()}).securityGroups(lb.getVirtualNetwork().getAwsSecurityGroups().split(",")).tags(AWSLBUtils.getLoadBalancerTagsForResource(lb, lb.getName())).build());
            }
            LoadBalancer awsLoadBalancer = (LoadBalancer)awsLoadBalancerResponse.loadBalancers().get(0);
            physicalLoadBalancer.setAwsLoadBalancerARN(awsLoadBalancer.loadBalancerArn());
            smartLogTail.appendLine("Successfully created load balancer '" + lb.getName() + "' on AWS. ARN: '" + physicalLoadBalancer.getAwsLoadBalancerARN() + "'", logger, Priority.INFO);
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement listenerStep = FutureProgress.pushAutoCloseableState((String)"Creating Load balancer listener", (double)1.0);){
                this.createLoadBalancerListener(lb, smartLogTail, ec2, physicalLoadBalancer, awsLoadBalancer);
            }
            listenerStep = FutureProgress.pushAutoCloseableState((String)"Creating Load balancer rules and targets", (double)1.0);
            try {
                this.createLoadBalancerRulesAndTarget(lb, smartLogTail, ec2, physicalLoadBalancer);
            }
            finally {
                if (listenerStep != null) {
                    listenerStep.close();
                }
            }
            listenerStep = FutureProgress.pushAutoCloseableState((String)"Creating Load balancer dns records", (double)1.0);
            try {
                this.createLoadBalancerDNSRecords(lb, smartLogTail, awsLoadBalancer);
            }
            finally {
                if (listenerStep != null) {
                    listenerStep.close();
                }
            }
            smartLogTail.appendLine("Load balancer configuration completed successfully", logger, Priority.INFO);
            PhysicalLoadBalancer physicalLoadBalancer2 = physicalLoadBalancer;
            return physicalLoadBalancer2;
        }
    }

    @Override
    public boolean deletePhysicalLoadBalancer(LogicalLoadBalancer lb, DatabaseAccessService.ReadWriteTransaction rwt, DKUtils.SmartLogTailBuilder smartLogTail) throws InterruptedException {
        ElasticLoadBalancingV2Client ec2 = this.awsClientService.getElasticLoadBalancingClient(AWSUtils.buildAWSAccount(lb.getVirtualNetwork(), this.cloudCryptoService));
        PhysicalLoadBalancer physicalLoadBalancer = lb.getCurrentPhysicalLoadBalancer();
        if (physicalLoadBalancer == null) {
            return true;
        }
        try (FutureProgress.AutocloseableFutureProgressState globalState = FutureProgress.pushAutoCloseableState((String)"Deleting AWS load balancer", (double)6.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement rulesStep = FutureProgress.pushAutoCloseableState((String)"Deleting AWS Load balancer rules", (double)1.0);){
                AWSCloudLoadBalancerService.deleteLoadBalancerRules(rwt, smartLogTail, ec2, physicalLoadBalancer);
            }
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement targetsStep = FutureProgress.pushAutoCloseableState((String)"Deleting AWS Load balancer targets", (double)1.0);){
                AWSCloudLoadBalancerService.deleteLoadBalancerTargets(rwt, smartLogTail, ec2, physicalLoadBalancer);
            }
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement listenerStep = FutureProgress.pushAutoCloseableState((String)"Deleting AWS Load balancer listener", (double)1.0);){
                AWSCloudLoadBalancerService.deleteLoadBalancerListener(smartLogTail, ec2, physicalLoadBalancer);
            }
            String awsLoadBalancerARN = physicalLoadBalancer.getAwsLoadBalancerARN();
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement lbStep = FutureProgress.pushAutoCloseableState((String)"Deleting AWS Load balancer", (double)1.0);){
                if (awsLoadBalancerARN != null) {
                    AWSCloudLoadBalancerService.deletePhysicalLoadBalancer(smartLogTail, ec2, awsLoadBalancerARN, physicalLoadBalancer);
                }
            }
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement certificateStep = FutureProgress.pushAutoCloseableState((String)"Deleting AWS Load balancer certificate", (double)1.0);){
                this.deleteLoadBalancerManagedCertificate(lb, smartLogTail, ec2, awsLoadBalancerARN);
            }
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement dnsRecordsStep = FutureProgress.pushAutoCloseableState((String)"Deleting AWS Load balancer dns records", (double)1.0);){
                this.deleteLoadBalancerDNSRecords(lb, smartLogTail);
            }
        }
        return true;
    }

    @Override
    public void updatePhysicalLoadBalancer(LogicalLoadBalancer lb, DatabaseAccessService.ReadWriteTransaction rwt, DKUtils.SmartLogTailBuilder smartLogTail, @Nonnull PhysicalLoadBalancer physicalLoadBalancer) throws InterruptedException {
        AWSCloudLoadBalancerService.validateConfigurationSanity(lb);
        try (FutureProgress.AutocloseableFutureProgressState globalState = FutureProgress.pushAutoCloseableState((String)"Updating AWS load balancer", (double)5.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            Optional<String> certificateARNToDeleteOptional;
            ElasticLoadBalancingV2Client ec2 = this.awsClientService.getElasticLoadBalancingClient(AWSUtils.buildAWSAccount(lb.getVirtualNetwork(), this.cloudCryptoService));
            logger.info((Object)("Updating load balancer '" + lb.getName() + "'"));
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement certificateStep = FutureProgress.pushAutoCloseableState((String)"Updating AWS Load balancer certificate", (double)1.0);){
                certificateARNToDeleteOptional = lb.getCertificateMode() == CertificateMode.AWS_CERTIFICATE_MANAGER ? this.updateLoadBalancerManagedCertificate(lb, smartLogTail) : Optional.ofNullable(lb.getAwsManagedCertificateARN());
            }
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement listenerStep = FutureProgress.pushAutoCloseableState((String)"Updating AWS Load balancer listener", (double)1.0);){
                AWSCloudLoadBalancerService.updateLoadBalancerListener(lb, smartLogTail, ec2, physicalLoadBalancer);
            }
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement targetsStep = FutureProgress.pushAutoCloseableState((String)"Updating AWS Load balancer targets and rules", (double)1.0);){
                this.updateLoadBalancerTargetsAndRules(lb, rwt, smartLogTail, ec2, physicalLoadBalancer);
            }
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement dnsRecordsStep = FutureProgress.pushAutoCloseableState((String)"Updating AWS Load balancer dns records", (double)1.0);){
                this.updateLoadBalancerDNSRecords(lb, smartLogTail, ec2, physicalLoadBalancer);
            }
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement managedCertStep = FutureProgress.pushAutoCloseableState((String)"Deleting managed certificate", (double)1.0);){
                certificateARNToDeleteOptional.ifPresent(certificateARNToDelete -> {
                    smartLogTail.appendLine("Removing old managed certificate", logger, Priority.INFO);
                    this.certificateService.deleteCertificate(lb.getVirtualNetwork(), (String)certificateARNToDelete, lb.getAwsManagedCertificateARN(), smartLogTail);
                    smartLogTail.appendLine("Successfully deleted old managed certificate", logger, Priority.INFO);
                });
            }
        }
    }

    @Override
    public LoadBalancerPhysicalStatus getPhysicalLoadBalancerStatus(LogicalLoadBalancer loadBalancer) {
        LoadBalancerPhysicalStatus loadBalancerPhysicalStatus = new LoadBalancerPhysicalStatus();
        PhysicalLoadBalancer currentPhysicalLoadBalancer = loadBalancer.getCurrentPhysicalLoadBalancer();
        loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.PROVISIONED);
        if (currentPhysicalLoadBalancer == null || currentPhysicalLoadBalancer.getAwsLoadBalancerARN() == null) {
            loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_REPROVISIONING);
            loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_NOT_PROVISIONED, "");
        } else if (currentPhysicalLoadBalancer.getAwsListenerARN() == null) {
            loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_REPROVISIONING);
            loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_LISTENER_NOT_PROVISIONED, "");
        } else {
            String regionId = loadBalancer.getVirtualNetwork().getAwsRegion();
            loadBalancerPhysicalStatus.loadBalancerLink = this.getLoadBalancerLink(loadBalancer);
            ElasticLoadBalancingV2Client ec2 = this.awsClientService.getElasticLoadBalancingClient(AWSUtils.buildAWSAccount(loadBalancer.getVirtualNetwork(), this.cloudCryptoService));
            try {
                DescribeLoadBalancersResponse describeLoadBalancersResponse = ec2.describeLoadBalancers((DescribeLoadBalancersRequest)DescribeLoadBalancersRequest.builder().loadBalancerArns(new String[]{currentPhysicalLoadBalancer.getAwsLoadBalancerARN()}).build());
                LoadBalancer awsLoadBalancer = (LoadBalancer)describeLoadBalancersResponse.loadBalancers().get(0);
                LoadBalancerStateEnum awsLoadBalancerState = awsLoadBalancer.state().code();
                if (awsLoadBalancerState == LoadBalancerStateEnum.PROVISIONING) {
                    loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.PROVISIONING);
                    loadBalancerPhysicalStatus.infoMessages.withInfo((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_PROVISIONING, "");
                } else if (awsLoadBalancerState == LoadBalancerStateEnum.ACTIVE) {
                    LoadBalancerSchemeEnum loadBalancerScheme;
                    if (!Objects.equals(awsLoadBalancer.vpcId(), loadBalancer.getVirtualNetwork().getAwsVpcId())) {
                        loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_REPROVISIONING);
                        loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_WRONG_NETWORK, "Load balancer is in VPC '" + awsLoadBalancer.vpcId() + "' instead of expected VPC '" + loadBalancer.getVirtualNetwork().getAwsVpcId() + "'");
                    }
                    LoadBalancerSchemeEnum loadBalancerSchemeEnum = loadBalancerScheme = loadBalancer.getPublicIpMode() == LoadBalancerPublicIPMode.NO_PUBLIC_IP ? LoadBalancerSchemeEnum.INTERNAL : LoadBalancerSchemeEnum.INTERNET_FACING;
                    if (loadBalancerScheme != awsLoadBalancer.scheme()) {
                        loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_REPROVISIONING);
                        loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_SCHEME_NOT_ALIGNED, "");
                    }
                    this.checkLoadBalancerListenerStatus(loadBalancer, loadBalancerPhysicalStatus, currentPhysicalLoadBalancer, ec2);
                    this.checkLoadBalancerTargetStatus(loadBalancer, loadBalancerPhysicalStatus, currentPhysicalLoadBalancer, regionId, ec2);
                    this.checkLoadBalancerRulesStatus(loadBalancer, loadBalancerPhysicalStatus, currentPhysicalLoadBalancer, regionId, ec2);
                    this.checkLoadBalancerDNSStatus(loadBalancer, loadBalancerPhysicalStatus, awsLoadBalancer);
                }
            }
            catch (LoadBalancerNotFoundException e) {
                loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_REPROVISIONING);
                loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_DELETED_IN_CLOUD, "AWS Load balancer '" + currentPhysicalLoadBalancer.getAwsLoadBalancerARN() + "' not found.");
            }
        }
        List<LoadBalancerNodeMapping> inactiveNodes = loadBalancer.getLoadBalancerNodeMapping().stream().filter(nodeMapping -> nodeMapping.getStatus() == LoadBalancerNodeMapping.Status.INACTIVE).toList();
        if (!inactiveNodes.isEmpty()) {
            loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
            loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.LB_NODES_UPDATED_NODE_MAPPING_NEED_REPROVISIONING, "The following node mappings are inactive but still associated to cloud resources: " + inactiveNodes.stream().map(n -> n.getSubdomainOrFQDN() + " \u2192 " + n.getLogicalInstance().getLabel()).collect(Collectors.joining(",")));
        }
        return loadBalancerPhysicalStatus;
    }

    @Override
    public void onInstancePhysicalStateChange(DatabaseAccessService.ReadWriteTransaction rwt, LogicalLoadBalancer currentLoadBalancer, LogicalInstance logicalInstance) {
        PhysicalLoadBalancer physicalLoadBalancer = currentLoadBalancer.getCurrentPhysicalLoadBalancer();
        if (physicalLoadBalancer != null) {
            logger.info((Object)("Instance '" + logicalInstance.getLabel() + "' physical state has changed, updating LB."));
            ElasticLoadBalancingV2Client ec2 = this.awsClientService.getElasticLoadBalancingClient(AWSUtils.buildAWSAccount(currentLoadBalancer.getVirtualNetwork(), this.cloudCryptoService));
            Set<LoadBalancerNodeMapping> nodes = currentLoadBalancer.getLoadBalancerNodeMapping();
            LoadBalancerNodeMapping nodeMapping = nodes.stream().filter(e -> e.getLogicalInstance().getId().equals(logicalInstance.getId())).findAny().orElseThrow(() -> new IllegalArgumentException("Load balancer '" + currentLoadBalancer.getName() + "' doesn't have a node mapping for instance '" + logicalInstance.getLabel() + "'"));
            this.updateLoadBalancerTargetsAndRulesForHostname(currentLoadBalancer, rwt, new DKUtils.SmartLogTailBuilder(), ec2, nodeMapping.getSubdomainOrFQDN(), currentLoadBalancer.getLoadBalancerActiveNodeMappingsPerSubdomainOrFQDN().get(nodeMapping.getSubdomainOrFQDN()), physicalLoadBalancer);
        }
    }

    @Override
    public boolean isLoadBalancerNodeMappingProvisioned(LogicalLoadBalancer loadBalancer, LoadBalancerNodeMapping node) {
        if (loadBalancer.getCurrentPhysicalLoadBalancer() == null) {
            return false;
        }
        return loadBalancer.getCurrentPhysicalLoadBalancer().getTargetGroupsByNodeMapping().containsKey(node) || loadBalancer.getCurrentPhysicalLoadBalancer().getRulesByNodeMapping().containsKey(node);
    }

    @Override
    public void onInstanceDeleteEvent(DatabaseAccessService.ReadWriteTransaction rwt, LogicalLoadBalancer loadBalancer, LoadBalancerNodeMapping nodeMapping, LogicalInstance logicalInstance) {
        PhysicalLoadBalancer physicalLoadBalancer = loadBalancer.getCurrentPhysicalLoadBalancer();
        if (physicalLoadBalancer != null) {
            logger.info((Object)("Instance '" + logicalInstance.getLabel() + "' mapping was provisioned in load balancer '" + loadBalancer.getName() + "'"));
            ElasticLoadBalancingV2Client awsLoadBalancer = this.awsClientService.getElasticLoadBalancingClient(AWSUtils.buildAWSAccount(loadBalancer.getVirtualNetwork(), this.cloudCryptoService));
            AWSLoadBalancerTargetGroup targetGroup = physicalLoadBalancer.getTargetGroupsByNodeMapping().get(nodeMapping);
            if (targetGroup != null) {
                targetGroup.getLoadBalancerNodeMappings().remove(nodeMapping);
                if (targetGroup.getLoadBalancerNodeMappings().isEmpty()) {
                    logger.info((Object)("Deleting target group '" + targetGroup.getArn() + "'"));
                    awsLoadBalancer.deleteTargetGroup((DeleteTargetGroupRequest)DeleteTargetGroupRequest.builder().targetGroupArn(targetGroup.getArn()).build());
                    physicalLoadBalancer.getTargetGroups().remove(targetGroup);
                    rwt.getThreadEM().remove((Object)targetGroup);
                    AWSLoadBalancerRule rule = physicalLoadBalancer.getRulesByNodeMapping().get(nodeMapping);
                    if (rule != null) {
                        logger.info((Object)("Deleting rule '" + rule.getArn() + "'"));
                        awsLoadBalancer.deleteRule((DeleteRuleRequest)DeleteRuleRequest.builder().ruleArn(rule.getArn()).build());
                        physicalLoadBalancer.getRules().remove(rule);
                        rwt.getThreadEM().remove((Object)rule);
                        logger.info((Object)("Rule '" + rule.getArn() + "' deleted."));
                    } else {
                        logger.warn((Object)"Couldn't find a rule corresponding to this node mapping.");
                    }
                }
            } else {
                logger.warn((Object)"Couldn't find a target group corresponding to this node mapping.");
            }
        }
    }

    @Override
    public String getLoadBalancerLink(LogicalLoadBalancer loadBalancer) {
        if (loadBalancer.getCurrentPhysicalLoadBalancer() == null) {
            return "";
        }
        String regionId = loadBalancer.getVirtualNetwork().getAwsRegion();
        return "https://" + regionId + ".console.aws.amazon.com/ec2/home?region=" + regionId + "#LoadBalancer:loadBalancerArn=" + loadBalancer.getCurrentPhysicalLoadBalancer().getAwsLoadBalancerARN();
    }

    private void createLoadBalancerDNSRecords(LogicalLoadBalancer lb, DKUtils.SmartLogTailBuilder smartLogTail, LoadBalancer awsLoadBalancer) {
        if (this.awsdnsService.hasDNSManaged(lb.getVirtualNetwork())) {
            smartLogTail.appendLine("Initiating DNS record creation...", logger, Priority.INFO);
            DNSservice.ZoneType zoneType = lb.getPublicIpMode() == LoadBalancerPublicIPMode.NO_PUBLIC_IP ? DNSservice.ZoneType.PRIVATE : DNSservice.ZoneType.PUBLIC;
            Map<String, Set<LoadBalancerNodeMapping>> nodeMappingsPerSubdomainOrFQDN = lb.getLoadBalancerActiveNodeMappingsPerSubdomainOrFQDN();
            for (String subdomainOrFQDN : nodeMappingsPerSubdomainOrFQDN.keySet()) {
                this.awsdnsService.addDNSCNAMERecords(lb.getVirtualNetwork(), zoneType, LoadBalancerUtils.getFQDN(subdomainOrFQDN, lb, this.awsdnsService), awsLoadBalancer.dnsName()).ifPresent(physicalDNSRecord -> ((Set)nodeMappingsPerSubdomainOrFQDN.get(subdomainOrFQDN)).forEach(nodeMapping -> nodeMapping.setPublicPhysicalDNSRecord((PhysicalDNSRecord)physicalDNSRecord)));
            }
            smartLogTail.replaceLastLine("DNS record created successfully", logger, Priority.INFO);
        }
    }

    private void createLoadBalancerRulesAndTarget(LogicalLoadBalancer lb, DKUtils.SmartLogTailBuilder smartLogTail, ElasticLoadBalancingV2Client ec2, @Nonnull PhysicalLoadBalancer physicalLoadBalancer) {
        smartLogTail.appendLine("Configuring target groups and associated rules", logger, Priority.INFO);
        Map<String, Set<LoadBalancerNodeMapping>> nodeMappingsPerSubdomainOrFQDN = lb.getLoadBalancerActiveNodeMappingsPerSubdomainOrFQDN();
        for (String subdomainOrFQDN : nodeMappingsPerSubdomainOrFQDN.keySet()) {
            Set<LoadBalancerNodeMapping> nodeMappings = nodeMappingsPerSubdomainOrFQDN.get(subdomainOrFQDN);
            this.createRuleAndTargetGroup(lb, smartLogTail, ec2, subdomainOrFQDN, nodeMappings, physicalLoadBalancer);
        }
    }

    private void createRuleAndTargetGroup(LogicalLoadBalancer lb, DKUtils.SmartLogTailBuilder smartLogTail, ElasticLoadBalancingV2Client ec2, String subdomainOrFQDN, Set<LoadBalancerNodeMapping> nodeMappings, @Nonnull PhysicalLoadBalancer physicalLoadBalancer) {
        Set<PhysicalInstance> physicalInstances = nodeMappings.stream().filter(LoadBalancerNodeMapping::isInstanceProvisioned).map(nodeMapping -> nodeMapping.getLogicalInstance().getCurrentPhysicalInstance()).collect(Collectors.toSet());
        if (!physicalInstances.isEmpty()) {
            smartLogTail.appendLine("Creating target group for '" + subdomainOrFQDN + "'...", logger, Priority.INFO);
            AWSLoadBalancerTargetGroup targetGroup = AWSCloudLoadBalancerService.createTargetGroup(lb, ec2, physicalLoadBalancer, nodeMappings, physicalInstances);
            smartLogTail.replaceLastLine("Target group successfully created with ARN: " + targetGroup.getArn(), logger, Priority.INFO);
            smartLogTail.appendLine("Setting up load balancer rule for '" + subdomainOrFQDN + "'...", logger, Priority.INFO);
            int order = physicalLoadBalancer.getRules().stream().map(AWSLoadBalancerRule::getRuleOrder).max(Integer::compareTo).orElse(0) + 1;
            AWSLoadBalancerRule rule = this.createRule(ec2, lb, subdomainOrFQDN, targetGroup, order++, physicalLoadBalancer);
            smartLogTail.replaceLastLine("Successfully created new load balancer rule with ARN: " + rule.getArn(), logger, Priority.INFO);
        }
    }

    private static AWSLoadBalancerTargetGroup createTargetGroup(LogicalLoadBalancer lb, ElasticLoadBalancingV2Client ec2, PhysicalLoadBalancer physicalLoadBalancer, Set<LoadBalancerNodeMapping> nodeMappings, Set<PhysicalInstance> physicalInstances) {
        int backendPort = lb.getVirtualNetwork().getHttpsStrategy() == VirtualNetwork.HTTPSStrategy.NONE ? 80 : 443;
        ProtocolEnum proto = lb.getVirtualNetwork().getHttpsStrategy() == VirtualNetwork.HTTPSStrategy.NONE ? ProtocolEnum.HTTP : ProtocolEnum.HTTPS;
        CreateTargetGroupResponse awsTargetGroup = ec2.createTargetGroup((CreateTargetGroupRequest)CreateTargetGroupRequest.builder().name("tg-" + SecretKeyGenerator.generate((int)12)).protocol(proto).port(Integer.valueOf(backendPort)).vpcId(lb.getVirtualNetwork().getAwsVpcId()).ipAddressType(TargetGroupIpAddressTypeEnum.IPV4).tags(AWSLBUtils.getLoadBalancerTagsForResource(lb, lb.getName())).build());
        String targetGroupArn = ((TargetGroup)awsTargetGroup.targetGroups().get(0)).targetGroupArn();
        ec2.modifyTargetGroupAttributes((ModifyTargetGroupAttributesRequest)ModifyTargetGroupAttributesRequest.builder().targetGroupArn(targetGroupArn).attributes(new TargetGroupAttribute[]{(TargetGroupAttribute)TargetGroupAttribute.builder().key("stickiness.enabled").value("true").build(), (TargetGroupAttribute)TargetGroupAttribute.builder().key("stickiness.type").value("lb_cookie").build()}).build());
        Set targets = physicalInstances.stream().map(instance -> (TargetDescription)TargetDescription.builder().id(instance.getAwsEC2InstanceId()).build()).collect(Collectors.toSet());
        if (!targets.isEmpty()) {
            ec2.registerTargets((RegisterTargetsRequest)RegisterTargetsRequest.builder().targetGroupArn(targetGroupArn).targets(targets).build());
        }
        AWSLoadBalancerTargetGroup fmTargetGroup = new AWSLoadBalancerTargetGroup(targetGroupArn, nodeMappings, physicalLoadBalancer);
        fmTargetGroup.setLoadBalancerNodeMappings(nodeMappings);
        physicalLoadBalancer.addTargetGroup(fmTargetGroup);
        return fmTargetGroup;
    }

    private String issueCertificate(LogicalLoadBalancer loadBalancer, DKUtils.SmartLogTailBuilder smartLogTail) {
        return this.certificateService.issueCertificate(loadBalancer.getName(), loadBalancer.getVirtualNetwork(), this.resolveFQDNsForCertificate(loadBalancer), loadBalancer.getCloudApplicableTags(FMApp.getFMSettingsUnsafe()), smartLogTail);
    }

    private Optional<String> issueCertificate(LogicalLoadBalancer loadBalancer, DKUtils.SmartLogTailBuilder smartLogTail, String oldCertificateARN) {
        return this.certificateService.issueCertificate(loadBalancer.getName(), loadBalancer.getVirtualNetwork(), this.resolveFQDNsForCertificate(loadBalancer), loadBalancer.getCloudApplicableTags(FMApp.getFMSettingsUnsafe()), smartLogTail, oldCertificateARN);
    }

    private Set<String> resolveFQDNsForCertificate(LogicalLoadBalancer loadBalancer) {
        return loadBalancer.getLoadBalancerNodeMapping().stream().filter(loadBalancerNodeMapping -> loadBalancerNodeMapping.getStatus().equals((Object)LoadBalancerNodeMapping.Status.ACTIVE)).map(LoadBalancerNodeMapping::getSubdomainOrFQDN).map(subdomainOrFQDN -> LoadBalancerUtils.getFQDN(subdomainOrFQDN, loadBalancer, this.awsdnsService)).collect(Collectors.toSet());
    }

    private void createLoadBalancerListener(LogicalLoadBalancer lb, DKUtils.SmartLogTailBuilder smartLogTail, ElasticLoadBalancingV2Client ec2, PhysicalLoadBalancer physicalLoadBalancer, LoadBalancer awsLoadBalancer) {
        smartLogTail.appendLine("Setting up listener for load balancer '" + lb.getName() + "'", logger, Priority.INFO);
        Action defaultAction = AWSCloudLoadBalancerService.getDefaultAction();
        CreateListenerResponse listener = switch (lb.getCertificateMode()) {
            case CertificateMode.AWS_CERTIFICATE_MANAGER -> {
                lb.setAwsManagedCertificateARN(this.issueCertificate(lb, smartLogTail));
                yield ec2.createListener((CreateListenerRequest)CreateListenerRequest.builder().loadBalancerArn(awsLoadBalancer.loadBalancerArn()).certificates(new Certificate[]{(Certificate)Certificate.builder().certificateArn(lb.getAwsManagedCertificateARN()).build()}).defaultActions(new Action[]{defaultAction}).protocol(ProtocolEnum.HTTPS).port(Integer.valueOf(443)).tags(AWSLBUtils.getLoadBalancerTagsForResource(lb, lb.getName())).build());
            }
            case CertificateMode.AWS_ARN -> ec2.createListener((CreateListenerRequest)CreateListenerRequest.builder().loadBalancerArn(awsLoadBalancer.loadBalancerArn()).certificates(new Certificate[]{(Certificate)Certificate.builder().certificateArn(lb.getAwsCertificateARN()).build()}).defaultActions(new Action[]{defaultAction}).protocol(ProtocolEnum.HTTPS).port(Integer.valueOf(443)).tags(AWSLBUtils.getLoadBalancerTagsForResource(lb, lb.getName())).build());
            default -> ec2.createListener((CreateListenerRequest)CreateListenerRequest.builder().loadBalancerArn(awsLoadBalancer.loadBalancerArn()).defaultActions(new Action[]{defaultAction}).protocol(ProtocolEnum.HTTP).port(Integer.valueOf(80)).tags(AWSLBUtils.getLoadBalancerTagsForResource(lb, lb.getName())).build());
        };
        physicalLoadBalancer.setAwsListenerARN(((Listener)listener.listeners().get(0)).listenerArn());
        smartLogTail.replaceLastLine("Listener successfully created on AWS for load balancer. ARN: '" + physicalLoadBalancer.getAwsListenerARN() + "'", logger, Priority.INFO);
    }

    private void deleteLoadBalancerDNSRecords(LogicalLoadBalancer lb, DKUtils.SmartLogTailBuilder smartLogTail) {
        if (this.awsdnsService.hasDNSManaged(lb.getVirtualNetwork())) {
            smartLogTail.appendLine("Removing DNS records", logger, Priority.INFO);
            for (LoadBalancerNodeMapping nodeMapping : lb.getLoadBalancerNodeMapping()) {
                String dnsRecordName = LoadBalancerUtils.getFQDN(nodeMapping.getSubdomainOrFQDN(), lb, this.awsdnsService);
                smartLogTail.appendLine("Removing DNS record '" + dnsRecordName + "' ...", logger, Priority.INFO);
                this.awsdnsService.removeDNSRecord(lb.getVirtualNetwork(), nodeMapping.getPublicPhysicalDNSRecord());
                if (nodeMapping.getPublicPhysicalDNSRecord() != null) {
                    this.dbService.getThreadEM().remove((Object)nodeMapping.getPublicPhysicalDNSRecord());
                    nodeMapping.setPublicPhysicalDNSRecord(null);
                    smartLogTail.replaceLastLine("DNS record '" + dnsRecordName + "' successfully deleted", logger, Priority.INFO);
                    continue;
                }
                smartLogTail.replaceLastLine("DNS record '" + dnsRecordName + "' already deleted", logger, Priority.INFO);
            }
            smartLogTail.appendLine("All DNS records have been successfully removed", logger, Priority.INFO);
        }
    }

    private void deleteLoadBalancerManagedCertificate(LogicalLoadBalancer lb, DKUtils.SmartLogTailBuilder smartLogTail, ElasticLoadBalancingV2Client ec2, String awsLoadBalancerARN) {
        if (lb.getAwsManagedCertificateARN() != null) {
            boolean isLBDeleted = false;
            smartLogTail.appendLine("Deleting load balance '" + awsLoadBalancerARN + "'...", logger, Priority.INFO);
            for (int count = 0; !isLBDeleted && count <= 12; ++count) {
                try {
                    DescribeLoadBalancersResponse describeLoadBalancersResponse = ec2.describeLoadBalancers((DescribeLoadBalancersRequest)DescribeLoadBalancersRequest.builder().loadBalancerArns(new String[]{awsLoadBalancerARN}).build());
                    isLBDeleted = describeLoadBalancersResponse.loadBalancers().isEmpty();
                }
                catch (LoadBalancerNotFoundException e) {
                    isLBDeleted = true;
                }
                if (isLBDeleted) continue;
                smartLogTail.replaceLastLine("Load balancer deletion still pending on AWS. Waiting..." + IntStream.range(0, count).mapToObj(i -> ".").collect(Collectors.joining()), logger, Priority.INFO);
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException e) {
                    logger.error((Object)"Couldn't wait for load balancer to be deleted.", (Throwable)e);
                    throw new IllegalStateException("Couldn't wait for load balancer to be deleted.", e);
                }
            }
            if (!isLBDeleted) {
                smartLogTail.appendLine("Load balance '" + awsLoadBalancerARN + "' is not yet deleted even after waiting 1 min", logger, Priority.ERROR);
                throw new IllegalStateException("Load balancer is not yet deleted even after waiting 1 min. Once the load balancer is deleted in AWS, try de-provisioning the load balancer again to destroy the remaining resources.");
            }
            smartLogTail.replaceLastLine("Load balance '" + awsLoadBalancerARN + "' deleted", logger, Priority.INFO);
            this.deleteManagedCertificate(lb, lb.getAwsManagedCertificateARN(), smartLogTail);
        }
    }

    private static void deletePhysicalLoadBalancer(DKUtils.SmartLogTailBuilder smartLogTail, ElasticLoadBalancingV2Client ec2, String awsLoadBalancerARN, @Nonnull PhysicalLoadBalancer physicalLoadBalancer) {
        smartLogTail.appendLine("Removing load balancer '" + awsLoadBalancerARN + "'...", logger, Priority.INFO);
        try {
            ec2.deleteLoadBalancer((DeleteLoadBalancerRequest)DeleteLoadBalancerRequest.builder().loadBalancerArn(awsLoadBalancerARN).build());
        }
        catch (LoadBalancerNotFoundException e) {
            logger.warnV((Throwable)e, "Load balancer %s does not exist in AWS console", new Object[]{awsLoadBalancerARN});
        }
        physicalLoadBalancer.setAwsLoadBalancerARN(null);
        smartLogTail.replaceLastLine("Successfully removed load balancer '" + awsLoadBalancerARN + "'", logger, Priority.INFO);
    }

    private static void deleteLoadBalancerListener(DKUtils.SmartLogTailBuilder smartLogTail, ElasticLoadBalancingV2Client ec2, PhysicalLoadBalancer physicalLoadBalancer) {
        String awsListenerARN = physicalLoadBalancer.getAwsListenerARN();
        if (awsListenerARN != null) {
            smartLogTail.appendLine("Removing listener '" + awsListenerARN + "'...", logger, Priority.INFO);
            try {
                ec2.deleteListener((DeleteListenerRequest)DeleteListenerRequest.builder().listenerArn(awsListenerARN).build());
            }
            catch (ListenerNotFoundException e) {
                logger.warnV((Throwable)e, "Listener %s does not exist in AWS console", new Object[]{awsListenerARN});
            }
            physicalLoadBalancer.setAwsListenerARN(null);
            smartLogTail.replaceLastLine("Listener '" + awsListenerARN + "' successfully removed", logger, Priority.INFO);
        }
    }

    private static void deleteLoadBalancerTargets(DatabaseAccessService.ReadWriteTransaction rwt, DKUtils.SmartLogTailBuilder smartLogTail, ElasticLoadBalancingV2Client ec2, PhysicalLoadBalancer physicalLoadBalancer) {
        physicalLoadBalancer.getTargetGroups().removeIf(t -> {
            String arn = t.getArn();
            smartLogTail.appendLine("Deleting target group '" + arn + "'...", logger, Priority.INFO);
            ec2.deleteTargetGroup((DeleteTargetGroupRequest)DeleteTargetGroupRequest.builder().targetGroupArn(arn).build());
            smartLogTail.replaceLastLine("Target group '" + arn + "' deleted", logger, Priority.INFO);
            rwt.getThreadEM().remove(t);
            return true;
        });
    }

    private static void deleteLoadBalancerRules(DatabaseAccessService.ReadWriteTransaction rwt, DKUtils.SmartLogTailBuilder smartLogTail, ElasticLoadBalancingV2Client ec2, PhysicalLoadBalancer physicalLoadBalancer) {
        physicalLoadBalancer.getRules().removeIf(r -> {
            String arn = r.getArn();
            smartLogTail.appendLine("Deleting rule '" + arn + "'...", logger, Priority.INFO);
            ec2.deleteRule((DeleteRuleRequest)DeleteRuleRequest.builder().ruleArn(arn).build());
            smartLogTail.replaceLastLine("Rule '" + arn + "' deleted", logger, Priority.INFO);
            rwt.getThreadEM().remove(r);
            return true;
        });
    }

    private void deleteManagedCertificate(LogicalLoadBalancer lb, @Nonnull String certificateARN, DKUtils.SmartLogTailBuilder smartLogTail) {
        this.certificateService.deleteCertificate(lb.getVirtualNetwork(), certificateARN, null, smartLogTail);
        lb.setAwsManagedCertificateARN(null);
    }

    private void updateLoadBalancerDNSRecords(LogicalLoadBalancer lb, DKUtils.SmartLogTailBuilder smartLogTail, ElasticLoadBalancingV2Client ec2, @Nonnull PhysicalLoadBalancer physicalLoadBalancer) {
        if (this.awsdnsService.hasDNSManaged(lb.getVirtualNetwork())) {
            smartLogTail.appendLine("Updating DNS record...", logger, Priority.INFO);
            DescribeLoadBalancersResponse describeLoadBalancersResponse = ec2.describeLoadBalancers((DescribeLoadBalancersRequest)DescribeLoadBalancersRequest.builder().loadBalancerArns(new String[]{physicalLoadBalancer.getAwsLoadBalancerARN()}).build());
            LoadBalancer awsLoadBalancer = (LoadBalancer)describeLoadBalancersResponse.loadBalancers().get(0);
            Map<String, Set<LoadBalancerNodeMapping>> nodeMappingsPerSubdomainOrFQDN = lb.getLoadBalancerActiveNodeMappingsPerSubdomainOrFQDN();
            lb.getLoadBalancerNodeMapping().stream().filter(nodeMapping -> nodeMapping.getStatus() == LoadBalancerNodeMapping.Status.INACTIVE).filter(nodeMapping -> !nodeMappingsPerSubdomainOrFQDN.containsKey(nodeMapping.getSubdomainOrFQDN())).forEach(nodeMapping -> this.awsdnsService.removeDNSRecord(lb.getVirtualNetwork(), nodeMapping.getPublicPhysicalDNSRecord()));
            for (String subdomainOrFQDN : nodeMappingsPerSubdomainOrFQDN.keySet()) {
                DNSservice.ZoneType zoneType = lb.getPublicIpMode() == LoadBalancerPublicIPMode.NO_PUBLIC_IP ? DNSservice.ZoneType.PRIVATE : DNSservice.ZoneType.PUBLIC;
                Set<LoadBalancerNodeMapping> nodeMappings = nodeMappingsPerSubdomainOrFQDN.get(subdomainOrFQDN);
                PhysicalDNSRecord publicPhysicalDNSRecord = nodeMappings.iterator().next().getPublicPhysicalDNSRecord();
                String mappedFQDN = LoadBalancerUtils.getFQDN(subdomainOrFQDN, lb, this.awsdnsService);
                if (publicPhysicalDNSRecord != null) {
                    this.dbService.getThreadEM().remove((Object)publicPhysicalDNSRecord);
                    this.awsdnsService.updateDNSCNAMERecords(lb.getVirtualNetwork(), zoneType, publicPhysicalDNSRecord, mappedFQDN, awsLoadBalancer.dnsName()).ifPresent(physicalDNSRecord -> nodeMappings.forEach(nodeMapping -> nodeMapping.setPublicPhysicalDNSRecord((PhysicalDNSRecord)physicalDNSRecord)));
                    continue;
                }
                this.awsdnsService.addDNSCNAMERecords(lb.getVirtualNetwork(), zoneType, mappedFQDN, awsLoadBalancer.dnsName()).ifPresent(physicalDNSRecord -> nodeMappings.forEach(nodeMapping -> nodeMapping.setPublicPhysicalDNSRecord((PhysicalDNSRecord)physicalDNSRecord)));
            }
            smartLogTail.replaceLastLine("DNS record updated", logger, Priority.INFO);
        }
    }

    private void updateLoadBalancerTargetsAndRules(LogicalLoadBalancer lb, DatabaseAccessService.ReadWriteTransaction rwt, DKUtils.SmartLogTailBuilder smartLogTail, ElasticLoadBalancingV2Client ec2, @Nonnull PhysicalLoadBalancer physicalLoadBalancer) {
        smartLogTail.appendLine("Updating target groups and rules", logger, Priority.INFO);
        Map<String, Set<LoadBalancerNodeMapping>> nodeMappingsPerSubdomainOrFQDN = lb.getLoadBalancerActiveNodeMappingsPerSubdomainOrFQDN();
        for (AWSLoadBalancerRule rule : this.listRules(physicalLoadBalancer)) {
            if (nodeMappingsPerSubdomainOrFQDN.containsKey(rule.getHostname())) continue;
            this.deleteRuleAndTargetGroup(lb, rwt, smartLogTail, ec2, rule.getHostname(), rule, physicalLoadBalancer);
        }
        for (String subdomainOrFQDN : nodeMappingsPerSubdomainOrFQDN.keySet()) {
            this.updateLoadBalancerTargetsAndRulesForHostname(lb, rwt, smartLogTail, ec2, subdomainOrFQDN, nodeMappingsPerSubdomainOrFQDN.get(subdomainOrFQDN), physicalLoadBalancer);
        }
        smartLogTail.appendLine("Target groups and rules updated", logger, Priority.INFO);
    }

    private AWSLoadBalancerRule getRule(PhysicalLoadBalancer physicalLoadBalancer, String hostname) {
        return this.dbService.getSingleResult(AWSLoadBalancerRule.class, "SELECT rule from awsloadbalancerrule rule where rule.physicalLoadBalancer=?1 and rule.hostname=?2", physicalLoadBalancer, hostname);
    }

    private List<AWSLoadBalancerRule> listRules(PhysicalLoadBalancer physicalLoadBalancer) {
        return this.dbService.listResults(AWSLoadBalancerRule.class, "SELECT rule from awsloadbalancerrule rule where rule.physicalLoadBalancer=?1", physicalLoadBalancer);
    }

    private void updateLoadBalancerTargetsAndRulesForHostname(LogicalLoadBalancer lb, DatabaseAccessService.ReadWriteTransaction rwt, DKUtils.SmartLogTailBuilder smartLogTail, ElasticLoadBalancingV2Client ec2, String subdomainOrFQDN, Set<LoadBalancerNodeMapping> nodeMappings, @Nonnull PhysicalLoadBalancer physicalLoadBalancer) {
        assert (nodeMappings.stream().allMatch(nm -> Objects.equals(nm.getSubdomainOrFQDN(), subdomainOrFQDN)));
        AWSLoadBalancerRule rule = this.getRule(physicalLoadBalancer, subdomainOrFQDN);
        boolean hasTargets = nodeMappings.stream().anyMatch(LoadBalancerNodeMapping::isInstanceProvisioned);
        if (rule == null) {
            if (hasTargets) {
                this.createRuleAndTargetGroup(lb, smartLogTail, ec2, subdomainOrFQDN, nodeMappings, physicalLoadBalancer);
            }
        } else if (hasTargets) {
            AWSCloudLoadBalancerService.updateTargetGroup(smartLogTail, ec2, subdomainOrFQDN, nodeMappings, rule);
        } else {
            this.deleteRuleAndTargetGroup(lb, rwt, smartLogTail, ec2, subdomainOrFQDN, rule, physicalLoadBalancer);
        }
    }

    private void deleteRuleAndTargetGroup(LogicalLoadBalancer lb, DatabaseAccessService.ReadWriteTransaction rwt, DKUtils.SmartLogTailBuilder smartLogTail, ElasticLoadBalancingV2Client ec2, String hostname, AWSLoadBalancerRule rule, @Nonnull PhysicalLoadBalancer physicalLoadBalancer) {
        if (this.checkRuleExist(lb, rule.getArn())) {
            smartLogTail.appendLine("Deleting rule for '" + hostname + "'...", logger, Priority.INFO);
            ec2.deleteRule((DeleteRuleRequest)DeleteRuleRequest.builder().ruleArn(rule.getArn()).build());
            smartLogTail.replaceLastLine("Rule for '" + hostname + "' deleted", logger, Priority.INFO);
        }
        physicalLoadBalancer.getRules().remove(rule);
        rwt.getThreadEM().remove((Object)rule);
        AWSLoadBalancerTargetGroup targetGroup = rule.getTargetGroup();
        if (this.checkTargetGroupExist(lb, targetGroup.getArn())) {
            smartLogTail.appendLine("Deleting target group for '" + hostname + "'...", logger, Priority.INFO);
            ec2.deleteTargetGroup((DeleteTargetGroupRequest)DeleteTargetGroupRequest.builder().targetGroupArn(targetGroup.getArn()).build());
            smartLogTail.replaceLastLine("Target group for '" + hostname + "' deleted", logger, Priority.INFO);
        }
        targetGroup.getLoadBalancerNodeMappings().clear();
        physicalLoadBalancer.getTargetGroups().remove(targetGroup);
        rwt.getThreadEM().remove((Object)targetGroup);
    }

    private static void updateTargetGroup(DKUtils.SmartLogTailBuilder smartLogTail, ElasticLoadBalancingV2Client ec2, String hostname, Set<LoadBalancerNodeMapping> nodeMappings, AWSLoadBalancerRule rule) {
        Set targetsBefore = ec2.describeTargetHealth((DescribeTargetHealthRequest)DescribeTargetHealthRequest.builder().targetGroupArn(rule.getTargetGroup().getArn()).build()).targetHealthDescriptions().stream().map(targetHealthDescription -> targetHealthDescription.target().id()).collect(Collectors.toSet());
        Set targetsAfter = nodeMappings.stream().filter(LoadBalancerNodeMapping::isInstanceProvisioned).map(nodeMapping -> nodeMapping.getLogicalInstance().getCurrentPhysicalInstance().getAwsEC2InstanceId()).collect(Collectors.toSet());
        HashSet targetsToRemove = new HashSet(targetsBefore);
        targetsToRemove.removeAll(targetsAfter);
        HashSet targetsToAdd = new HashSet(targetsAfter);
        targetsToAdd.removeAll(targetsBefore);
        if (!targetsToRemove.isEmpty()) {
            smartLogTail.appendLine("Removing targets for '" + hostname + "'...", logger, Priority.INFO);
            ec2.deregisterTargets((DeregisterTargetsRequest)DeregisterTargetsRequest.builder().targetGroupArn(rule.getTargetGroup().getArn()).targets((Collection)targetsToRemove.stream().map(id -> (TargetDescription)TargetDescription.builder().id(id).build()).collect(Collectors.toSet())).build());
            smartLogTail.replaceLastLine("Targets successfully removed for '" + hostname + "'...", logger, Priority.INFO);
        }
        if (!targetsToAdd.isEmpty()) {
            smartLogTail.appendLine("Adding targets for '" + hostname + "'...", logger, Priority.INFO);
            ec2.registerTargets((RegisterTargetsRequest)RegisterTargetsRequest.builder().targetGroupArn(rule.getTargetGroup().getArn()).targets((Collection)targetsToAdd.stream().map(id -> (TargetDescription)TargetDescription.builder().id(id).build()).collect(Collectors.toSet())).build());
            smartLogTail.replaceLastLine("Targets successfully added for '" + hostname + "'...", logger, Priority.INFO);
        }
        rule.getTargetGroup().setLoadBalancerNodeMappings(nodeMappings.stream().filter(LoadBalancerNodeMapping::isInstanceProvisioned).collect(Collectors.toSet()));
    }

    private static void updateLoadBalancerListener(LogicalLoadBalancer lb, DKUtils.SmartLogTailBuilder smartLogTail, ElasticLoadBalancingV2Client ec2, @Nonnull PhysicalLoadBalancer physicalLoadBalancer) {
        smartLogTail.appendLine("Updating listener", logger, Priority.INFO);
        Action defaultAction = AWSCloudLoadBalancerService.getDefaultAction();
        switch (lb.getCertificateMode()) {
            case AWS_CERTIFICATE_MANAGER: {
                ec2.modifyListener((ModifyListenerRequest)ModifyListenerRequest.builder().listenerArn(physicalLoadBalancer.getAwsListenerARN()).defaultActions(new Action[]{defaultAction}).protocol(ProtocolEnum.HTTPS).port(Integer.valueOf(443)).certificates(new Certificate[]{(Certificate)Certificate.builder().certificateArn(lb.getAwsManagedCertificateARN()).build()}).build());
                break;
            }
            case AWS_ARN: {
                ec2.modifyListener((ModifyListenerRequest)ModifyListenerRequest.builder().listenerArn(physicalLoadBalancer.getAwsListenerARN()).defaultActions(new Action[]{defaultAction}).protocol(ProtocolEnum.HTTPS).port(Integer.valueOf(443)).certificates(new Certificate[]{(Certificate)Certificate.builder().certificateArn(lb.getAwsCertificateARN()).build()}).build());
                break;
            }
            default: {
                ec2.modifyListener((ModifyListenerRequest)ModifyListenerRequest.builder().listenerArn(physicalLoadBalancer.getAwsListenerARN()).defaultActions(new Action[]{defaultAction}).protocol(ProtocolEnum.HTTP).port(Integer.valueOf(80)).build());
            }
        }
        smartLogTail.replaceLastLine("Listener updated", logger, Priority.INFO);
    }

    private Optional<String> updateLoadBalancerManagedCertificate(LogicalLoadBalancer lb, DKUtils.SmartLogTailBuilder smartLogTail) {
        if (lb.getAwsManagedCertificateARN() == null) {
            lb.setAwsManagedCertificateARN(this.issueCertificate(lb, smartLogTail));
            return Optional.empty();
        }
        String oldCertificateARN = lb.getAwsManagedCertificateARN();
        return this.issueCertificate(lb, smartLogTail, oldCertificateARN).map(newCertificateARN -> {
            lb.setAwsManagedCertificateARN((String)newCertificateARN);
            return oldCertificateARN;
        });
    }

    private void checkLoadBalancerDNSStatus(LogicalLoadBalancer loadBalancer, LoadBalancerPhysicalStatus loadBalancerPhysicalStatus, LoadBalancer awsLoadBalancer) {
        if (loadBalancer.getVirtualNetwork().getDnsStrategy() != VirtualNetwork.DNSStrategy.NONE) {
            List<String> subdomainList = loadBalancer.getLoadBalancerNodeMapping().stream().map(LoadBalancerNodeMapping::getSubdomainOrFQDN).distinct().toList();
            for (String subdomain : subdomainList) {
                try {
                    DNSservice.ZoneType zoneType = loadBalancer.getPublicIpMode() == LoadBalancerPublicIPMode.NO_PUBLIC_IP ? DNSservice.ZoneType.PRIVATE : DNSservice.ZoneType.PUBLIC;
                    Optional<String> dnsRecord = this.awsdnsService.getDNSRecordValueForSubdomain(loadBalancer.getVirtualNetwork(), subdomain, zoneType, DNSservice.RecordType.CNAME);
                    if (dnsRecord.isPresent()) {
                        if (dnsRecord.get().equals(awsLoadBalancer.dnsName())) continue;
                        loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                        loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_WRONG_DNS_RECORD, "DNS record  '" + subdomain + "' = '" + dnsRecord.get() + "' not matching Load balancing DNS '" + awsLoadBalancer.dnsName() + "'.");
                        continue;
                    }
                    loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                    loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_MISSING_DNS_RECORD, "DNS record  '" + subdomain + "' not found.");
                }
                catch (Exception e) {
                    loadBalancerPhysicalStatus.infoMessages.withError((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_API_ERROR, "Could not compute status of DNS record '" + subdomain + "': " + e.getMessage());
                }
            }
        }
    }

    private void checkLoadBalancerRulesStatus(LogicalLoadBalancer loadBalancer, LoadBalancerPhysicalStatus loadBalancerPhysicalStatus, PhysicalLoadBalancer currentPhysicalLoadBalancer, String regionId, ElasticLoadBalancingV2Client ec2) {
        for (AWSLoadBalancerRule rule : currentPhysicalLoadBalancer.getRules()) {
            try {
                DescribeRulesResponse describeRulesResponse = ec2.describeRules((DescribeRulesRequest)DescribeRulesRequest.builder().ruleArns(new String[]{rule.getArn()}).build());
                Rule awsLoadBalancerRule = (Rule)describeRulesResponse.rules().get(0);
                if (awsLoadBalancerRule.conditions().isEmpty()) {
                    loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                    loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_MISSING_CLOUD_RULES, "Rule '" + rule.getArn() + "' doesn't contain any hostnames conditions.");
                } else if (!((RuleCondition)awsLoadBalancerRule.conditions().get(0)).hostHeaderConfig().values().contains(LoadBalancerUtils.getFQDN(rule.getHostname(), loadBalancer, this.awsdnsService))) {
                    loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                    loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_MISSING_CLOUD_RULES, "Rule '" + rule.getArn() + "' doesn't contain the hostname '" + rule.getHostname() + "' condition but has the following hostname conditions: " + String.join((CharSequence)", ", ((RuleCondition)awsLoadBalancerRule.conditions().get(0)).hostHeaderConfig().values()));
                }
                String ruleLink = this.buildLoadBalancerRuleLink(regionId, awsLoadBalancerRule);
                rule.getLoadBalancerNodeMappings().forEach(nodeMapping -> loadBalancerPhysicalStatus.awsRoutingRuleLinks.put(nodeMapping.getLogicalInstance().getId(), ruleLink));
            }
            catch (RuleNotFoundException e) {
                loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_MISSING_CLOUD_RULES, "Rule '" + rule.getArn() + "' not found.");
            }
            catch (Exception e) {
                loadBalancerPhysicalStatus.infoMessages.withError((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_API_ERROR, "Could not compute status of rule '" + rule.getArn() + "': " + e.getMessage());
            }
        }
        Set logicalLBHostnames = loadBalancer.getLoadBalancerNodeMapping().stream().filter(LoadBalancerNodeMapping::isInstanceProvisioned).map(LoadBalancerNodeMapping::getSubdomainOrFQDN).collect(Collectors.toSet());
        Set localRulesHostnames = currentPhysicalLoadBalancer.getRules().stream().map(AWSLoadBalancerRule::getHostname).collect(Collectors.toSet());
        HashSet newRulesToCreate = new HashSet(logicalLBHostnames);
        newRulesToCreate.removeAll(localRulesHostnames);
        if (!newRulesToCreate.isEmpty()) {
            loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
            loadBalancerPhysicalStatus.infoMessages.withWarningV((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_MISSING_RULES, "Missing rules for hostnames [%s]", new Object[]{String.join((CharSequence)", ", newRulesToCreate)});
        }
        HashSet rulesToDelete = new HashSet(localRulesHostnames);
        rulesToDelete.removeAll(logicalLBHostnames);
        if (!rulesToDelete.isEmpty()) {
            loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
            loadBalancerPhysicalStatus.infoMessages.withWarningV((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_ORPHANED_RULES, "Rules for hostnames [%s] are unused", new Object[]{String.join((CharSequence)", ", rulesToDelete)});
        }
    }

    private void checkLoadBalancerTargetStatus(LogicalLoadBalancer loadBalancer, LoadBalancerPhysicalStatus loadBalancerPhysicalStatus, PhysicalLoadBalancer currentPhysicalLoadBalancer, String regionId, ElasticLoadBalancingV2Client ec2) {
        for (AWSLoadBalancerTargetGroup targetGroup : currentPhysicalLoadBalancer.getTargetGroups()) {
            try {
                DescribeTargetGroupsResponse describeTargetGroupResult = ec2.describeTargetGroups((DescribeTargetGroupsRequest)DescribeTargetGroupsRequest.builder().targetGroupArns(new String[]{targetGroup.getArn()}).build());
                TargetGroup awsTargetGroup = (TargetGroup)describeTargetGroupResult.targetGroups().get(0);
                targetGroup.getLoadBalancerNodeMappings().stream().map(node -> node.getLogicalInstance().getId()).forEach(instanceId -> loadBalancerPhysicalStatus.awsTargetGroupLinks.put((String)instanceId, this.buildLoadBalancerTargetGroupLink(regionId, awsTargetGroup)));
            }
            catch (TargetGroupNotFoundException e) {
                loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_MISSING_CLOUD_TARGET_GROUP, "Target group '" + targetGroup.getArn() + "' not found.");
            }
            catch (Exception e) {
                loadBalancerPhysicalStatus.infoMessages.withError((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_API_ERROR, "Could not compute status of target group '" + targetGroup.getArn() + "': " + e.getMessage());
            }
        }
        Map hostnameToProvisionedInstances = loadBalancer.getLoadBalancerNodeMapping().stream().filter(LoadBalancerNodeMapping::isInstanceProvisioned).collect(HashMap::new, (map, mapping) -> map.computeIfAbsent(mapping.getSubdomainOrFQDN(), k -> new HashSet()).add(mapping.getLogicalInstance().getLabel()), HashMap::putAll);
        Map<String, Set> hostnameToTarget = currentPhysicalLoadBalancer.getRules().stream().collect(Collectors.toMap(AWSLoadBalancerRule::getHostname, rule -> rule.getLoadBalancerNodeMappings().stream().filter(LoadBalancerNodeMapping::isInstanceProvisioned).map(mapping -> mapping.getLogicalInstance().getLabel()).collect(Collectors.toSet())));
        for (Map.Entry entry : hostnameToProvisionedInstances.entrySet()) {
            if (!hostnameToTarget.containsKey(entry.getKey())) continue;
            Set cloudTargets = hostnameToTarget.get(entry.getKey());
            HashSet targetsToAdd = new HashSet((Collection)entry.getValue());
            targetsToAdd.removeAll(cloudTargets);
            if (!targetsToAdd.isEmpty()) {
                loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                loadBalancerPhysicalStatus.infoMessages.withWarningV((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_MISSING_CLOUD_TARGET_GROUP, "Rule for hostname '%s' is missing targets [%s].", new Object[]{entry.getKey(), String.join((CharSequence)", ", targetsToAdd)});
            }
            HashSet targetsToRemove = new HashSet(cloudTargets);
            targetsToRemove.removeAll((Collection)entry.getValue());
            if (targetsToRemove.isEmpty()) continue;
            loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
            loadBalancerPhysicalStatus.infoMessages.withWarningV((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_ORPHANED_TARGET, "Rule for hostname '%s' contains orphaned targets [%s].", new Object[]{entry.getKey(), String.join((CharSequence)", ", targetsToRemove)});
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkLoadBalancerListenerStatus(LogicalLoadBalancer loadBalancer, LoadBalancerPhysicalStatus loadBalancerPhysicalStatus, PhysicalLoadBalancer currentPhysicalLoadBalancer, ElasticLoadBalancingV2Client ec2) {
        try {
            DescribeListenersResponse describeListenersResponse = ec2.describeListeners((DescribeListenersRequest)DescribeListenersRequest.builder().listenerArns(new String[]{currentPhysicalLoadBalancer.getAwsListenerARN()}).build());
            Listener listener = (Listener)describeListenersResponse.listeners().get(0);
            switch (loadBalancer.getCertificateMode()) {
                case AWS_CERTIFICATE_MANAGER: {
                    this.checkCertificateStatus(loadBalancer.getAwsManagedCertificateARN(), loadBalancerPhysicalStatus, listener);
                    if (loadBalancer.getAwsManagedCertificateARN() == null) {
                        loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                        loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_SSL_NOT_SETUP, "No cloud load balancer managed certificate provisioned in AWS");
                        return;
                    }
                    try {
                        DescribeCertificateResponse describeResult = this.awsClientService.getACMClient(AWSUtils.buildAWSAccount(loadBalancer.getVirtualNetwork(), this.cloudCryptoService)).describeCertificate(loadBalancer.getAwsManagedCertificateARN());
                        HashSet<String> domainsFromCertificate = new HashSet<String>();
                        domainsFromCertificate.add(describeResult.certificate().domainName());
                        domainsFromCertificate.addAll(describeResult.certificate().subjectAlternativeNames());
                        Set domainsExpected = loadBalancer.getLoadBalancerNodeMapping().stream().map(nodeMapping -> LoadBalancerUtils.getFQDN(nodeMapping.getSubdomainOrFQDN(), loadBalancer, this.awsdnsService)).collect(Collectors.toSet());
                        if (!domainsFromCertificate.containsAll(domainsExpected)) {
                            loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                            loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_SSL_NOT_SETUP, "The cloud load balancer managed certificate '" + loadBalancer.getAwsManagedCertificateARN() + "' is missing the domains '" + domainsExpected.stream().filter(d -> !domainsFromCertificate.contains(d)).collect(Collectors.joining("', '")) + "'.");
                            return;
                        }
                        for (DomainValidation domainValidation : describeResult.certificate().domainValidationOptions()) {
                            String validationDomain = domainValidation.resourceRecord().name();
                            Optional<String> dnsRecord = this.awsdnsService.getDNSRecordValue(loadBalancer.getVirtualNetwork(), validationDomain, DNSservice.ZoneType.PUBLIC, DNSservice.RecordType.CNAME);
                            if (!dnsRecord.isEmpty()) continue;
                            loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                            loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_SSL_NOT_SETUP, "The cloud load balancer managed certificate '" + loadBalancer.getAwsManagedCertificateARN() + "' is missing the CNAME record for the validation domain '" + validationDomain + "'.");
                        }
                        return;
                    }
                    catch (CertificateNotFoundException e) {
                        loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                        loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_SSL_NOT_SETUP, "The cloud load balancer managed certificate '" + loadBalancer.getAwsManagedCertificateARN() + "' doesn't exist anymore in AWS");
                        return;
                    }
                }
                case AWS_ARN: {
                    if (loadBalancer.getAwsManagedCertificateARN() != null) {
                        try {
                            this.awsClientService.getACMClient(AWSUtils.buildAWSAccount(loadBalancer.getVirtualNetwork(), this.cloudCryptoService)).describeCertificate(loadBalancer.getAwsManagedCertificateARN());
                            loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                            loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_SSL_SETUP, "The certificate '" + loadBalancer.getAwsManagedCertificateARN() + "', created when the certificate mode was fully managed by FM, still exist in FM and AWS");
                        }
                        catch (CertificateNotFoundException e) {
                            loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                            loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_SSL_SETUP, "The certificate '" + loadBalancer.getAwsManagedCertificateARN() + "', created when the certificate mode was fully managed by FM, still exist in FM");
                        }
                    }
                    this.checkCertificateStatus(loadBalancer.getAwsCertificateARN(), loadBalancerPhysicalStatus, listener);
                    return;
                }
                default: {
                    if (listener.certificates().isEmpty()) return;
                    loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                    loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_SSL_SETUP, "The cloud load balancer has a certificate setup whereas the load balancer settings doesn't have one.");
                }
            }
            return;
        }
        catch (ListenerNotFoundException e) {
            loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_REPROVISIONING);
            loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_MISSING_CLOUD_LISTENER, "Listener '" + currentPhysicalLoadBalancer.getAwsListenerARN() + "' not found.");
            return;
        }
        catch (Exception e) {
            loadBalancerPhysicalStatus.infoMessages.withError((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_API_ERROR, "Could not compute status of listener '" + currentPhysicalLoadBalancer.getAwsListenerARN() + "': " + e.getMessage());
        }
    }

    private void checkCertificateStatus(String certificateARN, LoadBalancerPhysicalStatus loadBalancerPhysicalStatus, Listener listener) {
        if (listener.certificates().isEmpty()) {
            loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
            loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_SSL_NOT_SETUP, "The cloud load balancer hasn't got a certificate setup whereas the load balancer settings has one.");
        } else {
            Optional<Certificate> certificateOptional = listener.certificates().stream().filter(c -> c.certificateArn().equals(certificateARN)).findAny();
            if (certificateOptional.isEmpty()) {
                loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAWSCodes.AWS_LB_SSL_NOT_SETUP, "The cloud load balancer has certificate(s) ( '" + listener.certificates().stream().map(Certificate::certificateArn).collect(Collectors.joining(", ")) + "') but not the one setup in Fleet manager '" + certificateARN + "'.");
            }
        }
    }

    private boolean checkTargetGroupExist(LogicalLoadBalancer lb, String targetGroupARN) {
        ElasticLoadBalancingV2Client ec2 = this.awsClientService.getElasticLoadBalancingClient(AWSUtils.buildAWSAccount(lb.getVirtualNetwork(), this.cloudCryptoService));
        try {
            ec2.describeTargetGroups((DescribeTargetGroupsRequest)DescribeTargetGroupsRequest.builder().targetGroupArns(new String[]{targetGroupARN}).build());
            return true;
        }
        catch (TargetGroupNotFoundException e) {
            return false;
        }
    }

    private boolean checkRuleExist(LogicalLoadBalancer lb, String ruleARN) {
        ElasticLoadBalancingV2Client ec2 = this.awsClientService.getElasticLoadBalancingClient(AWSUtils.buildAWSAccount(lb.getVirtualNetwork(), this.cloudCryptoService));
        try {
            ec2.describeRules((DescribeRulesRequest)DescribeRulesRequest.builder().ruleArns(new String[]{ruleARN}).build());
            return true;
        }
        catch (RuleNotFoundException e) {
            return false;
        }
    }

    private static Action getDefaultAction() {
        return (Action)Action.builder().type(ActionTypeEnum.FIXED_RESPONSE).order(Integer.valueOf(1)).fixedResponseConfig((FixedResponseActionConfig)FixedResponseActionConfig.builder().statusCode("400").contentType("text/plain").messageBody("No available instance matching this hostname or instance not running.").build()).build();
    }

    private AWSLoadBalancerRule createRule(ElasticLoadBalancingV2Client ec2, LogicalLoadBalancer lb, String subdomainOrFQDN, AWSLoadBalancerTargetGroup targetGroup, int order, @Nonnull PhysicalLoadBalancer physicalLoadBalancer) {
        Action action = (Action)Action.builder().type(ActionTypeEnum.FORWARD).targetGroupArn(targetGroup.getArn()).order(Integer.valueOf(1)).forwardConfig((ForwardActionConfig)ForwardActionConfig.builder().targetGroups(new TargetGroupTuple[]{(TargetGroupTuple)TargetGroupTuple.builder().targetGroupArn(targetGroup.getArn()).weight(Integer.valueOf(1)).build()}).targetGroupStickinessConfig((TargetGroupStickinessConfig)TargetGroupStickinessConfig.builder().enabled(Boolean.valueOf(false)).build()).build()).build();
        CreateRuleResponse awsRule = ec2.createRule((CreateRuleRequest)CreateRuleRequest.builder().listenerArn(physicalLoadBalancer.getAwsListenerARN()).priority(Integer.valueOf(order)).tags(AWSLBUtils.getLoadBalancerTagsForResource(lb, lb.getName() + "-" + subdomainOrFQDN)).conditions(new RuleCondition[]{(RuleCondition)RuleCondition.builder().field("host-header").values(new String[]{LoadBalancerUtils.getFQDN(subdomainOrFQDN, lb, this.awsdnsService)}).build()}).actions(new Action[]{action}).build());
        String ruleArn = ((Rule)awsRule.rules().get(0)).ruleArn();
        AWSLoadBalancerRule logicalRule = new AWSLoadBalancerRule(ruleArn, subdomainOrFQDN, targetGroup, physicalLoadBalancer, order);
        physicalLoadBalancer.addRule(logicalRule);
        return logicalRule;
    }

    private String buildLoadBalancerTargetGroupLink(String regionId, TargetGroup awsTargetGroup) {
        return "https://" + regionId + ".console.aws.amazon.com/ec2/home?region=" + regionId + "#TargetGroup:targetGroupArn=" + awsTargetGroup.targetGroupArn();
    }

    private String buildLoadBalancerRuleLink(String regionId, Rule awsLoadBalancerRule) {
        return "https://" + regionId + ".console.aws.amazon.com/ec2/home?region=" + regionId + "#ListenerRuleDetails:ruleArn=" + awsLoadBalancerRule.ruleArn();
    }

    private static void validateConfigurationSanity(LogicalLoadBalancer lb) {
        if (lb.getCertificateMode() == CertificateMode.AWS_CERTIFICATE_MANAGER && lb.getVirtualNetwork().getDnsStrategy() == VirtualNetwork.DNSStrategy.NONE) {
            throw new IllegalStateException("Certificate mode ACM is only supported if a managed DNS is configured on the virtual network.");
        }
        if (lb.getCertificateMode() == CertificateMode.AWS_CERTIFICATE_MANAGER && StringUtils.isBlank((CharSequence)lb.getVirtualNetwork().getAwsRoute53PublicIPZoneId())) {
            throw new IllegalStateException("Load Balancers can't use Certificate Manager if no Zone id for Public IP  is configured in the Virtual Network.");
        }
    }

    public static enum LoadBalancerAWSCodes implements InfoMessage.MessageCode
    {
        AWS_LB_NOT_PROVISIONED("AWS load balancer not provisioned", InfoMessage.FixabilityCategory.IRRELEVANT),
        AWS_LB_LISTENER_NOT_PROVISIONED("AWS load balancer listener not provisioned", InfoMessage.FixabilityCategory.IRRELEVANT),
        AWS_LB_MISSING_RULES("AWS load balancer misses some rules", InfoMessage.FixabilityCategory.IRRELEVANT),
        AWS_LB_MISSING_TARGET_GROUPS("AWS load balancer misses some target groups", InfoMessage.FixabilityCategory.IRRELEVANT),
        AWS_LB_SCHEME_NOT_ALIGNED("AWS load balancer scheme is not aligned", InfoMessage.FixabilityCategory.IRRELEVANT),
        AWS_LB_PROVISIONING("AWS load balancer is provisioning", InfoMessage.FixabilityCategory.IRRELEVANT),
        AWS_LB_DELETED_IN_CLOUD("AWS load balancer has been deleted outside of FM", InfoMessage.FixabilityCategory.IRRELEVANT),
        AWS_LB_MISSING_CLOUD_LISTENER("AWS load balancer does not have any listener in AWS", InfoMessage.FixabilityCategory.IRRELEVANT),
        AWS_LB_MISSING_CLOUD_TARGET_GROUP("AWS load balancer is missing target groups in AWS", InfoMessage.FixabilityCategory.IRRELEVANT),
        AWS_LB_MISSING_CLOUD_RULES("AWS load balancer is missing rules in AWS", InfoMessage.FixabilityCategory.IRRELEVANT),
        AWS_LB_MISSING_DNS_RECORD("AWS load balancer is missing DNS records in AWS", InfoMessage.FixabilityCategory.IRRELEVANT),
        AWS_LB_WRONG_DNS_RECORD("AWS load balancer has wrong DNS records in AWS", InfoMessage.FixabilityCategory.IRRELEVANT),
        LB_NODES_UPDATED_NODE_MAPPING_NEED_REPROVISIONING("Load balancer has some rules which needs to be updated.", InfoMessage.FixabilityCategory.IRRELEVANT),
        AWS_LB_ORPHANED_RULES("AWS load balancer contains orphaned rules", InfoMessage.FixabilityCategory.IRRELEVANT),
        AWS_LB_ORPHANED_TARGET("AWS load balancer rule contains orphaned targets", InfoMessage.FixabilityCategory.IRRELEVANT),
        AWS_LB_WRONG_NETWORK("AWS load balancer is not on the WRONG VPC", InfoMessage.FixabilityCategory.IRRELEVANT),
        AWS_LB_SSL_SETUP("AWS load balancer has SSL setup", InfoMessage.FixabilityCategory.IRRELEVANT),
        AWS_LB_SSL_NOT_SETUP("AWS load balancer has no SSL setup", InfoMessage.FixabilityCategory.IRRELEVANT),
        AWS_LB_API_ERROR("AWS API error", InfoMessage.FixabilityCategory.IRRELEVANT);

        private final String title;
        private final InfoMessage.FixabilityCategory fixability;

        private LoadBalancerAWSCodes(String title, InfoMessage.FixabilityCategory fixability) {
            this.title = title;
            this.fixability = fixability;
        }

        public String getCode() {
            return this.name();
        }

        public String getCodeTitle() {
            return this.title;
        }

        public InfoMessage.FixabilityCategory getFixability() {
            return this.fixability;
        }
    }
}

