/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud.azure;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.exceptions.ExceptionWithLogTail;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.AzureResourceManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.ApiErrorException;
import com.dataiku.fm.cloud.CloudCryptoService;
import com.dataiku.fm.cloud.azure.AzureClientService;
import com.dataiku.fm.model.db.CloudAccount;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.published.CloudTag;
import com.dataiku.fm.model.published.CloudTagList;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.model.settings.FMTenancy;
import com.dataiku.fm.model.settings.InstanceImagesSettings;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.db.DatabaseAccessService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;

public class AzureImageCacheService {
    @Autowired
    private AzureClientService clientService;
    @Autowired
    private CloudCryptoService cryptoService;
    @Autowired
    private DatabaseAccessService dbService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.fm.imagecache");

    private void buildImportCommand(CloudAccount account, boolean sharedGallery, String region, String azureManagedDiskName, String imageCacheResourceGroup, InstanceImagesSettings.AzureInstanceImageReference reference, String azureManagedImageResourceId, ProxySettings proxySettings, DKUtils.SmartLogTailBuilder smartLogTail, String tags) throws IOException, InterruptedException {
        if (smartLogTail != null) {
            smartLogTail.appendLine("Building image: " + azureManagedImageResourceId);
        }
        ArrayList<Object> command = new ArrayList<Object>();
        command.add(DKUApp.getBaseFolder() + "/bin/python");
        command.add(DKUApp.getInstallFolder() + "/scripts/azure-import-vhd-to-managed-image.py");
        command.add("--locations");
        command.add(region);
        command.add("--temporary-disk-name");
        command.add(azureManagedDiskName);
        command.add("--temporary-resource-group");
        command.add(imageCacheResourceGroup);
        if (!StringUtils.isBlank((CharSequence)tags)) {
            command.add("--tags");
            command.add(tags);
        }
        if (account.getAzureManagedIdentityId() != null) {
            String identity = account.getAzureManagedIdentityId();
            command.add("--auth-managed-identity");
            command.add(identity);
            String[] parts = identity.split("/");
            command.add("--subscription");
            command.add(parts[2]);
        } else if (account.getAzureSecret() != null) {
            command.add("--auth-client-id");
            command.add(account.getAzureClientId());
            command.add("--auth-tenant");
            command.add(account.getAzureTenantId());
            command.add("--auth-client-secret");
            command.add(this.cryptoService.decrypt(account.getTenant(), account.getAzureSecret()));
            command.add("--subscription");
            command.add(account.getAzureSubscription());
        } else {
            command.add("--auth-from-fm-config");
            command.add(DKUApp.getBaseFolder() + "/config/user-data.json");
            command.add("--subscription");
            command.add(account.getAzureSubscription());
        }
        if (sharedGallery) {
            command.add("--azure-publisher");
            command.add(reference.azureImageMetadata.publisher);
            command.add("--azure-offer");
            command.add(reference.azureImageMetadata.offer);
            command.add("--azure-sku");
            command.add(reference.azureImageMetadata.SKU);
        }
        command.add(reference.reference);
        command.add(azureManagedImageResourceId);
        if (FMApp.isCloudProxyEnabled() && proxySettings.hasProxy()) {
            command.add("--proxy");
            command.add("http://" + proxySettings.getAsString());
        }
        CharSequence[] importCommand = command.toArray(new String[command.size()]);
        logger.infoV("Run import command: %s", new Object[]{String.join((CharSequence)" ", importCommand)});
        DKUtils.ExecutionResults executionResults = DKUtils.execAndGetOutputAndErrors((String[])importCommand, new HashMap());
        logger.infoV("Import command stdout: %s", new Object[]{executionResults.out});
        logger.infoV("Import command stderr: %s", new Object[]{executionResults.err});
        if (executionResults.rv != 0 && smartLogTail != null) {
            smartLogTail.appendLine("VHD import to managed image failed with return code=" + executionResults.rv);
            smartLogTail.appendLine("Image import log: " + executionResults.out);
            smartLogTail.appendLine("Errors during image import: " + executionResults.err);
        }
        if (executionResults.rv != 0) {
            throw new ImageBuildException("VHD import to managed image failed with return code=" + executionResults.rv, null, smartLogTail.get());
        }
        if (smartLogTail != null) {
            smartLogTail.appendLine("Image built.");
        }
    }

    public String cacheAndGetVirtualMachineCustomImage(CloudAccount account, FMSettings settings, InstanceImagesSettings.AzureInstanceImageReference reference, String region, DKUtils.SmartLogTailBuilder smartLogTail) {
        AzureResourceManager azure = this.clientService.getAzureClient(account);
        String imageCacheResourceGroup = account.getAzureImageResourceGroup();
        if (StringUtils.isEmpty((CharSequence)imageCacheResourceGroup)) {
            throw new IllegalArgumentException("No Resource group specified for Image cache.");
        }
        if (smartLogTail != null) {
            smartLogTail.appendLine("Looking for image cache in " + imageCacheResourceGroup + " in region " + region);
        }
        String azureManagedImageName = "fm_cache_" + region + "_" + DKUApp.getInstallId() + reference.azureImageMetadata.imageNameSuffix;
        String azureManagedDiskName = azureManagedImageName.replaceAll("[\\.|-]", "_");
        Tenant tenant = account.getTenant();
        CloudTagList tenantTags = null;
        if (tenant != null) {
            tenantTags = tenant.getCloudApplicableTags();
        } else if (settings.tenancy == FMTenancy.MONOTENANT) {
            try {
                Tenant dbTenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)"main");
                assert (dbTenant != null);
                tenantTags = dbTenant.getCloudApplicableTags();
            }
            catch (Exception e) {
                logger.warnV((Throwable)e, "Unable to retrieve the cloud tags from Tenant %s", new Object[]{"main"});
            }
        } else {
            logger.debug((Object)"FM tenancy is not mono-tenant and no tenant was given, skipping passing the tenant tags to the images.");
        }
        String imageTags = Stream.concat(Stream.of(new CloudTag("FMSourceInstallId", DKUApp.getInstallId())), Optional.ofNullable(tenantTags).orElse(new CloudTagList()).stream()).map(cloudTag -> String.format("%s%s", cloudTag.key, StringUtils.isBlank((CharSequence)cloudTag.value) ? "" : "=" + cloudTag.value)).collect(Collectors.joining(","));
        switch (settings.azureSettings.VHDCacheMethod) {
            case MANAGED_IMAGE: {
                String azureManagedImageResourceId = "/subscriptions/" + account.getAzureSubscription() + "/resourceGroups/" + imageCacheResourceGroup + "/providers/Microsoft.Compute/images/" + azureManagedImageName;
                this.doubleCheckedLockingOnResourceExistence(() -> {
                    azure.virtualMachineCustomImages().getByResourceGroup(imageCacheResourceGroup, azureManagedImageName);
                    if (smartLogTail != null) {
                        smartLogTail.appendLine("Image found: " + azureManagedImageResourceId);
                    }
                }, () -> this.buildImportCommand(account, false, region, azureManagedDiskName, imageCacheResourceGroup, reference, azureManagedImageResourceId, settings.proxySettings, smartLogTail, imageTags));
                return azureManagedImageResourceId;
            }
            case SHARED_IMAGE_GALLERY: {
                String azureGalleryName = "fm_cache_" + DKUApp.getInstallId();
                String azureImageDefinitionName = reference.azureImageMetadata.publisher + "-" + reference.azureImageMetadata.offer + "-" + reference.azureImageMetadata.SKU;
                String azureImageVersionName = reference.azureImageMetadata.version;
                String azureManagedImageResourceId = "/subscriptions/" + account.getAzureSubscription() + "/resourceGroups/" + imageCacheResourceGroup + "/providers/Microsoft.Compute/galleries/" + azureGalleryName + "/images/" + azureImageDefinitionName + "/versions/" + azureImageVersionName;
                this.doubleCheckedLockingOnResourceExistence(() -> {
                    azure.galleryImageVersions().getByGalleryImage(imageCacheResourceGroup, azureGalleryName, azureImageDefinitionName, azureImageVersionName);
                    if (smartLogTail != null) {
                        smartLogTail.appendLine("Image found: " + azureManagedImageResourceId);
                    }
                }, () -> this.buildImportCommand(account, true, region, azureManagedDiskName, imageCacheResourceGroup, reference, azureManagedImageResourceId, settings.proxySettings, smartLogTail, imageTags));
                return azureManagedImageResourceId;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doubleCheckedLockingOnResourceExistence(Runnable resourceExistenceCheck, CheckedRunnable effect) {
        BooleanSupplier resourceNotFound = () -> {
            try {
                resourceExistenceCheck.run();
                return false;
            }
            catch (ApiErrorException e) {
                if (e.getResponse().getStatusCode() == 404) {
                    return true;
                }
                throw e;
            }
        };
        if (resourceNotFound.getAsBoolean()) {
            AzureImageCacheService azureImageCacheService = this;
            synchronized (azureImageCacheService) {
                if (resourceNotFound.getAsBoolean()) {
                    try {
                        effect.run();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    public static class ImageBuildException
    extends RuntimeException
    implements ExceptionWithLogTail {
        private static final long serialVersionUID = 1L;
        private final SmartLogTail logTail;

        public ImageBuildException(String message, Throwable cause, SmartLogTail logTail) {
            super(message, cause);
            this.logTail = logTail;
        }

        public SmartLogTail getLogTail() {
            return this.logTail;
        }
    }

    private static interface CheckedRunnable {
        public void run() throws Exception;
    }
}

