/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud.gcp;

import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.dataiku.dss.shadelib.com.google.api.client.http.AbstractHttpContent;
import com.dataiku.dss.shadelib.com.google.api.client.http.GenericUrl;
import com.dataiku.dss.shadelib.com.google.api.client.http.HttpBackOffIOExceptionHandler;
import com.dataiku.dss.shadelib.com.google.api.client.http.HttpContent;
import com.dataiku.dss.shadelib.com.google.api.client.http.HttpHeaders;
import com.dataiku.dss.shadelib.com.google.api.client.http.HttpIOExceptionHandler;
import com.dataiku.dss.shadelib.com.google.api.client.http.HttpRequest;
import com.dataiku.dss.shadelib.com.google.api.client.http.HttpRequestFactory;
import com.dataiku.dss.shadelib.com.google.api.client.http.HttpResponse;
import com.dataiku.dss.shadelib.com.google.api.client.util.BackOff;
import com.dataiku.dss.shadelib.com.google.api.client.util.ExponentialBackOff;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.com.google.common.collect.Maps;
import com.dataiku.dss.shadelib.com.google.gson.Gson;
import com.dataiku.fm.cloud.gcp.GCPConflictException;
import com.dataiku.fm.cloud.gcp.GCPException;
import com.dataiku.fm.cloud.gcp.GCPNotFoundException;
import com.dataiku.fm.cloud.gcp.GoogleCloudUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class GCPClient {
    private static final Map<String, String> EMPTY_MAP = null;
    protected final String userAgent;
    protected final GoogleCredential credentials;
    protected final ProxySettings proxySettings;
    protected HttpRequestFactory requestFactory;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.gcp.client");

    public GCPClient(GoogleCredential credentials, ProxySettings proxySettings, String userAgent) {
        Preconditions.checkNotNull((Object)credentials, (Object)"credentials");
        this.credentials = credentials;
        this.proxySettings = proxySettings;
        this.userAgent = userAgent;
    }

    public abstract String getApiRoot();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpRequestFactory getRequestFactory() throws GCPException, IOException, GeneralSecurityException {
        if (this.requestFactory == null) {
            GCPClient gCPClient = this;
            synchronized (gCPClient) {
                this.requestFactory = GoogleCloudUtils.buildRequestFactory(this.proxySettings, this.credentials, false);
            }
        }
        return this.requestFactory;
    }

    protected <T> T sendGet(String projectId, String path, Class<T> clazz) throws IOException, GCPException, GeneralSecurityException {
        return this.sendGet(projectId, path, EMPTY_MAP, clazz);
    }

    protected <T> T sendGet(String projectId, String path, Map<String, String> map, Class<T> clazz) throws IOException, GCPException, GeneralSecurityException {
        HttpRequest request = this.getRequestFactory().buildGetRequest(this.buildUrlInProject(projectId, path, map));
        return this.sendRequest(request, clazz);
    }

    protected <T> T sendPost(String projectId, String path, Object body, Class<T> clazz) throws IOException, GCPException, GeneralSecurityException {
        return this.sendPost(projectId, path, EMPTY_MAP, body, clazz);
    }

    protected <T> T sendPost(String projectId, String path, Map<String, String> map, Object body, Class<T> clazz) throws IOException, GCPException, GeneralSecurityException {
        HttpRequest request = this.getRequestFactory().buildPostRequest(this.buildUrlInProject(projectId, path, map), (HttpContent)new JsonHttpContent(body));
        return this.sendRequest(request, clazz);
    }

    protected <T> T sendDelete(String projectId, String path, Class<T> clazz) throws IOException, GCPException, GeneralSecurityException {
        return this.sendDelete(projectId, path, EMPTY_MAP, clazz);
    }

    protected <T> T sendDelete(String projectId, String path, Map<String, String> map, Class<T> clazz) throws IOException, GCPException, GeneralSecurityException {
        HttpRequest request = this.getRequestFactory().buildDeleteRequest(this.buildUrlInProject(projectId, path, map));
        return this.sendRequest(request, clazz);
    }

    protected <T> T sendRequest(HttpRequest request, Class<T> clazz) throws GCPException, IOException {
        logger.debug((Object)(request.getRequestMethod() + " " + String.valueOf(request.getUrl())));
        request.setThrowExceptionOnExecuteError(false);
        request.setIOExceptionHandler((HttpIOExceptionHandler)new HttpBackOffIOExceptionHandler((BackOff)new ExponentialBackOff()));
        if (this.userAgent != null) {
            request.setHeaders(new HttpHeaders().setUserAgent(this.userAgent));
        }
        HttpResponse response = request.execute();
        try {
            String responseBody = response.parseAsString();
            if (response.isSuccessStatusCode()) {
                Object object = clazz != null ? JSON.parse((String)responseBody, clazz) : null;
                return (T)object;
            }
            if (responseBody != null && responseBody.startsWith("{")) {
                try {
                    logger.error((Object)("GCP error " + responseBody));
                    GoogleCloudUtils.GoogleCloudErrorResponse errorResponse = (GoogleCloudUtils.GoogleCloudErrorResponse)JSON.parse((String)responseBody, GoogleCloudUtils.GoogleCloudErrorResponse.class);
                    GoogleCloudUtils.GoogleCloudError error = errorResponse != null ? errorResponse.error : null;
                    int errorCode = error == null ? 0 : errorResponse.error.code;
                    throw GCPClient.newGCPException(errorCode, GoogleCloudUtils.extractMessage(errorResponse), error);
                }
                catch (RuntimeException e) {
                    logger.info((Object)"Failed to decode JSON error", (Throwable)e);
                }
            }
            throw GCPClient.newGCPException(response.getStatusCode(), GoogleCloudUtils.extractErrorMessage(response, responseBody), null);
        }
        finally {
            response.disconnect();
        }
    }

    private static GCPException newGCPException(int errorCode, String errorMesssage, GoogleCloudUtils.GoogleCloudError error) {
        switch (errorCode) {
            case 404: {
                return new GCPNotFoundException(errorCode, errorMesssage);
            }
            case 409: {
                return new GCPConflictException(errorCode, errorMesssage);
            }
        }
        return new GCPException(errorCode, errorMesssage, error);
    }

    private static GenericUrl buildUrl(String apiRoot, String query, Map<String, String> map) {
        String uri = apiRoot + query;
        GenericUrl url = new GenericUrl(uri);
        if (map != null) {
            url.putAll(map);
        }
        return url;
    }

    private GenericUrl buildUrlInProject(String projectId, String query, Map<String, String> map) {
        return GCPClient.buildUrl(this.getApiRoot(), "projects/" + projectId + "/" + query, map);
    }

    private static String encodePath(String ... items) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < items.length; ++i) {
            if (i > 0) {
                result.append("/");
            }
            result.append(GCPClient.urlEncode(items[i]));
        }
        return result.toString();
    }

    private static String encodeQueryString(Map<String, String> items) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> e : items.entrySet()) {
            result.append(result.length() == 0 ? "?" : "&");
            result.append(GCPClient.urlEncode(e.getKey()));
            result.append("=");
            result.append(GCPClient.urlEncode(e.getValue()));
        }
        return result.toString();
    }

    private static String urlEncode(String item) throws UnsupportedEncodingException {
        return URLEncoder.encode(item, "UTF-8");
    }

    protected static void checkArgumentNotBlank(String paramValue, String paramName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)paramValue), (Object)(paramName + " cannot be null or empty."));
    }

    protected static <T> void checkArgumentNotEmpty(List<T> paramValue, String paramName) {
        Preconditions.checkArgument((paramValue != null && !paramValue.isEmpty() ? 1 : 0) != 0, (Object)(paramName + " cannot be null or empty."));
    }

    protected static void checkArgumentGcsUris(List<String> gcsUris, String parameterName) {
        for (int i = 0; i < gcsUris.size(); ++i) {
            String uri = gcsUris.get(i);
            GCPClient.checkArgumentNotBlank(uri, parameterName + "[" + i + "]");
            Preconditions.checkArgument((boolean)uri.startsWith("gs://"), (Object)(parameterName + "[" + i + "] must start with 'gs://'"));
        }
    }

    public <T> T listAny(String projectId, String objectDisplayName, String path, int pageSize, String pageToken, Class<T> clazz) throws GCPException {
        HashMap arguments = Maps.newHashMap();
        if (pageSize > 0) {
            arguments.put("pageSize", String.valueOf(pageSize));
        }
        if (StringUtils.isNotBlank((CharSequence)pageToken)) {
            arguments.put("pageToken", pageToken);
        }
        try {
            return this.sendGet(projectId, path, arguments, clazz);
        }
        catch (GCPException e) {
            throw e;
        }
        catch (Exception e) {
            String errorMessage = String.format("Could not list %s. Reason: %s", objectDisplayName, ExceptionUtils.getMessageWithCauses((Throwable)e));
            logger.error((Object)errorMessage, (Throwable)e);
            throw new GCPException(errorMessage, e);
        }
    }

    public <T, P extends PagedList> List<T> listAny(GetPage<P> getPage, Function<P, List<T>> getItems) throws GCPException {
        Object page = null;
        ArrayList ret = Lists.newArrayList();
        do {
            page = getPage.get(page == null ? null : page.nextPageToken);
            ret.addAll((Collection)getItems.apply(page));
        } while (page != null && page.nextPageToken != null);
        return ret;
    }

    private static class JsonHttpContent
    extends AbstractHttpContent {
        private final String data;

        public JsonHttpContent(Object data) {
            super("application/json; charset=UTF-8");
            this.data = data != null ? new Gson().toJson(data) : null;
        }

        public void writeTo(OutputStream out) throws IOException {
            if (this.data != null) {
                out.write(this.data.getBytes(Charsets.UTF_8));
            }
        }
    }

    public static class PagedList {
        public String nextPageToken;
    }

    public static interface GetPage<T extends PagedList> {
        public T get(String var1) throws GCPException;
    }
}

