/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud.gcp;

import com.dataiku.fm.cloud.gcp.GoogleCloudUtils;
import java.io.IOException;

public class GCPException
extends IOException {
    private static final long serialVersionUID = 90798094194L;
    private final int code;
    private final GoogleCloudUtils.GoogleCloudError error;
    public static final String RATE_LIMIT_EXCEPTION_MESSAGE = "rateLimitExceeded";

    public GCPException(int code, String message, Throwable cause) {
        super(message, cause);
        this.code = code;
        this.error = null;
    }

    public GCPException(int code, String message, GoogleCloudUtils.GoogleCloudError error) {
        super(message);
        this.code = code;
        this.error = error;
    }

    public GCPException(int code, String message) {
        super(message);
        this.code = code;
        this.error = null;
    }

    public GCPException(String message, Throwable cause) {
        super(message, cause);
        this.code = 0;
        this.error = null;
    }

    public GCPException(String message) {
        super(message);
        this.code = 0;
        this.error = null;
    }

    public int getCode() {
        return this.code;
    }

    public GoogleCloudUtils.GoogleCloudError getError() {
        return this.error;
    }

    public boolean containsRateLimitError() {
        if (this.getError() != null) {
            for (GoogleCloudUtils.GoogleCloudSubError googleCloudSubError : this.getError().errors) {
                if (!googleCloudSubError.reason.contains(RATE_LIMIT_EXCEPTION_MESSAGE)) continue;
                return true;
            }
        }
        return false;
    }

    public static GCPException toKMSException(Exception e) {
        if (e instanceof GCPException) {
            return (GCPException)e;
        }
        return new GCPException(e.getMessage(), e);
    }
}

