/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.license;

import java.nio.charset.StandardCharsets;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class LicenseRequestUtils {
    private static final String DKU1_HMAC_SHA256 = "DKU1-HMAC-SHA256";
    private static final String URL_PATH = "/api/comm/managed/instance/license";
    private static final String SERVICE = "licenseserver";
    private static final long MAX_TIME_DRIFT = 300000L;

    private static byte[] hmacSHA256(String data, byte[] key) {
        try {
            String algorithm = "HmacSHA256";
            Mac mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(key, algorithm));
            return mac.doFinal(data.getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new RuntimeException("internal error", e);
        }
    }

    private static Credentials decodeToken(String encodedToken) {
        String idAndToken = new String(Base64.decodeBase64((String)encodedToken), StandardCharsets.UTF_8);
        Credentials creds = new Credentials();
        creds.id = idAndToken.split(":")[0];
        creds.token = idAndToken.split(":")[1];
        return creds;
    }

    private static String computeStringToSign(long date) {
        return "DKU1-HMAC-SHA256\n" + date + "\nGET /api/comm/managed/instance/license";
    }

    private static byte[] computeSigningKey(String token) {
        byte[] kSecret = ("DKU1" + token).getBytes(StandardCharsets.UTF_8);
        byte[] signingKey = LicenseRequestUtils.hmacSHA256(SERVICE, kSecret);
        return signingKey;
    }

    private static String sign(String stringToSign, byte[] signingKey) {
        return Hex.encodeHexString((byte[])LicenseRequestUtils.hmacSHA256(stringToSign, signingKey));
    }

    public static LicenseRequest buildRequest(String encodedToken) {
        Credentials creds = LicenseRequestUtils.decodeToken(encodedToken);
        long now = System.currentTimeMillis();
        String stringToSign = LicenseRequestUtils.computeStringToSign(now);
        byte[] signingKey = LicenseRequestUtils.computeSigningKey(creds.token);
        String signature = LicenseRequestUtils.sign(stringToSign, signingKey);
        LicenseRequest req = new LicenseRequest();
        req.version = DKU1_HMAC_SHA256;
        req.date = now;
        req.id = creds.id;
        req.signature = signature;
        return req;
    }

    public static void verifyRequest(LicenseRequest request, String expectedToken) {
        byte[] signingKey;
        long serverNow = System.currentTimeMillis();
        if (Math.abs(serverNow - request.date) > 300000L) {
            throw new RuntimeException("denied");
        }
        if (!DKU1_HMAC_SHA256.equals(request.version)) {
            throw new RuntimeException("denied");
        }
        String stringToSign = LicenseRequestUtils.computeStringToSign(request.date);
        String signature = LicenseRequestUtils.sign(stringToSign, signingKey = LicenseRequestUtils.computeSigningKey(expectedToken));
        if (!signature.equals(request.signature)) {
            throw new RuntimeException("denied");
        }
    }

    private static class Credentials {
        String id;
        String token;

        private Credentials() {
        }
    }

    public static class LicenseRequest {
        String version;
        String id;
        long date;
        String signature;
    }
}

