/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.model;

import com.dataiku.dip.utils.JSON;
import com.dataiku.fm.server.agentapi.AgentAPIController;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

public class Utils {
    private Utils() {
    }

    public static <T> T getConfiguration(String configuration, Class<T> expectedConfigurationClass) {
        return (T)JSON.parse((String)configuration, expectedConfigurationClass);
    }

    public static Optional<Double> computeUsagePercentage(Long bytesUsed, Long bytesTotal) {
        if (bytesUsed == null || bytesTotal == null) {
            return Optional.empty();
        }
        return Optional.of((double)bytesUsed.longValue() / (double)bytesTotal.longValue() * 100.0);
    }

    public static int convertMinutesInMilliseconds(int minutes) {
        return Utils.convertSecondsInMilliseconds(minutes * 60);
    }

    public static int convertSecondsInMilliseconds(int seconds) {
        return seconds * 1000;
    }

    public static AgentAPIController.HeartbeatState parseHeartbeatState(String heartbeatState) {
        return StringUtils.isBlank((String)heartbeatState) ? null : (AgentAPIController.HeartbeatState)JSON.parse((String)heartbeatState, AgentAPIController.HeartbeatState.class);
    }
}

