/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.model.db;

import com.dataiku.fm.model.db.CheckReporter;
import com.dataiku.fm.model.db.CheckType;
import com.dataiku.fm.model.db.Tenant;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.UniqueConstraint;
import java.util.HashSet;
import java.util.Set;

@Entity(name="checkdefinition")
public class CheckDefinition {
    private static final int GRACE_PERIOD_IN_SEC_DEFAULT = 300;
    private static final int RESEND_NOTIFICATION_PERIOD_IN_SEC_DEFAULT = 3600;
    @Id
    private String id;
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private Tenant tenant;
    @Enumerated(value=EnumType.STRING)
    private CheckType type;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="checkdefinition_checkreporter", joinColumns={@JoinColumn(name="checkdefinition_id")}, inverseJoinColumns={@JoinColumn(name="checkreporter_id")}, uniqueConstraints={@UniqueConstraint(name="uk_cr_cd", columnNames={"checkreporter_id", "checkdefinition_id"})})
    private Set<CheckReporter> checkReporters = new HashSet<CheckReporter>();
    private int gracePeriodInSec = 300;
    private int resendNotificationPeriodInSec = 3600;
    @Column
    private int configurationVersion;
    @Column(columnDefinition="text")
    private String configuration;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Tenant getTenant() {
        return this.tenant;
    }

    public void setTenant(Tenant tenant) {
        this.tenant = tenant;
    }

    public CheckType getType() {
        return this.type;
    }

    public void setType(CheckType type) {
        this.type = type;
    }

    public Set<CheckReporter> getCheckReporters() {
        return this.checkReporters;
    }

    public void setCheckReporters(Set<CheckReporter> checkReporters) {
        this.checkReporters = checkReporters;
    }

    public int getGracePeriodInSec() {
        return this.gracePeriodInSec;
    }

    public void setGracePeriodInSec(int gracePeriodInSec) {
        this.gracePeriodInSec = gracePeriodInSec;
    }

    public int getResendNotificationPeriodInSec() {
        return this.resendNotificationPeriodInSec;
    }

    public void setResendNotificationPeriodInSec(int resendNotificationPeriodInSec) {
        this.resendNotificationPeriodInSec = resendNotificationPeriodInSec;
    }

    public int getConfigurationVersion() {
        return this.configurationVersion;
    }

    public void setConfigurationVersion(int configurationVersion) {
        this.configurationVersion = configurationVersion;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }
}

